/*
 * Decompiled with CFR 0.152.
 */
package org.nanohttpd.protocols.http.response;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    public ChunkedOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] data = new byte[]{(byte)b2};
        this.write(data, 0, 1);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.out.write(String.format("%x\r\n", len).getBytes());
        this.out.write(b2, off, len);
        this.out.write("\r\n".getBytes());
    }

    public void finish() throws IOException {
        this.out.write("0\r\n\r\n".getBytes());
    }
}

