/*
 * Decompiled with CFR 0.152.
 */
package org.nanohttpd.protocols.http;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.net.ssl.SSLException;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.NanoHTTPD;
import org.nanohttpd.protocols.http.content.ContentType;
import org.nanohttpd.protocols.http.content.CookieHandler;
import org.nanohttpd.protocols.http.request.Method;
import org.nanohttpd.protocols.http.response.IStatus;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;
import org.nanohttpd.protocols.http.tempfiles.ITempFile;
import org.nanohttpd.protocols.http.tempfiles.ITempFileManager;

public class HTTPSession
implements IHTTPSession {
    public static final String POST_DATA = "postData";
    private static final int REQUEST_BUFFER_LEN = 512;
    private static final int MEMORY_STORE_LIMIT = 1024;
    public static final int BUFSIZE = 8192;
    public static final int MAX_HEADER_SIZE = 1024;
    private final NanoHTTPD httpd;
    private final ITempFileManager tempFileManager;
    private final OutputStream outputStream;
    private final BufferedInputStream inputStream;
    private int splitbyte;
    private int rlen;
    private String uri;
    private Method method;
    private Map<String, List<String>> parms;
    private Map<String, String> headers;
    private CookieHandler cookies;
    private String queryParameterString;
    private String remoteIp;
    private String protocolVersion;

    public HTTPSession(NanoHTTPD httpd, ITempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream) {
        this.httpd = httpd;
        this.tempFileManager = tempFileManager;
        this.inputStream = new BufferedInputStream(inputStream, 8192);
        this.outputStream = outputStream;
    }

    public HTTPSession(NanoHTTPD httpd, ITempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
        this.httpd = httpd;
        this.tempFileManager = tempFileManager;
        this.inputStream = new BufferedInputStream(inputStream, 8192);
        this.outputStream = outputStream;
        this.remoteIp = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "127.0.0.1" : inetAddress.getHostAddress().toString();
        this.headers = new HashMap<String, String>();
    }

    private void decodeHeader(BufferedReader in, Map<String, String> pre, Map<String, List<String>> parms, Map<String, String> headers) throws NanoHTTPD.ResponseException {
        try {
            String inLine = in.readLine();
            if (inLine == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(inLine);
            if (!st.hasMoreTokens()) {
                throw new NanoHTTPD.ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
            }
            pre.put("method", st.nextToken());
            if (!st.hasMoreTokens()) {
                throw new NanoHTTPD.ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
            }
            String uri = st.nextToken();
            int qmi = uri.indexOf(63);
            if (qmi >= 0) {
                this.decodeParms(uri.substring(qmi + 1), parms);
                uri = NanoHTTPD.decodePercent(uri.substring(0, qmi));
            } else {
                uri = NanoHTTPD.decodePercent(uri);
            }
            if (st.hasMoreTokens()) {
                this.protocolVersion = st.nextToken();
            } else {
                this.protocolVersion = "HTTP/1.1";
                NanoHTTPD.LOG.log(Level.FINE, "no protocol version specified, strange. Assuming HTTP/1.1.");
            }
            String line = in.readLine();
            while (line != null && !line.trim().isEmpty()) {
                int p = line.indexOf(58);
                if (p >= 0) {
                    headers.put(line.substring(0, p).trim().toLowerCase(Locale.US), line.substring(p + 1).trim());
                }
                line = in.readLine();
            }
            pre.put("uri", uri);
        }
        catch (IOException ioe) {
            throw new NanoHTTPD.ResponseException(Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage(), ioe);
        }
    }

    private void decodeMultipartFormData(ContentType contentType, ByteBuffer fbuf, Map<String, List<String>> parms, Map<String, String> files) throws NanoHTTPD.ResponseException {
        int pcount = 0;
        try {
            int[] boundaryIdxs = this.getBoundaryPositions(fbuf, contentType.getBoundary().getBytes());
            if (boundaryIdxs.length < 2) {
                throw new NanoHTTPD.ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but contains less than two boundary strings.");
            }
            byte[] partHeaderBuff = new byte[1024];
            for (int boundaryIdx = 0; boundaryIdx < boundaryIdxs.length - 1; ++boundaryIdx) {
                fbuf.position(boundaryIdxs[boundaryIdx]);
                int len = fbuf.remaining() < 1024 ? fbuf.remaining() : 1024;
                fbuf.get(partHeaderBuff, 0, len);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(partHeaderBuff, 0, len), Charset.forName(contentType.getEncoding())), len);
                int headerLines = 0;
                String mpline = in.readLine();
                ++headerLines;
                if (mpline == null || !mpline.contains(contentType.getBoundary())) {
                    throw new NanoHTTPD.ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but chunk does not start with boundary.");
                }
                String partName = null;
                String fileName = null;
                String partContentType = null;
                mpline = in.readLine();
                ++headerLines;
                while (mpline != null && mpline.trim().length() > 0) {
                    Matcher matcher = NanoHTTPD.CONTENT_DISPOSITION_PATTERN.matcher(mpline);
                    if (matcher.matches()) {
                        String attributeString = matcher.group(2);
                        matcher = NanoHTTPD.CONTENT_DISPOSITION_ATTRIBUTE_PATTERN.matcher(attributeString);
                        while (matcher.find()) {
                            String key = matcher.group(1);
                            if ("name".equalsIgnoreCase(key)) {
                                partName = matcher.group(2);
                                continue;
                            }
                            if (!"filename".equalsIgnoreCase(key) || (fileName = matcher.group(2)).isEmpty()) continue;
                            if (pcount > 0) {
                                partName = partName + String.valueOf(pcount++);
                                continue;
                            }
                            ++pcount;
                        }
                    }
                    if ((matcher = NanoHTTPD.CONTENT_TYPE_PATTERN.matcher(mpline)).matches()) {
                        partContentType = matcher.group(2).trim();
                    }
                    mpline = in.readLine();
                    ++headerLines;
                }
                int partHeaderLength = 0;
                while (headerLines-- > 0) {
                    partHeaderLength = this.scipOverNewLine(partHeaderBuff, partHeaderLength);
                }
                if (partHeaderLength >= len - 4) {
                    throw new NanoHTTPD.ResponseException(Status.INTERNAL_ERROR, "Multipart header size exceeds MAX_HEADER_SIZE.");
                }
                int partDataStart = boundaryIdxs[boundaryIdx] + partHeaderLength;
                int partDataEnd = boundaryIdxs[boundaryIdx + 1] - 4;
                fbuf.position(partDataStart);
                List<String> values = parms.get(partName);
                if (values == null) {
                    values = new ArrayList<String>();
                    parms.put(partName, values);
                }
                if (partContentType == null) {
                    byte[] data_bytes = new byte[partDataEnd - partDataStart];
                    fbuf.get(data_bytes);
                    values.add(new String(data_bytes, contentType.getEncoding()));
                    continue;
                }
                String path = this.saveTmpFile(fbuf, partDataStart, partDataEnd - partDataStart, fileName);
                if (!files.containsKey(partName)) {
                    files.put(partName, path);
                } else {
                    int count = 2;
                    while (files.containsKey(partName + count)) {
                        ++count;
                    }
                    files.put(partName + count, path);
                }
                values.add(fileName);
            }
        }
        catch (NanoHTTPD.ResponseException re) {
            throw re;
        }
        catch (Exception e) {
            throw new NanoHTTPD.ResponseException(Status.INTERNAL_ERROR, e.toString());
        }
    }

    private int scipOverNewLine(byte[] partHeaderBuff, int index) {
        while (partHeaderBuff[index] != 10) {
            ++index;
        }
        return ++index;
    }

    private void decodeParms(String parms, Map<String, List<String>> p) {
        if (parms == null) {
            this.queryParameterString = "";
            return;
        }
        this.queryParameterString = parms;
        StringTokenizer st = new StringTokenizer(parms, "&");
        while (st.hasMoreTokens()) {
            String e = st.nextToken();
            int sep = e.indexOf(61);
            String key = null;
            String value = null;
            if (sep >= 0) {
                key = NanoHTTPD.decodePercent(e.substring(0, sep)).trim();
                value = NanoHTTPD.decodePercent(e.substring(sep + 1));
            } else {
                key = NanoHTTPD.decodePercent(e).trim();
                value = "";
            }
            List<String> values = p.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                p.put(key, values);
            }
            values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws IOException {
        Response r = null;
        try {
            byte[] buf = new byte[8192];
            this.splitbyte = 0;
            this.rlen = 0;
            int read = -1;
            this.inputStream.mark(8192);
            try {
                read = this.inputStream.read(buf, 0, 8192);
            }
            catch (SSLException e) {
                throw e;
            }
            catch (IOException e) {
                NanoHTTPD.safeClose(this.inputStream);
                NanoHTTPD.safeClose(this.outputStream);
                throw new SocketException("NanoHttpd Shutdown");
            }
            if (read == -1) {
                NanoHTTPD.safeClose(this.inputStream);
                NanoHTTPD.safeClose(this.outputStream);
                throw new SocketException("NanoHttpd Shutdown");
            }
            while (read > 0) {
                this.rlen += read;
                this.splitbyte = this.findHeaderEnd(buf, this.rlen);
                if (this.splitbyte > 0) break;
                read = this.inputStream.read(buf, this.rlen, 8192 - this.rlen);
            }
            if (this.splitbyte < this.rlen) {
                this.inputStream.reset();
                this.inputStream.skip(this.splitbyte);
            }
            this.parms = new HashMap<String, List<String>>();
            if (null == this.headers) {
                this.headers = new HashMap<String, String>();
            } else {
                this.headers.clear();
            }
            BufferedReader hin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, 0, this.rlen)));
            HashMap<String, String> pre = new HashMap<String, String>();
            this.decodeHeader(hin, pre, this.parms, this.headers);
            if (null != this.remoteIp) {
                this.headers.put("remote-addr", this.remoteIp);
                this.headers.put("http-client-ip", this.remoteIp);
            }
            this.method = Method.lookup((String)pre.get("method"));
            if (this.method == null) {
                throw new NanoHTTPD.ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Syntax error. HTTP verb " + (String)pre.get("method") + " unhandled.");
            }
            this.uri = (String)pre.get("uri");
            this.cookies = new CookieHandler(this.headers);
            String connection = this.headers.get("connection");
            boolean keepAlive = "HTTP/1.1".equals(this.protocolVersion) && (connection == null || !connection.matches("(?i).*close.*"));
            r = this.httpd.handle(this);
            if (r == null) {
                throw new NanoHTTPD.ResponseException(Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
            }
            String acceptEncoding = this.headers.get("accept-encoding");
            this.cookies.unloadQueue(r);
            r.setRequestMethod(this.method);
            if (acceptEncoding == null || !acceptEncoding.contains("gzip")) {
                r.setUseGzip(false);
            }
            r.setKeepAlive(keepAlive);
            r.send(this.outputStream);
            if (!keepAlive) throw new SocketException("NanoHttpd Shutdown");
            if (r.isCloseConnection()) {
                throw new SocketException("NanoHttpd Shutdown");
            }
            NanoHTTPD.safeClose(r);
            this.tempFileManager.clear();
            return;
        }
        catch (SocketException e) {
            throw e;
            catch (SocketTimeoutException ste) {
                throw ste;
            }
            catch (SSLException ssle) {
                Response resp = Response.newFixedLengthResponse((IStatus)Status.INTERNAL_ERROR, "text/plain", "SSL PROTOCOL FAILURE: " + ssle.getMessage());
                resp.send(this.outputStream);
                NanoHTTPD.safeClose(this.outputStream);
                return;
            }
            catch (IOException ioe) {
                Response resp = Response.newFixedLengthResponse((IStatus)Status.INTERNAL_ERROR, "text/plain", "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                resp.send(this.outputStream);
                NanoHTTPD.safeClose(this.outputStream);
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (NanoHTTPD.ResponseException re) {
                    resp = Response.newFixedLengthResponse((IStatus)re.getStatus(), "text/plain", re.getMessage());
                    resp.send(this.outputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    return;
                }
            }
        }
        finally {
            NanoHTTPD.safeClose(r);
            this.tempFileManager.clear();
        }
    }

    private int findHeaderEnd(byte[] buf, int rlen) {
        int splitbyte = 0;
        while (splitbyte + 1 < rlen) {
            if (buf[splitbyte] == 13 && buf[splitbyte + 1] == 10 && splitbyte + 3 < rlen && buf[splitbyte + 2] == 13 && buf[splitbyte + 3] == 10) {
                return splitbyte + 4;
            }
            if (buf[splitbyte] == 10 && buf[splitbyte + 1] == 10) {
                return splitbyte + 2;
            }
            ++splitbyte;
        }
        return 0;
    }

    private int[] getBoundaryPositions(ByteBuffer b2, byte[] boundary) {
        int[] res = new int[]{};
        if (b2.remaining() < boundary.length) {
            return res;
        }
        int search_window_pos = 0;
        byte[] search_window = new byte[4096 + boundary.length];
        int first_fill = b2.remaining() < search_window.length ? b2.remaining() : search_window.length;
        b2.get(search_window, 0, first_fill);
        int new_bytes = first_fill - boundary.length;
        do {
            for (int j = 0; j < new_bytes; ++j) {
                for (int i = 0; i < boundary.length && search_window[j + i] == boundary[i]; ++i) {
                    if (i != boundary.length - 1) continue;
                    int[] new_res = new int[res.length + 1];
                    System.arraycopy(res, 0, new_res, 0, res.length);
                    new_res[res.length] = search_window_pos + j;
                    res = new_res;
                }
            }
            search_window_pos += new_bytes;
            System.arraycopy(search_window, search_window.length - boundary.length, search_window, 0, boundary.length);
            new_bytes = search_window.length - boundary.length;
            new_bytes = b2.remaining() < new_bytes ? b2.remaining() : new_bytes;
            b2.get(search_window, boundary.length, new_bytes);
        } while (new_bytes > 0);
        return res;
    }

    @Override
    public CookieHandler getCookies() {
        return this.cookies;
    }

    @Override
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public final Method getMethod() {
        return this.method;
    }

    @Override
    @Deprecated
    public final Map<String, String> getParms() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.parms.keySet()) {
            result.put(key, this.parms.get(key).get(0));
        }
        return result;
    }

    @Override
    public final Map<String, List<String>> getParameters() {
        return this.parms;
    }

    @Override
    public String getQueryParameterString() {
        return this.queryParameterString;
    }

    private RandomAccessFile getTmpBucket() {
        try {
            ITempFile tempFile = this.tempFileManager.createTempFile(null);
            return new RandomAccessFile(tempFile.getName(), "rw");
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final String getUri() {
        return this.uri;
    }

    public long getBodySize() {
        if (this.headers.containsKey("content-length")) {
            return Long.parseLong(this.headers.get("content-length"));
        }
        if (this.splitbyte < this.rlen) {
            return this.rlen - this.splitbyte;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseBody(Map<String, String> files) throws IOException, NanoHTTPD.ResponseException {
        RandomAccessFile randomAccessFile = null;
        try {
            long size = this.getBodySize();
            ByteArrayOutputStream baos = null;
            DataOutput requestDataOutput = null;
            if (size < 1024L) {
                baos = new ByteArrayOutputStream();
                requestDataOutput = new DataOutputStream(baos);
            } else {
                randomAccessFile = this.getTmpBucket();
                requestDataOutput = randomAccessFile;
            }
            byte[] buf = new byte[512];
            while (this.rlen >= 0 && size > 0L) {
                this.rlen = this.inputStream.read(buf, 0, (int)Math.min(size, 512L));
                size -= (long)this.rlen;
                if (this.rlen <= 0) continue;
                requestDataOutput.write(buf, 0, this.rlen);
            }
            ByteBuffer fbuf = null;
            if (baos != null) {
                fbuf = ByteBuffer.wrap(baos.toByteArray(), 0, baos.size());
            } else {
                fbuf = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
                randomAccessFile.seek(0L);
            }
            if (Method.POST.equals((Object)this.method)) {
                ContentType contentType = new ContentType(this.headers.get("content-type"));
                if (contentType.isMultipart()) {
                    String boundary = contentType.getBoundary();
                    if (boundary == null) {
                        throw new NanoHTTPD.ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                    }
                    this.decodeMultipartFormData(contentType, fbuf, this.parms, files);
                } else {
                    byte[] postBytes = new byte[fbuf.remaining()];
                    fbuf.get(postBytes);
                    String postLine = new String(postBytes, contentType.getEncoding()).trim();
                    if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType.getContentType())) {
                        this.decodeParms(postLine, this.parms);
                    } else if (postLine.length() != 0) {
                        files.put(POST_DATA, postLine);
                    }
                }
            } else if (Method.PUT.equals((Object)this.method)) {
                files.put("content", this.saveTmpFile(fbuf, 0, fbuf.limit(), null));
            }
        }
        catch (Throwable throwable) {
            NanoHTTPD.safeClose(randomAccessFile);
            throw throwable;
        }
        NanoHTTPD.safeClose(randomAccessFile);
    }

    private String saveTmpFile(ByteBuffer b2, int offset, int len, String filename_hint) {
        String path = "";
        if (len > 0) {
            FileOutputStream fileOutputStream = null;
            try {
                ITempFile tempFile = this.tempFileManager.createTempFile(filename_hint);
                ByteBuffer src = b2.duplicate();
                fileOutputStream = new FileOutputStream(tempFile.getName());
                FileChannel dest = fileOutputStream.getChannel();
                src.position(offset).limit(offset + len);
                dest.write(src.slice());
                path = tempFile.getName();
            }
            catch (Exception e) {
                try {
                    throw new Error(e);
                }
                catch (Throwable throwable) {
                    NanoHTTPD.safeClose(fileOutputStream);
                    throw throwable;
                }
            }
            NanoHTTPD.safeClose(fileOutputStream);
        }
        return path;
    }

    @Override
    public String getRemoteIpAddress() {
        return this.remoteIp;
    }
}

