/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.single;

import de.studiocode.inventoryaccess.abstraction.inventory.CartographyInventory;
import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.map.MapIcon;
import de.studiocode.inventoryaccess.map.MapPatch;
import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.util.MathUtils;
import de.studiocode.invui.window.impl.single.SingleWindow;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.jetbrains.annotations.Nullable;

public final class CartographyWindow
extends SingleWindow {
    private final CartographyInventory cartographyInventory;
    private int mapId;

    public CartographyWindow(Player player, ComponentWrapper title, GUI gui, boolean closeable) {
        super(player.getUniqueId(), title, gui, null, false, closeable, true);
        if (gui.getWidth() != 2 || gui.getHeight() != 1) {
            throw new IllegalArgumentException("GUI has to be 2x1");
        }
        this.cartographyInventory = InventoryAccess.createCartographyInventory(player, title);
        this.inventory = this.cartographyInventory.getBukkitInventory();
        this.initItems();
        this.resetMap();
        this.register();
    }

    public CartographyWindow(Player player, ComponentWrapper title, GUI gui) {
        this(player, title, gui, true);
    }

    public CartographyWindow(Player player, BaseComponent[] title, GUI gui) {
        this(player, new BaseComponentWrapper(title), gui, true);
    }

    public CartographyWindow(Player player, BaseComponent[] title, GUI gui, boolean closeable) {
        this(player, new BaseComponentWrapper(title), gui, closeable);
    }

    public CartographyWindow(Player player, String title, GUI gui) {
        this(player, TextComponent.fromLegacyText((String)title), gui, true);
    }

    public CartographyWindow(Player player, String title, GUI gui, boolean closeable) {
        this(player, TextComponent.fromLegacyText((String)title), gui, closeable);
    }

    public void updateMap(@Nullable MapPatch patch, @Nullable List<MapIcon> icons) {
        InventoryAccess.getPlayerUtils().sendMapUpdate(this.getViewer(), this.mapId, (byte)0, false, patch, icons);
    }

    public void updateMap(MapPatch patch) {
        this.updateMap(patch, null);
    }

    public void updateMap(List<MapIcon> icons) {
        this.updateMap(null, icons);
    }

    public void resetMap() {
        this.mapId = -MathUtils.RANDOM.nextInt(Integer.MAX_VALUE);
        ItemStack map = new ItemStack(Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)map.getItemMeta();
        mapMeta.setMapId(this.mapId);
        map.setItemMeta((ItemMeta)mapMeta);
        this.cartographyInventory.setItem(0, map);
    }

    @Override
    protected void setInvItem(int slot, ItemStack itemStack) {
        this.cartographyInventory.setItem(slot + 1, itemStack);
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        if (event.getSlot() != 0) {
            this.getGui().handleClick(event.getSlot() - 1, (Player)event.getWhoClicked(), event.getClick(), event);
        } else {
            event.setCancelled(true);
        }
    }

    @Override
    public void show() {
        if (this.isClosed()) {
            throw new IllegalStateException("The Window has already been closed.");
        }
        Player viewer = this.getViewer();
        if (viewer == null) {
            throw new IllegalStateException("The player is not online.");
        }
        this.cartographyInventory.open();
    }
}

