/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.single;

import de.studiocode.inventoryaccess.abstraction.inventory.AnvilInventory;
import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.window.impl.single.SingleWindow;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class AnvilWindow
extends SingleWindow {
    private final AnvilInventory anvilInventory;

    public AnvilWindow(Player player, ComponentWrapper title, GUI gui, boolean closable, Consumer<String> renameHandler) {
        super(player.getUniqueId(), title, gui, null, false, closable, true);
        this.anvilInventory = InventoryAccess.createAnvilInventory(player, title, renameHandler);
        this.inventory = this.anvilInventory.getBukkitInventory();
        this.initItems();
        this.register();
    }

    public AnvilWindow(Player player, ComponentWrapper title, GUI gui, Consumer<String> renameHandler) {
        this(player, title, gui, true, renameHandler);
    }

    public AnvilWindow(Player player, BaseComponent[] title, GUI gui, boolean closeable, Consumer<String> renameHandler) {
        this(player, (ComponentWrapper)new BaseComponentWrapper(title), gui, closeable, renameHandler);
    }

    public AnvilWindow(Player player, BaseComponent[] title, GUI gui, Consumer<String> renameHandler) {
        this(player, title, gui, true, renameHandler);
    }

    public AnvilWindow(Player player, String title, GUI gui, boolean closeable, Consumer<String> renameHandler) {
        this(player, TextComponent.fromLegacyText((String)title), gui, closeable, renameHandler);
    }

    public AnvilWindow(Player player, String title, GUI gui, Consumer<String> renameHandler) {
        this(player, title, gui, true, renameHandler);
    }

    @Override
    protected void setInvItem(int slot, ItemStack itemStack) {
        this.anvilInventory.setItem(slot, itemStack);
    }

    @Override
    public void show() {
        if (this.isClosed()) {
            throw new IllegalStateException("The Window has already been closed.");
        }
        Player viewer = this.getViewer();
        if (viewer == null) {
            throw new IllegalStateException("The player is not online.");
        }
        this.anvilInventory.open();
    }

    public String getRenameText() {
        return this.anvilInventory.getRenameText();
    }
}

