/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.merged.combined;

import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.util.Pair;
import de.studiocode.invui.util.SlotUtils;
import de.studiocode.invui.window.impl.merged.MergedWindow;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public abstract class CombinedWindow
extends MergedWindow {
    private final GUI gui;

    public CombinedWindow(Player player, ComponentWrapper title, GUI gui, Inventory upperInventory, boolean closeable, boolean removeOnClose) {
        super(player, title, gui.getSize(), upperInventory, closeable, removeOnClose);
        this.gui = gui;
        gui.addParent(this);
        this.initUpperItems();
    }

    @Override
    public void handleSlotElementUpdate(GUI child, int slotIndex) {
        this.redrawItem(slotIndex, this.gui.getSlotElement(slotIndex), true);
    }

    @Override
    protected SlotElement getSlotElement(int index) {
        return this.gui.getSlotElement(index);
    }

    @Override
    protected Pair<GUI, Integer> getWhereClicked(InventoryClickEvent event) {
        Inventory clicked = event.getClickedInventory();
        int slot = event.getSlot();
        int clickedIndex = clicked == this.getUpperInventory() ? slot : this.getUpperInventory().getSize() + SlotUtils.translatePlayerInvToGui(slot);
        return new Pair<GUI, Integer>(this.gui, clickedIndex);
    }

    @Override
    protected Pair<GUI, Integer> getGuiAt(int index) {
        return index < this.gui.getSize() ? new Pair<GUI, Integer>(this.gui, index) : null;
    }

    @Override
    public GUI[] getGuis() {
        return new GUI[]{this.gui};
    }
}

