/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl;

import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.InvUI;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.util.ArrayUtils;
import de.studiocode.invui.util.Pair;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.PlayerUpdateReason;
import de.studiocode.invui.window.Window;
import de.studiocode.invui.window.WindowManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public abstract class BaseWindow
implements Window {
    private static final NamespacedKey SLOT_KEY = new NamespacedKey(InvUI.getInstance().getPlugin(), "slot");
    private final UUID viewerUUID;
    private final boolean removeOnClose;
    private final SlotElement[] elementsDisplayed;
    private final ArrayList<Runnable> closeHandlers = new ArrayList();
    private ComponentWrapper title;
    private boolean closeable;
    private boolean closed;

    public BaseWindow(UUID viewerUUID, ComponentWrapper title, int size, boolean closeable, boolean removeOnClose) {
        this.viewerUUID = viewerUUID;
        this.title = title;
        this.closeable = closeable;
        this.removeOnClose = removeOnClose;
        this.elementsDisplayed = new SlotElement[size];
    }

    protected void register() {
        WindowManager.getInstance().addWindow(this);
    }

    protected void redrawItem(int index) {
        this.redrawItem(index, this.getSlotElement(index), false);
    }

    protected void redrawItem(int index, SlotElement element, boolean setItem) {
        ItemProvider background;
        ItemStack itemStack;
        if (element instanceof SlotElement.ItemSlotElement) {
            itemStack = element.getItemStack(this.viewerUUID);
            if (itemStack.hasItemMeta()) {
                itemStack = itemStack.clone();
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.getPersistentDataContainer().set(SLOT_KEY, PersistentDataType.BYTE, (Object)((byte)index));
                itemStack.setItemMeta(itemMeta);
            }
        } else if (element == null || element instanceof SlotElement.VISlotElement && element.getItemStack(this.viewerUUID) == null) {
            background = this.getGuiAt(index).getFirst().getBackground();
            itemStack = background == null ? null : background.getFor(this.viewerUUID);
        } else if (element instanceof SlotElement.LinkedSlotElement && element.getHoldingElement() == null) {
            background = null;
            List<GUI> guis = ((SlotElement.LinkedSlotElement)element).getGuiList();
            guis.add(0, this.getGuiAt(index).getFirst());
            for (int i = guis.size() - 1; i >= 0 && (background = guis.get(i).getBackground()) == null; --i) {
            }
            itemStack = background == null ? null : background.getFor(this.viewerUUID);
        } else {
            itemStack = element.getItemStack(this.viewerUUID);
        }
        this.setInvItem(index, itemStack);
        if (setItem) {
            SlotElement previousElement = this.elementsDisplayed[index];
            if (previousElement instanceof SlotElement.ItemSlotElement) {
                SlotElement.ItemSlotElement itemSlotElement = (SlotElement.ItemSlotElement)previousElement;
                Item item = itemSlotElement.getItem();
                if (this.getItemSlotElements(item).size() == 1) {
                    item.removeWindow(this);
                }
            } else if (previousElement instanceof SlotElement.VISlotElement) {
                SlotElement.VISlotElement viSlotElement = (SlotElement.VISlotElement)previousElement;
                VirtualInventory virtualInventory = viSlotElement.getVirtualInventory();
                if (this.getVISlotElements(viSlotElement.getVirtualInventory()).size() == 1) {
                    virtualInventory.removeWindow(this);
                }
            }
            if (element != null) {
                SlotElement holdingElement = element.getHoldingElement();
                if (holdingElement instanceof SlotElement.ItemSlotElement) {
                    ((SlotElement.ItemSlotElement)holdingElement).getItem().addWindow(this);
                } else if (holdingElement instanceof SlotElement.VISlotElement) {
                    ((SlotElement.VISlotElement)holdingElement).getVirtualInventory().addWindow(this);
                }
                this.elementsDisplayed[index] = holdingElement;
            } else {
                this.elementsDisplayed[index] = null;
            }
        }
    }

    @Override
    public void handleDrag(InventoryDragEvent event) {
        Player player = ((Player)event.getWhoClicked()).getPlayer();
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        Map newItems = event.getNewItems();
        int itemsLeft = event.getCursor() == null ? 0 : event.getCursor().getAmount();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            Pair<GUI, Integer> pair;
            int rawSlot = (Integer)iterator.next();
            ItemStack currentStack = event.getView().getItem(rawSlot);
            if (currentStack != null && currentStack.getType() == Material.AIR) {
                currentStack = null;
            }
            if ((pair = this.getGuiAt(rawSlot)) == null || pair.getFirst().handleItemDrag(updateReason, pair.getSecond(), currentStack, (ItemStack)newItems.get(rawSlot))) continue;
            int currentAmount = currentStack == null ? 0 : currentStack.getAmount();
            int newAmount = ((ItemStack)newItems.get(rawSlot)).getAmount();
            itemsLeft += newAmount - currentAmount;
        }
        Bukkit.getScheduler().runTask(InvUI.getInstance().getPlugin(), () -> event.getRawSlots().forEach(rawSlot -> {
            if (this.getGuiAt((int)rawSlot) != null) {
                this.redrawItem((int)rawSlot);
            }
        }));
        ItemStack cursorStack = event.getOldCursor();
        cursorStack.setAmount(itemsLeft);
        event.setCursor(cursorStack);
    }

    @Override
    public void handleOpen(InventoryOpenEvent event) {
        if (!event.getPlayer().equals(this.getViewer())) {
            event.setCancelled(true);
        } else {
            this.handleOpened();
        }
    }

    @Override
    public void handleClose(Player player) {
        if (this.closeable) {
            if (this.removeOnClose) {
                this.close(false);
            }
            this.handleClosed();
            this.closeHandlers.forEach(Runnable::run);
        } else if (player.equals(this.getViewer())) {
            Bukkit.getScheduler().runTaskLater(InvUI.getInstance().getPlugin(), this::show, 0L);
        }
    }

    @Override
    public void handleItemProviderUpdate(Item item) {
        this.getItemSlotElements(item).forEach((index, slotElement) -> this.redrawItem((int)index, (SlotElement)slotElement, false));
    }

    @Override
    public void handleVirtualInventoryUpdate(VirtualInventory virtualInventory) {
        this.getVISlotElements(virtualInventory).forEach((index, slotElement) -> this.redrawItem((int)index, (SlotElement)slotElement, false));
    }

    protected Map<Integer, SlotElement> getItemSlotElements(Item item) {
        return ArrayUtils.findAllOccurrences(this.elementsDisplayed, element -> element instanceof SlotElement.ItemSlotElement && ((SlotElement.ItemSlotElement)element).getItem() == item);
    }

    protected Map<Integer, SlotElement> getVISlotElements(VirtualInventory virtualInventory) {
        return ArrayUtils.findAllOccurrences(this.elementsDisplayed, element -> element instanceof SlotElement.VISlotElement && ((SlotElement.VISlotElement)element).getVirtualInventory() == virtualInventory);
    }

    @Override
    public void close(boolean closeForViewer) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        WindowManager.getInstance().removeWindow(this);
        Arrays.stream(this.elementsDisplayed).filter(Objects::nonNull).map(SlotElement::getHoldingElement).forEach(slotElement -> {
            if (slotElement instanceof SlotElement.ItemSlotElement) {
                ((SlotElement.ItemSlotElement)slotElement).getItem().removeWindow(this);
            } else if (slotElement instanceof SlotElement.VISlotElement) {
                ((SlotElement.VISlotElement)slotElement).getVirtualInventory().removeWindow(this);
            }
        });
        Arrays.stream(this.getGuis()).forEach(gui -> gui.removeParent(this));
        if (closeForViewer) {
            this.closeForViewer();
        }
    }

    @Override
    public void closeForViewer() {
        this.closeable = true;
        Player viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.closeInventory();
            this.handleClosed();
        }
    }

    @Override
    public void show() {
        if (this.closed) {
            throw new IllegalStateException("The Window has already been closed.");
        }
        Player viewer = this.getViewer();
        if (viewer == null) {
            throw new IllegalStateException("The player is not online.");
        }
        InventoryAccess.getInventoryUtils().openCustomInventory(viewer, this.getInventories()[0], this.title);
    }

    @Override
    public void changeTitle(@NotNull ComponentWrapper title) {
        this.title = title;
        Player currentViewer = this.getCurrentViewer();
        if (currentViewer != null) {
            InventoryAccess.getInventoryUtils().updateOpenInventoryTitle(currentViewer, title);
        }
    }

    @Override
    public void changeTitle(@NotNull BaseComponent[] title) {
        this.changeTitle(new BaseComponentWrapper(title));
    }

    @Override
    public void changeTitle(@NotNull String title) {
        this.changeTitle(TextComponent.fromLegacyText((String)title));
    }

    @Override
    public void addCloseHandler(Runnable closeHandler) {
        this.closeHandlers.add(closeHandler);
    }

    @Override
    public void removeCloseHandler(Runnable closeHandler) {
        this.closeHandlers.remove(closeHandler);
    }

    @Override
    public Player getCurrentViewer() {
        List viewers = this.getInventories()[0].getViewers();
        return viewers.isEmpty() ? null : (Player)viewers.get(0);
    }

    @Override
    public Player getViewer() {
        return Bukkit.getPlayer((UUID)this.viewerUUID);
    }

    @Override
    public UUID getViewerUUID() {
        return this.viewerUUID;
    }

    @Override
    public boolean isCloseable() {
        return this.closeable;
    }

    @Override
    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected abstract void setInvItem(int var1, ItemStack var2);

    protected abstract SlotElement getSlotElement(int var1);

    protected abstract Pair<GUI, Integer> getGuiAt(int var1);

    protected abstract void handleOpened();

    protected abstract void handleClosed();
}

