/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.virtualinventory.event;

import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.UpdateReason;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class UpdateEvent {
    private final VirtualInventory virtualInventory;
    private final UpdateReason updateReason;
    private final int slot;
    private final ItemStack previousItemStack;
    protected ItemStack newItemStack;

    public UpdateEvent(@NotNull VirtualInventory virtualInventory, int slot, @Nullable UpdateReason updateReason, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        this.virtualInventory = virtualInventory;
        this.slot = slot;
        this.updateReason = updateReason;
        this.previousItemStack = previousItemStack != null ? previousItemStack.clone() : null;
        this.newItemStack = newItemStack != null ? newItemStack.clone() : null;
    }

    public VirtualInventory getVirtualInventory() {
        return this.virtualInventory;
    }

    public UpdateReason getUpdateReason() {
        return this.updateReason;
    }

    public ItemStack getPreviousItemStack() {
        return this.previousItemStack;
    }

    public ItemStack getNewItemStack() {
        return this.newItemStack;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isAdd() {
        if (this.newItemStack != null && this.previousItemStack != null && this.newItemStack.isSimilar(this.previousItemStack)) {
            return this.newItemStack.getAmount() > this.previousItemStack.getAmount();
        }
        return this.previousItemStack == null && this.newItemStack != null;
    }

    public boolean isRemove() {
        if (this.newItemStack != null && this.previousItemStack != null && this.newItemStack.isSimilar(this.previousItemStack)) {
            return this.newItemStack.getAmount() < this.previousItemStack.getAmount();
        }
        return this.newItemStack == null && this.previousItemStack != null;
    }

    public boolean isSwap() {
        return this.newItemStack != null && this.previousItemStack != null && !this.newItemStack.isSimilar(this.previousItemStack);
    }

    public int getRemovedAmount() {
        if (!this.isRemove()) {
            throw new IllegalStateException("No items have been removed");
        }
        if (this.newItemStack == null) {
            return this.previousItemStack.getAmount();
        }
        return this.previousItemStack.getAmount() - this.newItemStack.getAmount();
    }

    public int getAddedAmount() {
        if (!this.isAdd()) {
            throw new IllegalStateException("No items have been added");
        }
        if (this.previousItemStack == null) {
            return this.newItemStack.getAmount();
        }
        return this.newItemStack.getAmount() - this.previousItemStack.getAmount();
    }
}

