/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.virtualinventory;

import de.studiocode.invui.util.ArrayUtils;
import de.studiocode.invui.util.InventoryUtils;
import de.studiocode.invui.virtualinventory.VirtualInventoryManager;
import de.studiocode.invui.virtualinventory.event.InventoryUpdatedEvent;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import de.studiocode.invui.virtualinventory.event.UpdateReason;
import de.studiocode.invui.window.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualInventory {
    private final UUID uuid;
    private final Set<Window> windows = new HashSet<Window>();
    private int size;
    private ItemStack[] items;
    private int[] stackSizes;
    private Consumer<ItemUpdateEvent> itemUpdateHandler;
    private Consumer<InventoryUpdatedEvent> inventoryUpdatedHandler;
    private int guiShiftPriority = 0;

    public VirtualInventory(@Nullable UUID uuid, int size, @Nullable ItemStack[] items, int[] stackSizes) {
        this.uuid = uuid == null ? new UUID(0L, 0L) : uuid;
        this.size = size;
        ItemStack[] itemStackArray = this.items = items == null ? new ItemStack[size] : items;
        if (stackSizes == null) {
            this.stackSizes = new int[size];
            Arrays.fill(this.stackSizes, 64);
        } else {
            this.stackSizes = stackSizes;
        }
    }

    public VirtualInventory(@Nullable UUID uuid, int size) {
        this(uuid, size, null, null);
    }

    public byte[] toByteArray() {
        return VirtualInventoryManager.getInstance().serializeInventory(this);
    }

    public Set<Window> getWindows() {
        return Collections.unmodifiableSet(this.windows);
    }

    public void addWindow(Window window) {
        this.windows.add(window);
    }

    public void removeWindow(Window window) {
        this.windows.remove(window);
    }

    public void notifyWindows() {
        this.windows.forEach(window -> window.handleVirtualInventoryUpdate(this));
    }

    public void resize(int size) {
        this.size = size;
        this.items = Arrays.copyOf(this.items, size);
        this.stackSizes = Arrays.copyOf(this.stackSizes, size);
    }

    public void setItemUpdateHandler(Consumer<ItemUpdateEvent> itemUpdateHandler) {
        this.itemUpdateHandler = itemUpdateHandler;
    }

    public void setInventoryUpdatedHandler(Consumer<InventoryUpdatedEvent> inventoryUpdatedHandler) {
        this.inventoryUpdatedHandler = inventoryUpdatedHandler;
    }

    public int getGuiShiftPriority() {
        return this.guiShiftPriority;
    }

    public void setGuiShiftPriority(int guiShiftPriority) {
        this.guiShiftPriority = guiShiftPriority;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public int getSize() {
        return this.size;
    }

    public int[] getStackSizes() {
        return this.stackSizes;
    }

    public ItemStack[] getItems() {
        return (ItemStack[])Arrays.stream(this.items).map(item -> item != null ? item.clone() : null).toArray(ItemStack[]::new);
    }

    public ItemStack[] getUnsafeItems() {
        return this.items;
    }

    public ItemStack getItemStack(int slot) {
        ItemStack itemStack = this.items[slot];
        return itemStack != null ? itemStack.clone() : null;
    }

    public ItemStack getUnsafeItemStack(int slot) {
        return this.items[slot];
    }

    public boolean hasItem(int slot) {
        return this.items[slot] != null;
    }

    public int getAmount(int slot) {
        ItemStack currentStack = this.items[slot];
        return currentStack != null ? currentStack.getAmount() : 0;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack == null) continue;
            return false;
        }
        return true;
    }

    public int getMaxStackSize(int slot, int alternative) {
        int slotMaxStackSize;
        ItemStack currentItem = this.items[slot];
        int n = slotMaxStackSize = this.stackSizes == null ? 64 : this.stackSizes[slot];
        return Math.min(currentItem != null ? InventoryUtils.stackSizeProvider.getMaxStackSize(currentItem) : (alternative != -1 ? alternative : slotMaxStackSize), slotMaxStackSize);
    }

    public int getMaxSlotStackSize(int slot) {
        return this.stackSizes == null ? 64 : this.stackSizes[slot];
    }

    public void setMaxStackSizes(int[] maxStackSizes) {
        this.stackSizes = maxStackSizes;
    }

    public void setMaxStackSize(int slot, int maxStackSize) {
        this.stackSizes[slot] = maxStackSize;
    }

    public ItemUpdateEvent callPreUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        if (updateReason == UpdateReason.SUPPRESSED) {
            throw new IllegalArgumentException("Cannot call ItemUpdateEvent with UpdateReason.SUPPRESSED");
        }
        ItemUpdateEvent event = new ItemUpdateEvent(this, slot, updateReason, previousItemStack, newItemStack);
        if (this.itemUpdateHandler != null) {
            try {
                this.itemUpdateHandler.accept(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return event;
    }

    public void callAfterUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        if (updateReason == UpdateReason.SUPPRESSED) {
            throw new IllegalArgumentException("Cannot call InventoryUpdatedEvent with UpdateReason.SUPPRESSED");
        }
        InventoryUpdatedEvent event = new InventoryUpdatedEvent(this, slot, updateReason, previousItemStack, newItemStack);
        if (this.inventoryUpdatedHandler != null) {
            try {
                this.inventoryUpdatedHandler.accept(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isSynced(int slot, ItemStack assumedStack) {
        ItemStack actualStack = this.items[slot];
        return actualStack == null && assumedStack == null || actualStack != null && actualStack.equals((Object)assumedStack);
    }

    public void setItemStackSilently(int slot, @Nullable ItemStack itemStack) {
        this.items[slot] = itemStack != null && itemStack.getAmount() == 0 ? null : itemStack;
        this.notifyWindows();
    }

    public boolean forceSetItemStack(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack itemStack) {
        if (updateReason == UpdateReason.SUPPRESSED) {
            this.setItemStackSilently(slot, itemStack);
            return true;
        }
        ItemStack previousStack = this.items[slot];
        ItemUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, previousStack, itemStack);
        if (!event.isCancelled()) {
            ItemStack newStack = event.getNewItemStack();
            this.setItemStackSilently(slot, newStack);
            this.callAfterUpdateEvent(updateReason, slot, previousStack, newStack);
            return true;
        }
        return false;
    }

    public boolean setItemStack(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack itemStack) {
        int maxStackSize = Math.min(this.getMaxSlotStackSize(slot), itemStack != null ? itemStack.getMaxStackSize() : 64);
        if (itemStack != null && itemStack.getAmount() > maxStackSize) {
            return false;
        }
        return this.forceSetItemStack(updateReason, slot, itemStack);
    }

    public int putItemStack(@Nullable UpdateReason updateReason, int slot, @NotNull ItemStack itemStack) {
        int maxStackSize;
        int currentAmount;
        ItemStack currentStack = this.items[slot];
        if ((currentStack == null || currentStack.isSimilar(itemStack)) && (currentAmount = currentStack == null ? 0 : currentStack.getAmount()) < (maxStackSize = this.getMaxStackSize(slot, itemStack.getMaxStackSize()))) {
            int additionalAmount = itemStack.getAmount();
            int newAmount = Math.min(currentAmount + additionalAmount, maxStackSize);
            ItemStack newItemStack = itemStack.clone();
            newItemStack.setAmount(newAmount);
            if (updateReason != UpdateReason.SUPPRESSED) {
                ItemUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, currentStack, newItemStack);
                if (!event.isCancelled()) {
                    this.items[slot] = newItemStack = event.getNewItemStack();
                    this.notifyWindows();
                    this.callAfterUpdateEvent(updateReason, slot, currentStack, newItemStack);
                    int newAmountEvent = newItemStack != null ? newItemStack.getAmount() : 0;
                    return itemStack.getAmount() - (newAmountEvent - currentAmount);
                }
            } else {
                this.items[slot] = newItemStack;
                this.notifyWindows();
                return additionalAmount - (newAmount - currentAmount);
            }
        }
        return itemStack.getAmount();
    }

    public int setItemAmount(@Nullable UpdateReason updateReason, int slot, int amount) {
        ItemStack newItemStack;
        ItemStack currentStack = this.items[slot];
        if (currentStack == null) {
            throw new IllegalStateException("There is no ItemStack on that slot");
        }
        int maxStackSize = this.getMaxStackSize(slot, -1);
        if (amount > 0) {
            newItemStack = currentStack.clone();
            newItemStack.setAmount(Math.min(amount, maxStackSize));
        } else {
            newItemStack = null;
        }
        if (updateReason != UpdateReason.SUPPRESSED) {
            ItemUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, currentStack, newItemStack);
            if (!event.isCancelled()) {
                this.items[slot] = newItemStack = event.getNewItemStack();
                this.notifyWindows();
                this.callAfterUpdateEvent(updateReason, slot, currentStack, newItemStack);
                return newItemStack != null ? newItemStack.getAmount() : 0;
            }
        } else {
            this.items[slot] = newItemStack;
            this.notifyWindows();
            return amount;
        }
        return currentStack.getAmount();
    }

    public int addItemAmount(@Nullable UpdateReason updateReason, int slot, int amount) {
        ItemStack currentStack = this.items[slot];
        if (currentStack == null) {
            return 0;
        }
        int currentAmount = currentStack.getAmount();
        return this.setItemAmount(updateReason, slot, currentAmount + amount) - currentAmount;
    }

    public int addItem(@Nullable UpdateReason updateReason, ItemStack itemStack) {
        ItemStack stackToPut;
        int originalAmount;
        int amountLeft = originalAmount = itemStack.getAmount();
        for (int partialSlot : this.findPartialSlots(itemStack)) {
            if (amountLeft == 0) break;
            stackToPut = itemStack.clone();
            stackToPut.setAmount(amountLeft);
            amountLeft = this.putItemStack(updateReason, partialSlot, stackToPut);
        }
        for (int emptySlot : ArrayUtils.findEmptyIndices(this.items)) {
            if (amountLeft == 0) break;
            stackToPut = itemStack.clone();
            stackToPut.setAmount(amountLeft);
            amountLeft = this.putItemStack(updateReason, emptySlot, stackToPut);
        }
        if (originalAmount != amountLeft) {
            this.notifyWindows();
        }
        return amountLeft;
    }

    public int[] simulateAdd(@NotNull ItemStack itemStack, ItemStack ... itemStacks) {
        if (itemStacks.length == 0) {
            return new int[]{this.simulateSingleAdd(itemStack)};
        }
        ItemStack[] allStacks = (ItemStack[])Stream.concat(Stream.of(itemStack), Arrays.stream(itemStacks)).toArray(ItemStack[]::new);
        return this.simulateMultiAdd(Arrays.asList(allStacks));
    }

    public int[] simulateAdd(@NotNull @NotNull List<@NotNull ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return new int[0];
        }
        if (itemStacks.size() == 1) {
            return new int[]{this.simulateSingleAdd(itemStacks.get(0))};
        }
        return this.simulateMultiAdd(itemStacks);
    }

    public boolean canHold(@NotNull ItemStack itemStack, ItemStack ... itemStacks) {
        if (itemStacks.length == 0) {
            return this.simulateSingleAdd(itemStack) == 0;
        }
        ItemStack[] allStacks = (ItemStack[])Stream.concat(Stream.of(itemStack), Arrays.stream(itemStacks)).toArray(ItemStack[]::new);
        return Arrays.stream(this.simulateMultiAdd(Arrays.asList(allStacks))).allMatch(i -> i == 0);
    }

    public boolean canHold(@NotNull @NotNull List<@NotNull ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return true;
        }
        if (itemStacks.size() == 1) {
            return this.simulateSingleAdd(itemStacks.get(0)) == 0;
        }
        return Arrays.stream(this.simulateMultiAdd(itemStacks)).allMatch(i -> i == 0);
    }

    public int simulateSingleAdd(@NotNull ItemStack itemStack) {
        int amountLeft = itemStack.getAmount();
        for (int partialSlot : this.findPartialSlots(itemStack)) {
            if (amountLeft == 0) break;
            ItemStack partialItem = this.items[partialSlot];
            int maxStackSize = this.getMaxStackSize(partialSlot, -1);
            amountLeft = Math.max(0, amountLeft - (maxStackSize - partialItem.getAmount()));
        }
        for (int emptySlot : ArrayUtils.findEmptyIndices(this.items)) {
            if (amountLeft == 0) break;
            int maxStackSize = this.getMaxStackSize(emptySlot, itemStack.getMaxStackSize());
            amountLeft -= Math.min(amountLeft, maxStackSize);
        }
        return amountLeft;
    }

    public int[] simulateMultiAdd(@NotNull @NotNull List<@NotNull ItemStack> itemStacks) {
        VirtualInventory copiedInv = new VirtualInventory(null, this.size, this.getItems(), (int[])this.stackSizes.clone());
        int[] result = new int[itemStacks.size()];
        for (int index = 0; index != itemStacks.size(); ++index) {
            result[index] = copiedInv.addItem(null, itemStacks.get(index));
        }
        return result;
    }

    public int collectToCursor(@Nullable UpdateReason updateReason, ItemStack itemStack) {
        int amount = itemStack.getAmount();
        int maxStackSize = itemStack.getMaxStackSize();
        if (amount < itemStack.getMaxStackSize()) {
            for (int partialSlot : this.findPartialSlots(itemStack)) {
                if ((amount += this.takeFrom(updateReason, partialSlot, maxStackSize - amount)) != maxStackSize) continue;
                return amount;
            }
            for (int fullSlot : this.findFullSlots(itemStack)) {
                if ((amount += this.takeFrom(updateReason, fullSlot, maxStackSize - amount)) != maxStackSize) continue;
                return amount;
            }
        }
        return amount;
    }

    private List<Integer> findPartialSlots(ItemStack itemStack) {
        ArrayList<Integer> partialSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.size; ++slot) {
            ItemStack currentStack = this.items[slot];
            if (!itemStack.isSimilar(currentStack)) continue;
            int maxStackSize = this.getMaxStackSize(slot, -1);
            if (currentStack.getAmount() >= maxStackSize) continue;
            partialSlots.add(slot);
        }
        return partialSlots;
    }

    private List<Integer> findFullSlots(ItemStack itemStack) {
        ArrayList<Integer> fullSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.size; ++slot) {
            ItemStack currentStack = this.items[slot];
            if (!itemStack.isSimilar(currentStack)) continue;
            int maxStackSize = this.getMaxStackSize(slot, -1);
            if (currentStack.getAmount() != maxStackSize) continue;
            fullSlots.add(slot);
        }
        return fullSlots;
    }

    private int takeFrom(@Nullable UpdateReason updateReason, int index, int maxTake) {
        ItemStack newStack;
        ItemStack itemStack = this.items[index];
        int amount = itemStack.getAmount();
        int take = Math.min(amount, maxTake);
        if (take != amount) {
            newStack = itemStack.clone();
            newStack.setAmount(amount - take);
        } else {
            newStack = null;
        }
        if (updateReason != UpdateReason.SUPPRESSED) {
            ItemUpdateEvent event = this.callPreUpdateEvent(updateReason, index, itemStack, newStack);
            if (!event.isCancelled()) {
                this.items[index] = newStack = event.getNewItemStack();
                this.notifyWindows();
                this.callAfterUpdateEvent(updateReason, index, itemStack, newStack);
                return itemStack.getAmount() - (newStack == null ? 0 : newStack.getAmount());
            }
        } else {
            this.items[index] = newStack;
            this.notifyWindows();
            return take;
        }
        return 0;
    }

    public String toString() {
        return "VirtualInventory{uuid=" + this.uuid + ", size=" + this.size + ", stackSizes=" + Arrays.toString(this.stackSizes) + ", items=" + Arrays.toString(this.items) + "}";
    }
}

