/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.item.impl;

import de.studiocode.invui.InvUI;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.impl.SuppliedItem;
import de.studiocode.invui.window.Window;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitTask;

public class AutoUpdateItem
extends SuppliedItem {
    private final int period;
    private BukkitTask task;

    public AutoUpdateItem(int period, Supplier<? extends ItemProvider> builderSupplier) {
        super(builderSupplier, null);
        this.period = period;
    }

    public void start() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Bukkit.getScheduler().runTaskTimer(InvUI.getInstance().getPlugin(), this::notifyWindows, 0L, (long)this.period);
    }

    public void cancel() {
        this.task.cancel();
        this.task = null;
    }

    @Override
    public void addWindow(Window window) {
        super.addWindow(window);
        if (this.task == null) {
            this.start();
        }
    }

    @Override
    public void removeWindow(Window window) {
        super.removeWindow(window);
        if (this.getWindows().isEmpty() && this.task != null) {
            this.cancel();
        }
    }
}

