/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.item.builder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.studiocode.inventoryaccess.util.ReflectionRegistry;
import de.studiocode.inventoryaccess.util.ReflectionUtils;
import de.studiocode.invui.item.builder.BaseItemBuilder;
import de.studiocode.invui.util.MojangApiUtils;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class SkullBuilder
extends BaseItemBuilder<SkullBuilder> {
    private GameProfile gameProfile;

    public SkullBuilder(UUID uuid) {
        this(HeadTexture.of(uuid));
    }

    public SkullBuilder(String username) {
        this(HeadTexture.of(username));
    }

    public SkullBuilder(HeadTexture headTexture) {
        super(Material.PLAYER_HEAD);
        this.setGameProfile(headTexture);
    }

    private void setGameProfile(HeadTexture texture) {
        this.gameProfile = new GameProfile(UUID.randomUUID(), null);
        PropertyMap propertyMap = this.gameProfile.getProperties();
        propertyMap.put((Object)"textures", (Object)new Property("textures", texture.getTextureValue()));
    }

    @Override
    public ItemStack get() {
        ItemStack item = super.get();
        ItemMeta meta = item.getItemMeta();
        if (this.gameProfile != null) {
            ReflectionUtils.setFieldValue(ReflectionRegistry.CB_CRAFT_META_SKULL_PROFILE_FIELD, meta, this.gameProfile);
        }
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public SkullBuilder setMaterial(@NotNull Material material) {
        return this;
    }

    @Override
    protected SkullBuilder getThis() {
        return this;
    }

    public static class HeadTexture
    implements Serializable {
        private static final Cache<UUID, String> textureCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();
        private static final Cache<String, UUID> uuidCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();
        private final String textureValue;

        public HeadTexture(@NotNull String textureValue) {
            this.textureValue = textureValue;
        }

        public static HeadTexture of(@NotNull OfflinePlayer offlinePlayer) {
            return HeadTexture.of(offlinePlayer.getUniqueId());
        }

        public static HeadTexture of(@NotNull String playerName) {
            if (Bukkit.getServer().getOnlineMode()) {
                return HeadTexture.of(Bukkit.getOfflinePlayer((String)playerName).getUniqueId());
            }
            try {
                return HeadTexture.of((UUID)uuidCache.get((Object)playerName, () -> MojangApiUtils.getCurrentUUID(playerName)));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static HeadTexture of(@NotNull UUID uuid) {
            try {
                return new HeadTexture((String)textureCache.get((Object)uuid, () -> MojangApiUtils.getSkinData(uuid, false)[0]));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static void invalidateCache() {
            uuidCache.invalidateAll();
            textureCache.invalidateAll();
        }

        public String getTextureValue() {
            return this.textureValue;
        }
    }
}

