/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.item.builder;

import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.util.ComponentUtils;
import de.studiocode.invui.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

abstract class BaseItemBuilder<T>
implements ItemProvider {
    protected ItemStack base;
    protected Material material;
    protected int amount = 1;
    protected int damage;
    protected int customModelData;
    protected ComponentWrapper displayName;
    protected List<ComponentWrapper> lore;
    protected List<ItemFlag> itemFlags;
    protected HashMap<Enchantment, Pair<Integer, Boolean>> enchantments;
    protected List<Function<ItemStack, ItemStack>> modifiers;

    public BaseItemBuilder(@NotNull Material material) {
        this.material = material;
    }

    public BaseItemBuilder(@NotNull Material material, int amount) {
        this.material = material;
        this.amount = amount;
    }

    public BaseItemBuilder(@NotNull ItemStack base) {
        this.base = base.clone();
        this.amount = base.getAmount();
    }

    @Override
    public ItemStack get() {
        ItemStack itemStack;
        if (this.base != null) {
            itemStack = this.base;
            itemStack.setAmount(this.amount);
        } else {
            itemStack = new ItemStack(this.material, this.amount);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            if (this.displayName != null) {
                InventoryAccess.getItemUtils().setDisplayName(itemMeta, this.displayName);
            }
            if (this.lore != null) {
                InventoryAccess.getItemUtils().setLore(itemMeta, this.lore);
            }
            if (itemMeta instanceof Damageable) {
                ((Damageable)itemMeta).setDamage(this.damage);
            }
            if (this.customModelData != 0) {
                itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            }
            if (this.enchantments != null) {
                if (this.base != null) {
                    itemMeta.getEnchants().forEach((enchantment, level) -> itemMeta.removeEnchant(enchantment));
                }
                this.enchantments.forEach((enchantment, pair) -> itemMeta.addEnchant(enchantment, ((Integer)pair.getFirst()).intValue(), ((Boolean)pair.getSecond()).booleanValue()));
            }
            if (this.itemFlags != null) {
                if (this.base != null) {
                    itemMeta.removeItemFlags(itemMeta.getItemFlags().toArray(new ItemFlag[0]));
                }
                itemMeta.addItemFlags(this.itemFlags.toArray(new ItemFlag[0]));
            }
            itemStack.setItemMeta(itemMeta);
        }
        if (this.modifiers != null) {
            for (Function<ItemStack, ItemStack> modifier : this.modifiers) {
                itemStack = modifier.apply(itemStack);
            }
        }
        return itemStack;
    }

    @Override
    public ItemStack getFor(@NotNull UUID playerUUID) {
        return this.get();
    }

    public T setLegacyLore(@NotNull List<String> lore) {
        this.lore = lore.stream().map(line -> new BaseComponentWrapper(ComponentUtils.withoutPreFormatting(line))).collect(Collectors.toList());
        return this.getThis();
    }

    public T addLoreLines(String ... lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        for (String line : lines) {
            this.lore.add(new BaseComponentWrapper(ComponentUtils.withoutPreFormatting(line)));
        }
        return this.getThis();
    }

    public T addLoreLines(BaseComponent[] ... lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        this.lore.addAll(Arrays.stream(lines).map(line -> new BaseComponentWrapper(ComponentUtils.withoutPreFormatting(line))).collect(Collectors.toList()));
        return this.getThis();
    }

    public T addLoreLines(ComponentWrapper ... lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        this.lore.addAll(Arrays.asList(lines));
        return this.getThis();
    }

    public T removeLoreLine(int index) {
        if (this.lore != null) {
            this.lore.remove(index);
        }
        return this.getThis();
    }

    public T clearLore() {
        if (this.lore != null) {
            this.lore.clear();
        }
        return this.getThis();
    }

    public T addItemFlags(ItemFlag ... itemFlags) {
        if (this.itemFlags == null) {
            this.itemFlags = new ArrayList<ItemFlag>();
        }
        this.itemFlags.addAll(Arrays.asList(itemFlags));
        return this.getThis();
    }

    public T removeItemFlags(ItemFlag ... itemFlags) {
        if (this.itemFlags != null) {
            this.itemFlags.removeAll(Arrays.asList(itemFlags));
        }
        return this.getThis();
    }

    public T clearItemFlags() {
        if (this.itemFlags != null) {
            this.itemFlags.clear();
        }
        return this.getThis();
    }

    public T addEnchantment(Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap();
        }
        this.enchantments.put(enchantment, new Pair<Integer, Boolean>(level, ignoreLevelRestriction));
        return this.getThis();
    }

    public T removeEnchantment(Enchantment enchantment) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap();
        }
        this.enchantments.remove(enchantment);
        return this.getThis();
    }

    public T clearEnchantments() {
        if (this.enchantments != null) {
            this.enchantments.clear();
        }
        return this.getThis();
    }

    public T addModifier(Function<ItemStack, ItemStack> modifier) {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<Function<ItemStack, ItemStack>>();
        }
        this.modifiers.add(modifier);
        return this.getThis();
    }

    public T clearModifiers() {
        if (this.modifiers != null) {
            this.modifiers.clear();
        }
        return this.getThis();
    }

    public ItemStack getBase() {
        return this.base;
    }

    public Material getMaterial() {
        return this.material;
    }

    public T setMaterial(@NotNull Material material) {
        this.material = material;
        return this.getThis();
    }

    public int getAmount() {
        return this.amount;
    }

    public T setAmount(int amount) {
        this.amount = amount;
        return this.getThis();
    }

    public int getDamage() {
        return this.damage;
    }

    public T setDamage(int damage) {
        this.damage = damage;
        return this.getThis();
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public T setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
        return this.getThis();
    }

    public ComponentWrapper getDisplayName() {
        return this.displayName;
    }

    public T setDisplayName(String displayName) {
        this.displayName = new BaseComponentWrapper(ComponentUtils.withoutPreFormatting(displayName));
        return this.getThis();
    }

    public T setDisplayName(BaseComponent ... displayName) {
        this.displayName = new BaseComponentWrapper(ComponentUtils.withoutPreFormatting(displayName));
        return this.getThis();
    }

    public T setDisplayName(ComponentWrapper component) {
        this.displayName = component;
        return this.getThis();
    }

    public List<ComponentWrapper> getLore() {
        return this.lore;
    }

    public T setLore(List<ComponentWrapper> lore) {
        this.lore = lore;
        return this.getThis();
    }

    public List<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    public T setItemFlags(@NotNull List<ItemFlag> itemFlags) {
        this.itemFlags = itemFlags;
        return this.getThis();
    }

    public HashMap<Enchantment, Pair<Integer, Boolean>> getEnchantments() {
        return this.enchantments;
    }

    public T setEnchantments(@NotNull HashMap<Enchantment, Pair<Integer, Boolean>> enchantments) {
        this.enchantments = enchantments;
        return this.getThis();
    }

    public List<Function<ItemStack, ItemStack>> getModifiers() {
        return this.modifiers;
    }

    public T clone() {
        try {
            BaseItemBuilder clone = (BaseItemBuilder)super.clone();
            if (this.base != null) {
                clone.base = this.base.clone();
            }
            if (this.lore != null) {
                clone.lore = new ArrayList<ComponentWrapper>(this.lore);
            }
            if (this.itemFlags != null) {
                clone.itemFlags = new ArrayList<ItemFlag>(this.itemFlags);
            }
            if (this.enchantments != null) {
                clone.enchantments = new HashMap<Enchantment, Pair<Integer, Boolean>>(this.enchantments);
            }
            if (this.modifiers != null) {
                clone.modifiers = new ArrayList<Function<ItemStack, ItemStack>>(this.modifiers);
            }
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract T getThis();
}

