/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.Controllable;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.BaseGUI;
import de.studiocode.invui.gui.structure.Structure;
import java.util.List;

public abstract class TabGUI
extends BaseGUI
implements Controllable {
    private final int tabAmount;
    private final int[] listSlots;
    private int currentTab = -1;

    public TabGUI(int width, int height, int tabAmount, int ... listSlots) {
        super(width, height);
        this.tabAmount = tabAmount;
        this.listSlots = listSlots;
    }

    public TabGUI(int width, int height, int tabAmount, Structure structure) {
        this(width, height, tabAmount, structure.getIngredientList().findItemListSlots());
        this.applyStructure(structure);
    }

    public void showTab(int tab) {
        if (tab < 0 || tab >= this.tabAmount) {
            throw new IllegalArgumentException("Tab out of bounds");
        }
        if (!this.isTabAvailable(tab)) {
            return;
        }
        int previous = this.currentTab;
        this.currentTab = tab;
        this.update();
        this.handleTabChange(previous, this.currentTab);
    }

    protected void update() {
        if (this.currentTab == -1) {
            this.currentTab = this.getFirstAvailableTab();
        }
        this.updateControlItems();
        this.updateContent();
    }

    private void updateContent() {
        List<SlotElement> slotElements = this.getSlotElements(this.currentTab);
        for (int i = 0; i < this.listSlots.length; ++i) {
            int slot = this.listSlots[i];
            if (slotElements.size() > i) {
                this.setSlotElement(this.listSlots[i], slotElements.get(i));
                continue;
            }
            this.remove(slot);
        }
    }

    public int getFirstAvailableTab() {
        for (int tab = 0; tab < this.tabAmount; ++tab) {
            if (!this.isTabAvailable(tab)) continue;
            return tab;
        }
        throw new UnsupportedOperationException("At least one tab needs to be available");
    }

    public int getCurrentTab() {
        return this.currentTab;
    }

    public abstract boolean isTabAvailable(int var1);

    protected abstract List<SlotElement> getSlotElements(int var1);

    protected abstract void handleTabChange(int var1, int var2);
}

