/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.PagedGUI;
import de.studiocode.invui.gui.structure.Structure;
import de.studiocode.invui.item.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplePagedItemsGUI
extends PagedGUI {
    private List<Item> items;
    private List<BiConsumer<Integer, Integer>> pageChangeHandlers;

    public SimplePagedItemsGUI(int width, int height, @Nullable List<Item> items, int ... itemListSlots) {
        super(width, height, false, itemListSlots);
        this.setItems(items);
    }

    public SimplePagedItemsGUI(@Nullable List<Item> items, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setItems(items);
    }

    @Override
    public int getPageAmount() {
        return (int)Math.ceil((double)this.items.size() / (double)this.getItemListSlots().length);
    }

    public void setItems(@Nullable List<Item> items) {
        this.items = items != null ? items : new ArrayList();
        this.update();
    }

    public void addPageChangeHandler(@NotNull BiConsumer<Integer, Integer> pageChangeHandler) {
        if (this.pageChangeHandlers == null) {
            this.pageChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>();
        }
        this.pageChangeHandlers.add(pageChangeHandler);
    }

    public void removePageChangeHandler(@NotNull BiConsumer<Integer, Integer> pageChangeHandler) {
        if (this.pageChangeHandlers != null) {
            this.pageChangeHandlers.remove(pageChangeHandler);
        }
    }

    @Nullable
    public List<BiConsumer<Integer, Integer>> getPageChangeHandlers() {
        return this.pageChangeHandlers;
    }

    public void setPageChangeHandlers(@Nullable List<BiConsumer<Integer, Integer>> pageChangeHandlers) {
        this.pageChangeHandlers = pageChangeHandlers;
    }

    @Override
    protected List<SlotElement> getPageElements(int page) {
        int length = this.getItemListSlots().length;
        int from = page * length;
        int to = Math.min(from + length, this.items.size());
        return this.items.subList(from, to).stream().map(SlotElement.ItemSlotElement::new).collect(Collectors.toList());
    }

    @Override
    protected void handlePageChange(int previous, int now) {
        if (this.pageChangeHandlers != null) {
            this.pageChangeHandlers.forEach(handler -> handler.accept(previous, now));
        }
    }
}

