/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.BaseGUI;
import de.studiocode.invui.gui.structure.Structure;
import de.studiocode.invui.util.SlotUtils;
import java.util.List;

public abstract class ScrollGUI
extends BaseGUI {
    private final boolean infiniteLines;
    private final int lineLength;
    private final int lineAmount;
    private final int[] itemListSlots;
    protected int offset;

    public ScrollGUI(int width, int height, boolean infiniteLines, int ... itemListSlots) {
        super(width, height);
        this.infiniteLines = infiniteLines;
        this.itemListSlots = itemListSlots;
        this.lineLength = SlotUtils.getLongestLineLength(itemListSlots, width);
        this.lineAmount = (int)Math.ceil((double)itemListSlots.length / (double)this.lineLength);
        if (itemListSlots.length == 0) {
            throw new IllegalArgumentException("No item list slots provided");
        }
        if (this.lineLength == 0) {
            throw new IllegalArgumentException("Line length can't be 0");
        }
        if (itemListSlots.length % this.lineLength != 0) {
            throw new IllegalArgumentException("itemListSlots has to be a multiple of lineLength");
        }
    }

    public ScrollGUI(int width, int height, boolean infiniteLines, Structure structure) {
        this(width, height, infiniteLines, structure.getIngredientList().findItemListSlots());
        this.applyStructure(structure);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getCurrentLine() {
        return this.offset / this.lineLength;
    }

    public void setCurrentLine(int line) {
        this.offset = line * this.lineLength;
    }

    public boolean canScroll(int lines) {
        if (lines == 0 || this.infiniteLines && lines > 0 || lines < 0 && this.getCurrentLine() > 0) {
            return true;
        }
        int line = this.getCurrentLine() + lines;
        int maxLineIndex = this.getMaxLineIndex();
        return line >= 0 && line + this.lineAmount - 1 <= maxLineIndex;
    }

    public void scroll(int lines) {
        if (lines == 0) {
            return;
        }
        if (this.canScroll(lines)) {
            this.setCurrentLine(this.getCurrentLine() + lines);
            this.update();
        } else if (lines > 1) {
            this.setCurrentLine(this.getMaxLineIndex());
            this.update();
        } else if (lines < -1) {
            this.setCurrentLine(0);
            this.update();
        }
    }

    protected void update() {
        this.correctLine();
        this.updateControlItems();
        this.updateContent();
    }

    private void correctLine() {
        if (this.offset == 0 || this.infiniteLines) {
            return;
        }
        if (this.offset < 0) {
            this.offset = 0;
        } else {
            int maxLineIndex;
            int currentLine = this.getCurrentLine();
            if (currentLine >= (maxLineIndex = this.getMaxLineIndex())) {
                this.setCurrentLine(maxLineIndex);
            }
        }
    }

    private void updateContent() {
        List<? extends SlotElement> slotElements = this.getElements(this.offset, this.itemListSlots.length + this.offset);
        for (int i = 0; i < this.itemListSlots.length; ++i) {
            if (slotElements.size() > i) {
                this.setSlotElement(this.itemListSlots[i], slotElements.get(i));
                continue;
            }
            this.remove(this.itemListSlots[i]);
        }
    }

    protected abstract int getMaxLineIndex();

    protected abstract List<? extends SlotElement> getElements(int var1, int var2);
}

