/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.animation.Animation;
import de.studiocode.invui.gui.Controllable;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.GUIParent;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.structure.Structure;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.impl.controlitem.ControlItem;
import de.studiocode.invui.util.ArrayUtils;
import de.studiocode.invui.util.InventoryUtils;
import de.studiocode.invui.util.SlotUtils;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import de.studiocode.invui.virtualinventory.event.PlayerUpdateReason;
import de.studiocode.invui.virtualinventory.event.UpdateReason;
import de.studiocode.invui.window.Window;
import de.studiocode.invui.window.WindowManager;
import de.studiocode.invui.window.impl.merged.MergedWindow;
import de.studiocode.invui.window.impl.merged.split.SplitWindow;
import de.studiocode.invui.window.impl.single.SingleWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGUI
implements GUI,
Controllable {
    private final int width;
    private final int height;
    private final int size;
    private final SlotElement[] slotElements;
    private final Set<GUIParent> parents = new HashSet<GUIParent>();
    private SlotElement[] animationElements;
    private Animation animation;
    private ItemProvider background;

    public BaseGUI(int width, int height) {
        this.width = width;
        this.height = height;
        this.size = width * height;
        this.slotElements = new SlotElement[this.size];
    }

    @Override
    public void handleClick(int slotNumber, Player player, ClickType clickType, InventoryClickEvent event) {
        if (this.animation != null) {
            event.setCancelled(true);
            return;
        }
        SlotElement slotElement = this.slotElements[slotNumber];
        if (slotElement instanceof SlotElement.LinkedSlotElement) {
            SlotElement.LinkedSlotElement linkedElement = (SlotElement.LinkedSlotElement)slotElement;
            linkedElement.getGui().handleClick(linkedElement.getSlotIndex(), player, clickType, event);
        } else if (slotElement instanceof SlotElement.ItemSlotElement) {
            event.setCancelled(true);
            SlotElement.ItemSlotElement itemElement = (SlotElement.ItemSlotElement)slotElement;
            itemElement.getItem().handleClick(clickType, player, event);
        } else if (slotElement instanceof SlotElement.VISlotElement) {
            this.handleVISlotElementClick((SlotElement.VISlotElement)slotElement, event);
        } else {
            event.setCancelled(true);
        }
    }

    protected void handleVISlotElementClick(SlotElement.VISlotElement element, InventoryClickEvent event) {
        InventoryAction action = event.getAction();
        if (action != InventoryAction.CLONE_STACK && action != InventoryAction.DROP_ALL_CURSOR && action != InventoryAction.DROP_ONE_CURSOR) {
            ItemStack clicked;
            event.setCancelled(true);
            VirtualInventory inventory = element.getVirtualInventory();
            int slot = element.getSlot();
            Player player = (Player)event.getWhoClicked();
            ItemStack cursor = event.getCursor();
            if (cursor != null && cursor.getType().isAir()) {
                cursor = null;
            }
            if ((clicked = event.getCurrentItem()) != null && clicked.getType().isAir()) {
                clicked = null;
            }
            ItemStack technicallyClicked = inventory.getItemStack(slot);
            if (inventory.isSynced(slot, clicked) || this.didClickBackgroundItem(player, element, inventory, slot, clicked)) {
                switch (event.getClick()) {
                    case LEFT: {
                        this.handleVILeftClick(event, inventory, slot, player, technicallyClicked, cursor);
                        break;
                    }
                    case RIGHT: {
                        this.handleVIRightClick(event, inventory, slot, player, technicallyClicked, cursor);
                        break;
                    }
                    case SHIFT_RIGHT: 
                    case SHIFT_LEFT: {
                        this.handleVIItemShift(event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case NUMBER_KEY: {
                        this.handleVINumberKey(event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case SWAP_OFFHAND: {
                        this.handleVIOffHandKey(event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case DROP: {
                        this.handleVIDrop(false, event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case CONTROL_DROP: {
                        this.handleVIDrop(true, event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case DOUBLE_CLICK: {
                        this.handleVIDoubleClick(event, inventory, player, cursor);
                    }
                }
            }
        }
    }

    private boolean didClickBackgroundItem(Player player, SlotElement.VISlotElement element, VirtualInventory inventory, int slot, ItemStack clicked) {
        UUID uuid = player.getUniqueId();
        return inventory.getUnsafeItemStack(slot) == null && (this.isBuilderSimilar(this.background, uuid, clicked) || this.isBuilderSimilar(element.getBackground(), uuid, clicked));
    }

    private boolean isBuilderSimilar(ItemProvider builder, UUID uuid, ItemStack expected) {
        return builder != null && builder.getFor(uuid).isSimilar(expected);
    }

    protected void handleVILeftClick(InventoryClickEvent event, VirtualInventory inventory, int slot, Player player, ItemStack clicked, ItemStack cursor) {
        if (clicked == null && cursor == null) {
            return;
        }
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        if (cursor == null) {
            if (inventory.setItemStack(updateReason, slot, null)) {
                event.setCursor(clicked);
            }
        } else if (clicked == null || cursor.isSimilar(clicked)) {
            int remains = inventory.putItemStack(updateReason, slot, cursor);
            if (remains == 0) {
                event.setCursor(null);
            } else {
                cursor.setAmount(remains);
                event.setCursor(cursor);
            }
        } else if (!cursor.isSimilar(clicked) && inventory.setItemStack(updateReason, slot, cursor)) {
            event.setCursor(clicked);
        }
    }

    protected void handleVIRightClick(InventoryClickEvent event, VirtualInventory inventory, int slot, Player player, ItemStack clicked, ItemStack cursor) {
        if (clicked == null && cursor == null) {
            return;
        }
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        if (cursor == null) {
            int clickedAmount = clicked.getAmount();
            int newClickedAmount = clickedAmount / 2;
            int newCursorAmount = clickedAmount - newClickedAmount;
            cursor = clicked.clone();
            clicked.setAmount(newClickedAmount);
            cursor.setAmount(newCursorAmount);
            if (inventory.setItemStack(updateReason, slot, clicked)) {
                event.setCursor(cursor);
            }
        } else {
            ItemStack toAdd = cursor.clone();
            toAdd.setAmount(1);
            int remains = inventory.putItemStack(updateReason, slot, toAdd);
            if (remains == 0) {
                cursor.setAmount(cursor.getAmount() - 1);
                event.setCursor(cursor);
            }
        }
    }

    protected void handleVIItemShift(InventoryClickEvent event, VirtualInventory inventory, int slot, Player player, ItemStack clicked) {
        if (clicked == null) {
            return;
        }
        ItemStack previousStack = clicked.clone();
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        Window window = WindowManager.getInstance().getOpenWindow(player);
        ItemUpdateEvent updateEvent = inventory.callPreUpdateEvent(updateReason, slot, previousStack, null);
        if (!updateEvent.isCancelled()) {
            int leftOverAmount;
            if (window instanceof MergedWindow) {
                SplitWindow splitWindow;
                GUI[] guis;
                GUI otherGui = window instanceof SplitWindow ? ((guis = (splitWindow = (SplitWindow)window).getGuis())[0] == this ? guis[1] : guis[0]) : this;
                leftOverAmount = otherGui.putIntoFirstVirtualInventory(updateReason, clicked, inventory);
            } else {
                leftOverAmount = InventoryUtils.addItemCorrectly((Inventory)event.getWhoClicked().getInventory(), inventory.getItemStack(slot));
            }
            clicked.setAmount(leftOverAmount);
            inventory.setItemStackSilently(slot, clicked);
            inventory.callAfterUpdateEvent(updateReason, slot, previousStack, clicked);
        }
    }

    protected void handleVINumberKey(InventoryClickEvent event, VirtualInventory inventory, int slot, Player player, ItemStack clicked) {
        Window window = WindowManager.getInstance().getOpenWindow(player);
        if (window instanceof SingleWindow) {
            PlayerUpdateReason updateReason;
            int hotbarButton;
            PlayerInventory playerInventory = player.getInventory();
            ItemStack hotbarItem = playerInventory.getItem(hotbarButton = event.getHotbarButton());
            if (hotbarItem != null && hotbarItem.getType().isAir()) {
                hotbarItem = null;
            }
            if (inventory.setItemStack(updateReason = new PlayerUpdateReason(player, (InventoryEvent)event), slot, hotbarItem)) {
                playerInventory.setItem(hotbarButton, clicked);
            }
        }
    }

    protected void handleVIOffHandKey(InventoryClickEvent event, VirtualInventory inventory, int slot, Player player, ItemStack clicked) {
        Window window = WindowManager.getInstance().getOpenWindow(player);
        if (window instanceof SingleWindow) {
            PlayerUpdateReason updateReason;
            PlayerInventory playerInventory = player.getInventory();
            ItemStack offhandItem = playerInventory.getItemInOffHand();
            if (offhandItem != null && offhandItem.getType().isAir()) {
                offhandItem = null;
            }
            if (inventory.setItemStack(updateReason = new PlayerUpdateReason(player, (InventoryEvent)event), slot, offhandItem)) {
                playerInventory.setItemInOffHand(clicked);
            }
        }
    }

    protected void handleVIDrop(boolean ctrl, InventoryClickEvent event, VirtualInventory inventory, int slot, Player player, ItemStack clicked) {
        if (clicked == null) {
            return;
        }
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        if (ctrl) {
            if (inventory.setItemStack(updateReason, slot, null)) {
                InventoryUtils.dropItemLikePlayer(player, clicked);
            }
        } else if (inventory.addItemAmount(updateReason, slot, -1) == -1) {
            clicked.setAmount(1);
            InventoryUtils.dropItemLikePlayer(player, clicked);
        }
    }

    protected void handleVIDoubleClick(InventoryClickEvent event, VirtualInventory inventory, Player player, ItemStack cursor) {
        if (cursor == null) {
            return;
        }
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        cursor.setAmount(inventory.collectToCursor(updateReason, cursor));
        event.setCursor(cursor);
    }

    @Override
    public boolean handleItemDrag(UpdateReason updateReason, int slot, ItemStack oldStack, ItemStack newStack) {
        int viSlot;
        SlotElement.VISlotElement viSlotElement;
        VirtualInventory virtualInventory;
        SlotElement element = this.getSlotElement(slot);
        if (element != null) {
            element = element.getHoldingElement();
        }
        if (element instanceof SlotElement.VISlotElement && (virtualInventory = (viSlotElement = (SlotElement.VISlotElement)element).getVirtualInventory()).isSynced(viSlot = viSlotElement.getSlot(), oldStack)) {
            return virtualInventory.setItemStack(updateReason, viSlot, newStack);
        }
        return false;
    }

    @Override
    public void handleItemShift(InventoryClickEvent event) {
        ItemStack clicked;
        event.setCancelled(true);
        if (this.animation != null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        int amountLeft = this.putIntoFirstVirtualInventory(updateReason, clicked = event.getCurrentItem(), new VirtualInventory[0]);
        if (amountLeft != clicked.getAmount()) {
            if (amountLeft != 0) {
                event.getCurrentItem().setAmount(amountLeft);
            } else {
                event.getClickedInventory().setItem(event.getSlot(), null);
            }
        }
    }

    protected int putIntoFirstVirtualInventory(UpdateReason updateReason, ItemStack itemStack, VirtualInventory ... ignored) {
        LinkedHashSet<VirtualInventory> inventories = this.getAllVirtualInventories(ignored);
        int originalAmount = itemStack.getAmount();
        if (inventories.size() > 0) {
            for (VirtualInventory inventory : inventories) {
                int amountLeft = inventory.addItem(updateReason, itemStack);
                if (originalAmount == amountLeft) continue;
                return amountLeft;
            }
        }
        return originalAmount;
    }

    protected LinkedHashSet<VirtualInventory> getAllVirtualInventories(VirtualInventory ... ignored) {
        return Arrays.stream(this.slotElements).filter(Objects::nonNull).map(SlotElement::getHoldingElement).filter(element -> element instanceof SlotElement.VISlotElement).map(element -> ((SlotElement.VISlotElement)element).getVirtualInventory()).filter(vi -> Arrays.stream(ignored).noneMatch(vi::equals)).sorted((vi1, vi2) -> -Integer.compare(vi1.getGuiShiftPriority(), vi2.getGuiShiftPriority())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public void handleSlotElementUpdate(GUI child, int slotIndex) {
        for (int index = 0; index < this.size; ++index) {
            SlotElement.LinkedSlotElement linkedSlotElement;
            SlotElement element = this.slotElements[index];
            if (!(element instanceof SlotElement.LinkedSlotElement) || (linkedSlotElement = (SlotElement.LinkedSlotElement)element).getGui() != child || linkedSlotElement.getSlotIndex() != slotIndex) continue;
            for (GUIParent parent : this.parents) {
                parent.handleSlotElementUpdate(this, index);
            }
        }
    }

    @Override
    public void addParent(@NotNull GUIParent parent) {
        this.parents.add(parent);
    }

    @Override
    public void removeParent(@NotNull GUIParent parent) {
        this.parents.remove(parent);
    }

    @Override
    public Set<GUIParent> getParents() {
        return this.parents;
    }

    @Override
    public List<Window> findAllWindows() {
        ArrayList<Window> windows = new ArrayList<Window>();
        ArrayList<GUIParent> parents = new ArrayList<GUIParent>(this.parents);
        while (!parents.isEmpty()) {
            ArrayList<GUIParent> parents1 = new ArrayList<GUIParent>(parents);
            parents.clear();
            for (GUIParent parent : parents1) {
                if (parent instanceof GUI) {
                    parents.addAll(((GUI)parent).getParents());
                    continue;
                }
                if (!(parent instanceof Window)) continue;
                windows.add((Window)parent);
            }
        }
        return windows;
    }

    @Override
    public Set<Player> findAllCurrentViewers() {
        return this.findAllWindows().stream().map(Window::getCurrentViewer).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void closeForAllViewers() {
        this.findAllCurrentViewers().forEach(HumanEntity::closeInventory);
    }

    @Override
    public void playAnimation(@NotNull Animation animation, @Nullable Predicate<SlotElement> filter) {
        if (animation != null) {
            this.cancelAnimation();
        }
        this.animation = animation;
        this.animationElements = (SlotElement[])this.slotElements.clone();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < this.size; ++i) {
            SlotElement element = this.getSlotElement(i);
            if (element == null || filter != null && !filter.test(element)) continue;
            slots.add(i);
            this.setSlotElement(i, null);
        }
        animation.setSlots(slots);
        animation.setGUI(this);
        animation.setWindows(this.findAllWindows());
        animation.addShowHandler((frame, index) -> this.setSlotElement((int)index, this.animationElements[index]));
        animation.addFinishHandler(() -> {
            this.animation = null;
            this.animationElements = null;
        });
        animation.start();
    }

    @Override
    public void cancelAnimation() {
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
            for (int i = 0; i < this.size; ++i) {
                this.setSlotElement(i, this.animationElements[i]);
            }
            this.animationElements = null;
        }
    }

    @Override
    public void updateControlItems() {
        for (SlotElement element : this.slotElements) {
            Item item;
            if (!(element instanceof SlotElement.ItemSlotElement) || !((item = ((SlotElement.ItemSlotElement)element).getItem()) instanceof ControlItem)) continue;
            item.notifyWindows();
        }
    }

    @Override
    public void setSlotElement(int index, SlotElement slotElement) {
        GUI newLink;
        Item item;
        SlotElement oldElement = this.slotElements[index];
        this.slotElements[index] = slotElement;
        if (slotElement instanceof SlotElement.ItemSlotElement && (item = ((SlotElement.ItemSlotElement)slotElement).getItem()) instanceof ControlItem) {
            ((ControlItem)item).setGui(this);
        }
        this.parents.forEach(parent -> parent.handleSlotElementUpdate(this, index));
        GUI oldLink = oldElement instanceof SlotElement.LinkedSlotElement ? ((SlotElement.LinkedSlotElement)oldElement).getGui() : null;
        GUI gUI = newLink = slotElement instanceof SlotElement.LinkedSlotElement ? ((SlotElement.LinkedSlotElement)slotElement).getGui() : null;
        if (newLink == oldLink) {
            return;
        }
        if (oldLink != null && Arrays.stream(this.slotElements).filter(element -> element instanceof SlotElement.LinkedSlotElement).map(element -> ((SlotElement.LinkedSlotElement)element).getGui()).noneMatch(gui -> gui == oldLink)) {
            oldLink.removeParent(this);
        }
        if (newLink != null) {
            newLink.addParent(this);
        }
    }

    @Override
    public SlotElement getSlotElement(int index) {
        return this.slotElements[index];
    }

    @Override
    public boolean hasSlotElement(int index) {
        return this.slotElements[index] != null;
    }

    @Override
    public SlotElement[] getSlotElements() {
        return (SlotElement[])this.slotElements.clone();
    }

    @Override
    public void setItem(int index, Item item) {
        this.remove(index);
        if (item != null) {
            this.setSlotElement(index, new SlotElement.ItemSlotElement(item));
        }
    }

    @Override
    public void addItems(Item ... items) {
        for (Item item : items) {
            int emptyIndex = ArrayUtils.findFirstEmptyIndex(this.slotElements);
            if (emptyIndex == -1) break;
            this.setItem(emptyIndex, item);
        }
    }

    @Override
    public Item getItem(int index) {
        SlotElement holdingElement;
        SlotElement slotElement = this.slotElements[index];
        if (slotElement instanceof SlotElement.ItemSlotElement) {
            return ((SlotElement.ItemSlotElement)slotElement).getItem();
        }
        if (slotElement instanceof SlotElement.LinkedSlotElement && (holdingElement = slotElement.getHoldingElement()) instanceof SlotElement.ItemSlotElement) {
            return ((SlotElement.ItemSlotElement)holdingElement).getItem();
        }
        return null;
    }

    @Override
    public ItemProvider getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(ItemProvider itemProvider) {
        this.background = itemProvider;
    }

    @Override
    public void remove(int index) {
        this.setSlotElement(index, null);
    }

    @Override
    public void applyStructure(Structure structure) {
        structure.getIngredientList().insertIntoGUI(this);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSlotElement(int x, int y, SlotElement slotElement) {
        this.setSlotElement(this.convToIndex(x, y), slotElement);
    }

    @Override
    public SlotElement getSlotElement(int x, int y) {
        return this.getSlotElement(this.convToIndex(x, y));
    }

    @Override
    public boolean hasSlotElement(int x, int y) {
        return this.hasSlotElement(this.convToIndex(x, y));
    }

    @Override
    public void setItem(int x, int y, Item item) {
        this.setItem(this.convToIndex(x, y), item);
    }

    @Override
    public Item getItem(int x, int y) {
        return this.getItem(this.convToIndex(x, y));
    }

    @Override
    public void remove(int x, int y) {
        this.remove(this.convToIndex(x, y));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private int convToIndex(int x, int y) {
        if (x >= this.width || y >= this.height) {
            throw new IllegalArgumentException("Coordinates out of bounds");
        }
        return SlotUtils.convertToIndex(x, y, this.width);
    }

    public void fill(@NotNull Set<Integer> slots, @Nullable Item item, boolean replaceExisting) {
        for (int slot : slots) {
            if (!replaceExisting && this.hasSlotElement(slot)) continue;
            this.setItem(slot, item);
        }
    }

    @Override
    public void fill(int start, int end, @Nullable Item item, boolean replaceExisting) {
        for (int i = start; i < end; ++i) {
            if (!replaceExisting && this.hasSlotElement(i)) continue;
            this.setItem(i, item);
        }
    }

    @Override
    public void fill(@Nullable Item item, boolean replaceExisting) {
        this.fill(0, this.getSize(), item, replaceExisting);
    }

    @Override
    public void fillRow(int row, @Nullable Item item, boolean replaceExisting) {
        if (row >= this.height) {
            throw new IllegalArgumentException("Row out of bounds");
        }
        this.fill(SlotUtils.getSlotsRow(row, this.width), item, replaceExisting);
    }

    @Override
    public void fillColumn(int column, @Nullable Item item, boolean replaceExisting) {
        if (column >= this.width) {
            throw new IllegalArgumentException("Column out of bounds");
        }
        this.fill(SlotUtils.getSlotsColumn(column, this.width, this.height), item, replaceExisting);
    }

    @Override
    public void fillBorders(@Nullable Item item, boolean replaceExisting) {
        this.fill(SlotUtils.getSlotsBorders(this.width, this.height), item, replaceExisting);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, @Nullable Item item, boolean replaceExisting) {
        this.fill(SlotUtils.getSlotsRect(x, y, width, height, this.width), item, replaceExisting);
    }

    @Override
    public void fillRectangle(int x, int y, @NotNull GUI gui, boolean replaceExisting) {
        int slotIndex = 0;
        for (int slot : SlotUtils.getSlotsRect(x, y, gui.getWidth(), gui.getHeight(), this.width)) {
            if (this.hasSlotElement(slot) && !replaceExisting) continue;
            this.setSlotElement(slot, new SlotElement.LinkedSlotElement(gui, slotIndex));
            ++slotIndex;
        }
    }

    @Override
    public void fillRectangle(int x, int y, int width, @NotNull VirtualInventory virtualInventory, boolean replaceExisting) {
        this.fillRectangle(x, y, width, virtualInventory, null, replaceExisting);
    }

    @Override
    public void fillRectangle(int x, int y, int width, @NotNull VirtualInventory virtualInventory, @Nullable ItemProvider background, boolean replaceExisting) {
        int height = (int)Math.ceil((double)virtualInventory.getSize() / (double)width);
        int slotIndex = 0;
        for (int slot : SlotUtils.getSlotsRect(x, y, width, height, this.width)) {
            if (slotIndex >= virtualInventory.getSize()) {
                return;
            }
            if (this.hasSlotElement(slot) && !replaceExisting) continue;
            this.setSlotElement(slot, new SlotElement.VISlotElement(virtualInventory, slotIndex, background));
            ++slotIndex;
        }
    }
}

