/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.inventoryaccess.version;

import de.studiocode.inventoryaccess.util.VersionUtils;

public enum InventoryAccessRevision {
    R12("r12", "1.19.3"),
    R11("r11", "1.19.1"),
    R10("r10", "1.19.0"),
    R9("r9", "1.18.2"),
    R8("r8", "1.18.0"),
    R7("r7", "1.17.1"),
    R6("r6", "1.17.0"),
    R5("r5", "1.16.4"),
    R4("r4", "1.16.2"),
    R3("r3", "1.16.0"),
    R2("r2", "1.15.0"),
    R1("r1", "1.14.0");

    public static final InventoryAccessRevision REQUIRED_REVISION;
    private final String packageName;
    private final int[] since;

    private InventoryAccessRevision(String packageName, String since) {
        this.packageName = packageName;
        this.since = VersionUtils.toMajorMinorPatch(since);
    }

    private static InventoryAccessRevision getRequiredRevision() {
        for (InventoryAccessRevision revision : InventoryAccessRevision.values()) {
            if (!VersionUtils.isServerHigherOrEqual(revision.getSince())) continue;
            return revision;
        }
        throw new UnsupportedOperationException("Your version of Minecraft is not supported by InventoryAccess");
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int[] getSince() {
        return this.since;
    }

    static {
        REQUIRED_REVISION = InventoryAccessRevision.getRequiredRevision();
    }
}

