/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.inventoryaccess.r3.util;

import de.studiocode.inventoryaccess.abstraction.util.InventoryUtils;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import net.minecraft.server.v1_16_R1.Container;
import net.minecraft.server.v1_16_R1.Containers;
import net.minecraft.server.v1_16_R1.EntityHuman;
import net.minecraft.server.v1_16_R1.EntityPlayer;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.ICrafting;
import net.minecraft.server.v1_16_R1.IInventory;
import net.minecraft.server.v1_16_R1.ITileInventory;
import net.minecraft.server.v1_16_R1.Packet;
import net.minecraft.server.v1_16_R1.PacketPlayOutOpenWindow;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_16_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtilsImpl
implements InventoryUtils {
    public static IChatBaseComponent createNMSComponent(ComponentWrapper component) {
        return IChatBaseComponent.ChatSerializer.a((String)component.serializeToJson());
    }

    public static int getActiveWindowId(EntityPlayer player) {
        Container container = player.activeContainer;
        return container == null ? -1 : container.windowId;
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory) {
        this.openCustomInventory(player, inventory, null);
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory, @Nullable ComponentWrapper title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        if (entityPlayer.playerConnection != null) {
            CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
            if ((container = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)entityPlayer, (Container)container)) != null) {
                IInventory iinventory = ((CraftInventory)inventory).getInventory();
                IChatBaseComponent titleComponent = title == null ? (iinventory instanceof ITileInventory ? ((ITileInventory)iinventory).getScoreboardDisplayName() : CraftChatMessage.fromString((String)container.getBukkitView().getTitle())[0]) : InventoryUtilsImpl.createNMSComponent(title);
                entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, windowType, titleComponent));
                entityPlayer.activeContainer = container;
                entityPlayer.activeContainer.addSlotListener((ICrafting)entityPlayer);
            }
        }
    }

    @Override
    public void updateOpenInventoryTitle(@NotNull Player player, @NotNull ComponentWrapper title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        Container container = entityPlayer.activeContainer;
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, container.getType(), InventoryUtilsImpl.createNMSComponent(title)));
        entityPlayer.updateInventory(container);
    }
}

