/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.inventoryaccess.r2.inventory;

import de.studiocode.inventoryaccess.abstraction.inventory.CartographyInventory;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.r2.util.InventoryUtilsImpl;
import de.studiocode.inventoryaccess.util.ReflectionUtils;
import java.lang.reflect.Field;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.Container;
import net.minecraft.server.v1_15_R1.ContainerAccess;
import net.minecraft.server.v1_15_R1.ContainerCartography;
import net.minecraft.server.v1_15_R1.Containers;
import net.minecraft.server.v1_15_R1.EntityHuman;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.IInventory;
import net.minecraft.server.v1_15_R1.InventoryCraftResult;
import net.minecraft.server.v1_15_R1.NonNullList;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_15_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_15_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_15_R1.Slot;
import net.minecraft.server.v1_15_R1.World;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CartographyInventoryImpl
extends ContainerCartography
implements CartographyInventory {
    private static final Field RESULT_CONTAINER_FIELD = ReflectionUtils.getField(ContainerCartography.class, true, "resultInventory");
    private final InventoryCraftResult resultInventory = (InventoryCraftResult)ReflectionUtils.getFieldValue(RESULT_CONTAINER_FIELD, this);
    private final IChatBaseComponent title;
    private final CraftInventoryView view;
    private final EntityPlayer player;
    private boolean open;

    public CartographyInventoryImpl(Player player, @NotNull ComponentWrapper title) {
        this(((CraftPlayer)player).getHandle(), InventoryUtilsImpl.createNMSComponent(title));
    }

    public CartographyInventoryImpl(EntityPlayer player, IChatBaseComponent title) {
        super(player.nextContainerCounter(), player.inventory, ContainerAccess.at((World)player.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
        this.player = player;
        this.title = title;
        CraftInventoryCartography inventory = new CraftInventoryCartography(this.inventory, (IInventory)this.resultInventory);
        this.view = new CraftInventoryView((HumanEntity)player.getBukkitEntity(), (Inventory)inventory, (Container)this);
    }

    @Override
    public void open() {
        this.open = true;
        CraftEventFactory.callInventoryOpenEvent((EntityPlayer)this.player, (Container)this);
        this.player.activeContainer = this;
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(this.windowId, Containers.CARTOGRAPHY_TABLE, this.title));
        NonNullList itemsList = NonNullList.a((Object)net.minecraft.server.v1_15_R1.ItemStack.a, (Object[])new net.minecraft.server.v1_15_R1.ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2)});
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutWindowItems(InventoryUtilsImpl.getActiveWindowId(this.player), itemsList));
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public void sendItem(int slot) {
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutSetSlot(InventoryUtilsImpl.getActiveWindowId(this.player), slot, this.getItem(slot)));
    }

    public void setItem(int slot, net.minecraft.server.v1_15_R1.ItemStack item) {
        if (slot < 2) {
            this.inventory.setItem(slot, item);
        } else {
            this.resultInventory.setItem(0, item);
        }
        if (this.open) {
            this.sendItem(slot);
        }
    }

    private net.minecraft.server.v1_15_R1.ItemStack getItem(int slot) {
        if (slot < 2) {
            return this.inventory.getItem(slot);
        }
        return this.resultInventory.getItem(0);
    }

    @Override
    public void setItem(int slot, ItemStack itemStack) {
        this.setItem(slot, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public Inventory getBukkitInventory() {
        return this.view.getTopInventory();
    }

    public CraftInventoryView getBukkitView() {
        return this.view;
    }

    public void a(IInventory inventory) {
    }

    public net.minecraft.server.v1_15_R1.ItemStack shiftClick(EntityHuman entityhuman, int i) {
        return net.minecraft.server.v1_15_R1.ItemStack.a;
    }

    public boolean a(net.minecraft.server.v1_15_R1.ItemStack itemstack, Slot slot) {
        return true;
    }

    public boolean canUse(EntityHuman entityhuman) {
        return true;
    }

    public void b(EntityHuman entityHuman) {
    }
}

