/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.inventoryaccess.r12.util;

import de.studiocode.inventoryaccess.abstraction.util.PlayerUtils;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.map.MapIcon;
import de.studiocode.inventoryaccess.map.MapPatch;
import de.studiocode.inventoryaccess.r12.util.InventoryUtilsImpl;
import de.studiocode.inventoryaccess.util.DataUtils;
import de.studiocode.inventoryaccess.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutResourcePackSend;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerUtilsImpl
implements PlayerUtils {
    private static final Method REGISTER_LISTENERS_METHOD = ReflectionUtils.getMethod(AdvancementDataPlayer.class, true, "c", AdvancementDataWorld.class);

    @Override
    public void stopAdvancementListening(@NotNull Player player) {
        this.stopAdvancementListening(((CraftPlayer)player).getHandle());
    }

    @Override
    public void stopAdvancementListening(@NotNull Object player) {
        ((EntityPlayer)player).N().a();
    }

    @Override
    public void startAdvancementListening(@NotNull Player player) {
        this.startAdvancementListening(((CraftPlayer)player).getHandle());
    }

    @Override
    public void startAdvancementListening(@NotNull Object player) {
        AdvancementDataPlayer advancements = ((EntityPlayer)player).N();
        AdvancementDataWorld manager = ((CraftServer)Bukkit.getServer()).getServer().ay();
        ReflectionUtils.invokeMethod(REGISTER_LISTENERS_METHOD, advancements, manager);
    }

    @Override
    public void sendMapUpdate(@NotNull Player player, int mapId, byte scale, boolean locked, @Nullable MapPatch mapPatch, @Nullable List<MapIcon> icons) {
        List decorations = icons != null ? (List)icons.stream().map(this::toMapDecoration).collect(Collectors.toCollection(ArrayList::new)) : null;
        WorldMap.b patch = this.toMapPatch(mapPatch);
        PacketPlayOutMap packet = new PacketPlayOutMap(mapId, scale, locked, (Collection)decorations, patch);
        ((CraftPlayer)player).getHandle().b.a((Packet)packet);
    }

    private net.minecraft.world.level.saveddata.maps.MapIcon toMapDecoration(MapIcon icon) {
        return new net.minecraft.world.level.saveddata.maps.MapIcon(MapIcon.Type.a((byte)icon.getType().getId()), icon.getX(), icon.getY(), icon.getRot(), icon.getComponent() != null ? InventoryUtilsImpl.createNMSComponent(icon.getComponent()) : null);
    }

    private WorldMap.b toMapPatch(MapPatch patch) {
        if (patch == null) {
            return null;
        }
        return new WorldMap.b(patch.getStartX(), patch.getStartY(), patch.getWidth(), patch.getHeight(), patch.getColors());
    }

    @Override
    public void sendResourcePack(@NotNull Player player, @NotNull String url, byte[] hash, @Nullable ComponentWrapper prompt, boolean force) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PacketPlayOutResourcePackSend packet = new PacketPlayOutResourcePackSend(url, DataUtils.toHexadecimalString(hash), force, InventoryUtilsImpl.createNMSComponent(prompt));
        serverPlayer.b.b.a((Packet)packet);
    }
}

