/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.inventoryaccess.r12.util;

import de.studiocode.inventoryaccess.abstraction.util.InventoryUtils;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_19_R2.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtilsImpl
implements InventoryUtils {
    public static IChatBaseComponent createNMSComponent(ComponentWrapper component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.fromJSON((String)component.serializeToJson());
    }

    public static int getActiveWindowId(EntityPlayer player) {
        Container container = player.bU;
        return container == null ? -1 : container.j;
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory) {
        this.openCustomInventory(player, inventory, null);
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory, @Nullable ComponentWrapper title) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Containers menuType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        if (serverPlayer.b != null) {
            CraftContainer menu = new CraftContainer(inventory, (EntityHuman)serverPlayer, serverPlayer.nextContainerCounter());
            if ((menu = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)serverPlayer, (Container)menu)) != null) {
                IInventory container = ((CraftInventory)inventory).getInventory();
                IChatBaseComponent titleComponent = title == null ? (container instanceof ITileInventory ? ((ITileInventory)container).C_() : CraftChatMessage.fromString((String)menu.getBukkitView().getTitle())[0]) : InventoryUtilsImpl.createNMSComponent(title);
                menu.checkReachable = false;
                serverPlayer.b.a((Packet)new PacketPlayOutOpenWindow(menu.j, menuType, titleComponent));
                serverPlayer.bU = menu;
                serverPlayer.a((Container)menu);
            }
        }
    }

    @Override
    public void updateOpenInventoryTitle(@NotNull Player player, @NotNull ComponentWrapper title) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Container menu = serverPlayer.bU;
        serverPlayer.b.a((Packet)new PacketPlayOutOpenWindow(menu.j, menu.a(), InventoryUtilsImpl.createNMSComponent(title)));
        serverPlayer.a(menu);
    }
}

