/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Utilities;

import com.itsrainingplex.GUI.GUIManager;
import com.itsrainingplex.LuckPerms.LuckPermsManager;
import com.itsrainingplex.LuckPerms.PrefixItem;
import com.itsrainingplex.LuckPerms.PrefixManager;
import com.itsrainingplex.LuckPerms.SuffixItem;
import com.itsrainingplex.LuckPerms.SuffixManager;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.Rank;
import com.itsrainingplex.Ranks.RankClickEvent;
import com.itsrainingplex.Ranks.RankGUI;
import com.itsrainingplex.Ranks.RankItem;
import com.itsrainingplex.Ranks.RankManager;
import com.itsrainingplex.Towny.TownyManager;
import com.itsrainingplex.Utilities.CheckDepends;
import com.itsrainingplex.Utilities.CoolDownManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RankSettings {
    private final RaindropQuests plugin;
    public RankManager rankManager;
    public RankGUI rankGUI;
    public RankClickEvent rankClickEvent;
    public LuckPermsManager lpm;
    public CheckDepends checkDepends;
    public GUIManager guiManager;
    public PrefixManager prefixManager;
    public SuffixManager suffixManager;
    public CoolDownManager prefixCoolDownManager;
    public CoolDownManager suffixCoolDownManager;
    public TownyManager townyManager;
    public TreeMap<String, Rank> ranks = new TreeMap();
    public TreeMap<String, Rank> altRanks = new TreeMap();
    public TreeMap<String, RankItem> ranksGUIItem = new TreeMap();
    public TreeMap<String, PrefixItem> prefixGUIItem = new TreeMap();
    public TreeMap<String, SuffixItem> suffixGUIItem = new TreeMap();
    public List<String> tree = new ArrayList<String>();
    public Set<String> rankIDs = new TreeSet<String>();
    public Set<String> altRankIDs = new TreeSet<String>();
    public String treeType;
    public String guiType;
    public String townPrefixMaterial;
    public String nationPrefixMaterial;
    public String townSuffixMaterial;
    public String nationSuffixMaterial;
    public String removePrefixMaterial;
    public String removeSuffixMaterial;
    public int prefixPriority;
    public int suffixPriority;
    public int prefixCoolDown;
    public int suffixCoolDown;
    public int townyPrefixTab;
    public int townySuffixTab;
    public boolean sharedCoolDown;
    public boolean townyPrefix;
    public boolean townySuffix;
    public boolean alternateRanks;
    public boolean nationNamePrefix;
    public boolean townNamePrefix;
    public boolean nationNameSuffix;
    public boolean townNameSuffix;
    public FileConfiguration config;
    public FileConfiguration ranksConfig;
    public FileConfiguration titlesConfig;
    private final File rankDir;

    public RankSettings(RaindropQuests plugin) {
        this.plugin = plugin;
        this.rankManager = new RankManager(plugin);
        this.rankGUI = new RankGUI(plugin);
        this.checkDepends = new CheckDepends();
        this.rankClickEvent = new RankClickEvent(plugin);
        this.guiManager = new GUIManager(plugin);
        this.suffixManager = new SuffixManager(plugin);
        this.prefixManager = new PrefixManager(plugin);
        this.lpm = new LuckPermsManager(plugin);
        this.prefixCoolDownManager = new CoolDownManager();
        this.suffixCoolDownManager = new CoolDownManager();
        if (plugin.settings.towny) {
            this.townyManager = new TownyManager();
        }
        this.rankDir = new File(plugin.getDataFolder() + File.separator + "Ranks");
        this.loadConfig();
        this.loadRanksConfig();
        this.loadTitlesConfig();
        this.loadFiles();
    }

    public void loadFiles() {
        Rank rank;
        this.treeType = this.config.getString("Type");
        this.guiType = this.config.getString("GUIType");
        this.prefixPriority = this.config.getInt("Prefix.Priority");
        this.prefixCoolDown = this.config.getInt("Prefix.CoolDown");
        this.townyPrefix = this.config.getBoolean("Prefix.TownTitle");
        this.townPrefixMaterial = this.config.getString("Prefix.TownMaterial");
        this.nationPrefixMaterial = this.config.getString("Prefix.NationMaterial");
        this.townyPrefixTab = this.config.getInt("Prefix.TownyTab");
        this.suffixPriority = this.config.getInt("Suffix.Priority");
        this.suffixCoolDown = this.config.getInt("Suffix.CoolDown");
        this.sharedCoolDown = this.config.getBoolean("SharedCoolDown");
        this.townySuffix = this.config.getBoolean("Suffix.TownTitle");
        this.townSuffixMaterial = this.config.getString("Suffix.TownMaterial");
        this.nationSuffixMaterial = this.config.getString("Suffix.NationMaterial");
        this.townySuffixTab = this.config.getInt("Suffix.TownyTab");
        this.alternateRanks = this.config.getBoolean("AlternateRanks");
        this.townNamePrefix = this.config.getBoolean("Prefix.TownName");
        this.nationNamePrefix = this.config.getBoolean("Prefix.NationName");
        this.townNameSuffix = this.config.getBoolean("Suffix.TownName");
        this.nationNameSuffix = this.config.getBoolean("Suffix.NationName");
        this.removePrefixMaterial = this.config.getString("Prefix.RemoveMaterial");
        this.removeSuffixMaterial = this.config.getString("Suffix.RemoveMaterial");
        this.rankIDs = Objects.requireNonNull(this.ranksConfig.getConfigurationSection("")).getKeys(false);
        for (String str : this.rankIDs) {
            rank = new Rank(this.ranksConfig.getString(str + ".Name"), this.ranksConfig.getString(str + ".Material"), str, this.ranksConfig.getStringList(str + ".RequiredRank"), this.ranksConfig.getStringList(str + ".mcMMO"), this.ranksConfig.getStringList(str + ".JobsReborn"), this.ranksConfig.getStringList(str + ".Kills"), this.ranksConfig.getStringList(str + ".Crafting"), this.ranksConfig.getStringList(str + ".Path"), this.ranksConfig.getString(str + ".LuckPermsGroup"), this.ranksConfig.getString(str + ".Prefix"), this.ranksConfig.getString(str + ".Suffix"), this.ranksConfig.getStringList(str + ".Cost"), this.ranksConfig.getInt(str + ".Weight"), this.ranksConfig.getInt(str + ".Tier"), this.ranksConfig.getStringList(str + ".Commands"));
            this.ranks.put(str, rank);
            this.ranksGUIItem.put(str, new RankItem(this.plugin, rank));
            this.prefixGUIItem.put(str, new PrefixItem(this.plugin, rank));
            this.suffixGUIItem.put(str, new SuffixItem(this.plugin, rank));
        }
        for (Rank rank2 : this.ranks.values()) {
            List<String> paths = rank2.path;
            rank2.pathNames = new ArrayList<String>();
            for (String path : paths) {
                rank2.pathNames.add(this.ranks.get((Object)path.toLowerCase()).rankName);
            }
        }
        for (Rank rank2 : this.ranks.values()) {
            List<String> requiredRanks = rank2.requiredRank;
            rank2.requiredRankNames = new ArrayList<String>();
            for (String required : requiredRanks) {
                rank2.requiredRankNames.add(this.ranks.get((Object)required.toLowerCase()).rankName);
            }
        }
        if (this.alternateRanks) {
            this.altRankIDs = Objects.requireNonNull(this.titlesConfig.getConfigurationSection("")).getKeys(false);
            for (String str : this.altRankIDs) {
                rank = new Rank(this.titlesConfig.getString(str + ".Name"), this.titlesConfig.getString(str + ".Material"), str, null, null, null, null, null, null, this.titlesConfig.getString(str + ".LuckPermsGroup"), this.titlesConfig.getString(str + ".Prefix"), this.titlesConfig.getString(str + ".Suffix"), null, -1, this.titlesConfig.getInt(str + ".Tier"), null);
                this.altRanks.put(str, rank);
                this.prefixGUIItem.put(str, new PrefixItem(this.plugin, rank));
                this.suffixGUIItem.put(str, new SuffixItem(this.plugin, rank));
            }
        }
    }

    public void loadConfig() {
        File ranksConfigFile = new File(this.plugin.getDataFolder(), "Ranks" + File.separator + "config.yml");
        if (!ranksConfigFile.exists()) {
            boolean created = this.rankDir.mkdir();
            if (created) {
                this.plugin.getLogger().info("Ranks directory created...");
            }
            this.plugin.saveResource("Ranks" + File.separator + "config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)ranksConfigFile);
    }

    public void loadRanksConfig() {
        File ranksFile = new File(this.plugin.getDataFolder(), "Ranks" + File.separator + "ranks.yml");
        if (!ranksFile.exists()) {
            boolean created = this.rankDir.mkdir();
            if (created) {
                this.plugin.getLogger().info("Ranks directory created...");
            }
            this.plugin.saveResource("Ranks" + File.separator + "ranks.yml", false);
        }
        this.ranksConfig = YamlConfiguration.loadConfiguration((File)ranksFile);
    }

    public void loadTitlesConfig() {
        File titlesFiles = new File(this.plugin.getDataFolder(), "Ranks" + File.separator + "titles.yml");
        if (!titlesFiles.exists()) {
            boolean created = this.rankDir.mkdir();
            if (created) {
                this.plugin.getLogger().info("Ranks directory created...");
            }
            this.plugin.saveResource("Ranks" + File.separator + "titles.yml", false);
        }
        this.titlesConfig = YamlConfiguration.loadConfiguration((File)titlesFiles);
    }

    public void reloadConfigs() {
        this.loadConfig();
        if (this.plugin.settings.luckPerms) {
            this.loadRanksConfig();
        }
        this.loadFiles();
    }
}

