/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Utilities;

import com.itsrainingplex.Listeners.NPCManager;
import com.itsrainingplex.RaindropQuests;
import github.scarsz.discordsrv.DiscordSRV;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.io.File;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.configuration.file.YamlConfiguration;

public class CheckDepends {
    public void checkDepends(RaindropQuests plugin) {
        plugin.settings.luckPerms = plugin.getServer().getPluginManager().isPluginEnabled("LuckPerms");
        plugin.settings.mythicMobs = plugin.getServer().getPluginManager().isPluginEnabled("MythicMobs");
        plugin.settings.towny = plugin.getServer().getPluginManager().isPluginEnabled("Towny");
        plugin.settings.jobs = plugin.getServer().getPluginManager().isPluginEnabled("Jobs");
        plugin.settings.mcMMO = plugin.getServer().getPluginManager().isPluginEnabled("mcMMO");
        plugin.settings.vault = plugin.getServer().getPluginManager().isPluginEnabled("Vault");
        plugin.settings.citizens = plugin.getServer().getPluginManager().isPluginEnabled("Citizens");
        plugin.settings.placeHolderAPI = plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        plugin.settings.discordSRV = plugin.getServer().getPluginManager().isPluginEnabled("DiscordSRV");
        if (plugin.settings.luckPerms) {
            plugin.getLogger().info("LuckPerms found. Enabling ranks...");
        } else {
            plugin.getLogger().warning("LuckPerms not found. Disabling ranks..");
        }
        if (plugin.settings.mcMMO) {
            plugin.getLogger().info("mcMMO found. Enabling mcMMO requirements..");
        } else {
            plugin.getLogger().warning("mcMMO not found. Disabling mcMMO requirements..");
        }
        if (plugin.settings.mythicMobs) {
            plugin.getLogger().info("MythicMobs found. Enabling MythicMobs requirements..");
            plugin.getLogger().info("Getting all MythicMob entity IDs..");
            for (MythicMob mythicMob : MythicBukkit.inst().getMobManager().getMobTypes()) {
                String s = mythicMob.toString().substring(10);
                s = s.substring(0, s.indexOf("}"));
                plugin.settings.mythicMobTypes.add(s);
            }
            if (!plugin.settings.mythicMobTypes.isEmpty()) {
                plugin.getLogger().info("MythicMob IDs found..");
            }
        } else {
            plugin.getLogger().warning("MythicMobs not found. Disabling MythicMobs requirements..");
        }
        if (plugin.settings.jobs) {
            plugin.getLogger().info("Jobs found. Enabling jobs requirements..");
        } else {
            plugin.getLogger().warning("Jobs not found. Disabling jobs requirements..");
        }
        if (plugin.settings.towny) {
            plugin.getLogger().info("Towny found. Enabling towny prefix/suffix titles");
        } else {
            plugin.getLogger().warning("Towny not found. Disabling towny prefix/suffix titles");
        }
        if (plugin.settings.citizens && plugin.settings.pm.getDebug()) {
            plugin.getLogger().info("Citizens found. Enabling NPCs...");
        } else if (!plugin.settings.citizens && plugin.settings.pm.getDebug()) {
            plugin.getLogger().warning("Citizens not found. Disabling NPC commands...");
        }
        if (plugin.settings.pm.getDebug() && plugin.settings.citizens) {
            plugin.getLogger().info("Registering npc listeners..");
        }
        if (plugin.settings.citizens) {
            plugin.settings.npcManager = new NPCManager(plugin);
        }
        if (plugin.settings.placeHolderAPI && plugin.settings.pm.getDebug()) {
            plugin.getLogger().info("PlaceholderAPI found. Hooking into API...");
        } else if (!plugin.settings.placeHolderAPI && plugin.settings.pm.getDebug()) {
            plugin.getLogger().info("PlaceholderAPI not found. Using legacy placeholder only...");
            plugin.getLogger().info("Legacy Placeholders: [%player_name%]");
        }
        if (plugin.settings.vault) {
            plugin.settings.rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (plugin.settings.rsp == null) {
                plugin.getLogger().info("Vault found but economy not enable. Check you configs...");
            } else {
                plugin.settings.economy = (Economy)plugin.settings.rsp.getProvider();
            }
        }
        if (plugin.settings.discordSRV) {
            plugin.getLogger().info("DiscordSRV found. Loading Web GUI...");
            File file = DiscordSRV.getPlugin().getLinkingFile();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            plugin.settings.discordSRV = config.getBoolean("Require linked account to play.Enabled");
            if (plugin.settings.discordSRV) {
                plugin.getLogger().info("Linked accounts are enabled! Continuing...");
            } else {
                plugin.getLogger().warning("Require linked accounts are not enabled! Disabling web GUI. Please see plugins > DiscordSRV > Require linked account to play > Enabled");
            }
        } else {
            plugin.getLogger().warning("DiscordSRV not found. Disabling Web GUI...");
        }
        if (plugin.settings.economy == null) {
            plugin.getLogger().warning("Vault found but no economy found! Ensure you have an economy plugin installed!");
        } else {
            plugin.settings.vault = true;
        }
    }
}

