/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Settings;

import com.itsrainingplex.AutoMelons.AutoMelonsConfig;
import com.itsrainingplex.Block.Block;
import com.itsrainingplex.Counters.KillCount;
import com.itsrainingplex.Crafting.Crystallize;
import com.itsrainingplex.Crafting.Dirt;
import com.itsrainingplex.Crafting.Dyes;
import com.itsrainingplex.Crafting.GoldenCraft;
import com.itsrainingplex.Crafting.IngotPassive;
import com.itsrainingplex.Crafting.ItemInfo;
import com.itsrainingplex.Crafting.NetherArmor;
import com.itsrainingplex.Crafting.NetherTools;
import com.itsrainingplex.Crafting.NetherWeapons;
import com.itsrainingplex.Crafting.Stone;
import com.itsrainingplex.Crafting.Transmog;
import com.itsrainingplex.Crafting.WheatSeedsGrown;
import com.itsrainingplex.EliteModSummons.EMSSettings;
import com.itsrainingplex.GUI.MainGUI;
import com.itsrainingplex.GUI.PassivesGUI;
import com.itsrainingplex.GUI.QuestGUI;
import com.itsrainingplex.Handlers.BlockHandler;
import com.itsrainingplex.Handlers.PotionCraftedHandler;
import com.itsrainingplex.Handlers.QuestHandler;
import com.itsrainingplex.Listeners.NPCInfo;
import com.itsrainingplex.Listeners.NPCManager;
import com.itsrainingplex.Main.MainItem;
import com.itsrainingplex.Main.MainMenuItem;
import com.itsrainingplex.Messages.CommandMessages;
import com.itsrainingplex.Messages.KillMessages;
import com.itsrainingplex.Messages.MythicKillMessages;
import com.itsrainingplex.Messages.PassivesMessage;
import com.itsrainingplex.Messages.PluginMessages;
import com.itsrainingplex.Messages.QuestMessage;
import com.itsrainingplex.Messages.RanksMessages;
import com.itsrainingplex.Messages.SendMessage;
import com.itsrainingplex.Messages.TitlesMessages;
import com.itsrainingplex.MySQL.MySQL;
import com.itsrainingplex.MySQL.SQLGetter;
import com.itsrainingplex.MySQL.UpdateSchema;
import com.itsrainingplex.NanoHTTPD.RankHTML;
import com.itsrainingplex.Passives.Passive;
import com.itsrainingplex.Passives.PassiveItem;
import com.itsrainingplex.Quests.Quest;
import com.itsrainingplex.Quests.QuestItem;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.SQLite.Database;
import com.itsrainingplex.Settings.RegisterCustomItems;
import com.itsrainingplex.Utilities.CheckDepends;
import com.itsrainingplex.Utilities.DataCheck;
import com.itsrainingplex.Utilities.Discord;
import com.itsrainingplex.Utilities.DiscordWebhook;
import com.itsrainingplex.Utilities.RankSettings;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Settings {
    private final RaindropQuests plugin;
    public Database db;
    public MySQL sql;
    public DataCheck dataChecker;
    public SQLGetter data;
    public UpdateSchema updateSchema;
    public PotionCraftedHandler potionHandler;
    public PluginMessages pm;
    public CommandMessages cm;
    public KillMessages km;
    public MythicKillMessages mkm;
    public RanksMessages rm;
    public TitlesMessages tm;
    public SendMessage send;
    public AutoMelonsConfig autoMelonsConfig;
    public NPCManager npcManager;
    public IngotPassive ingots;
    public Transmog transmog;
    public NetherTools netherTools;
    public NetherWeapons netherWeapons;
    public NetherArmor netherArmor;
    public Dirt dirt;
    public WheatSeedsGrown wsg;
    public Crystallize crystallize;
    public Dyes dyes;
    public GoldenCraft goldenCraft;
    public Stone stone;
    public QuestGUI questGUI;
    public PassivesGUI passivesGUI;
    public MainGUI mainGUI;
    public QuestHandler questHandler;
    public BlockHandler blockHandler;
    public RegisterCustomItems rci;
    public RankSettings ranks;
    public EMSSettings ems;
    public RankHTML rankHTML;
    public TreeMap<String, Passive> passives = new TreeMap();
    public TreeMap<String, ItemInfo> itemInfo = new TreeMap();
    public TreeMap<String, QuestItem> questsMap = new TreeMap();
    public TreeMap<String, PassiveItem> passiveItems = new TreeMap();
    public TreeMap<String, MainMenuItem> mainGUIMap = new TreeMap();
    public TreeMap<String, NPCInfo> NPCs = new TreeMap();
    public TreeMap<String, MainItem> mainGUIItemMap = new TreeMap();
    public TreeMap<String, PassivesMessage> passivesMessageMap;
    public TreeMap<String, String> mysql = new TreeMap();
    public TreeMap<String, Discord> discords = new TreeMap();
    public TreeMap<String, ItemStack> customItemMap = new TreeMap();
    public TreeMap<UUID, Long> coolDownNotify = new TreeMap();
    @Deprecated
    public TreeMap<UUID, KillCount> playerKills = new TreeMap();
    public TreeMap<String, String> discordInfo = new TreeMap();
    public ArrayList<Quest> quests = new ArrayList();
    public ArrayList<Block> blocks = new ArrayList();
    public ArrayList<ItemStack> customItems = new ArrayList();
    public ArrayList<String> vanillaMobsTypes;
    public ArrayList<String> mythicMobTypes;
    public ArrayList<String> allMobTypes;
    public ArrayList<String> bosses;
    public ArrayList<QuestItem> randomQuests;
    public Set<String> passiveNames;
    public Set<String> questNames;
    public NPC questNPC;
    public NPC storeNPC;
    public RegisteredServiceProvider<Economy> rsp;
    public Economy economy;
    @Deprecated
    public Inventory inv;
    public Material info_symbol;
    public String dbType;
    public String customMoneyName;
    public String economyVaultSymbol;
    public String prefix;
    public int numberOfQuests;
    public int webPort;
    public int numberOfPassives;
    public int interval;
    public int passivesNotifyInterval;
    public int availableQuests;
    public int randomQuestCoolDown;
    public int webExpirationKeyTime;
    public boolean customMoney;
    public boolean webEnabled;
    public boolean economyVault;
    public boolean sync;
    public boolean blockEvent;
    public boolean citizens;
    public boolean vault;
    public boolean placeHolderAPI;
    public boolean discordSRV;
    public boolean ranksEnabled;
    public boolean luckPerms;
    public boolean mcMMO;
    public boolean jobs;
    public boolean towny;
    public boolean mythicMobs;
    public boolean spawner;
    public boolean random;
    public boolean master;
    public File passivesFile;
    public File webFile;
    public File messagesFile;
    public File melonsFile;
    public File itemsFile;
    public File discordFile;
    public File melonsDir;
    public FileConfiguration config;
    public FileConfiguration questsConfig;
    public FileConfiguration passivesConfig;
    public FileConfiguration webConfig;
    public FileConfiguration messagesConfig;
    public FileConfiguration melonsConfig;
    public FileConfiguration itemsConfig;
    public FileConfiguration discordConfig;

    public Settings(RaindropQuests plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.loadQuestsConfig();
        this.loadPassivesConfig();
        this.loadWebConfig();
        this.loadMessagesConfig();
        this.loadMelonsConfig();
        this.loadItemsConfig();
        this.loadDiscordConfig();
        this.send = new SendMessage(plugin);
        this.questGUI = new QuestGUI(plugin);
        this.passivesGUI = new PassivesGUI(plugin);
        this.mainGUI = new MainGUI(plugin);
        this.ems = new EMSSettings(plugin);
        this.questHandler = new QuestHandler();
        this.vanillaMobsTypes = new ArrayList();
        this.mythicMobTypes = new ArrayList();
        this.potionHandler = new PotionCraftedHandler();
        this.updateSchema = new UpdateSchema(plugin);
        this.rankHTML = new RankHTML(plugin);
    }

    public void loadFiles() {
        TreeMap<String, String> map;
        this.pm = new PluginMessages();
        this.pm.setDebug(this.messagesConfig.getBoolean("Plugin.Debug"));
        this.pm.setExtendedDebug(this.messagesConfig.getBoolean("Plugin.ExtendedDebug"));
        this.pm.setDisable(this.messagesConfig.getBoolean("Plugin.Disable"));
        this.passivesNotifyInterval = this.messagesConfig.getInt("Passive.CoolDownInterval");
        this.plugin.getLogger().info("Checking SoftDepends..");
        new CheckDepends().checkDepends(this.plugin);
        LinkedHashSet<String> temp = new LinkedHashSet<String>();
        for (EntityType t : EntityType.values()) {
            this.vanillaMobsTypes.add(t.name());
            temp.add(t.name());
        }
        if (this.mythicMobs) {
            for (MythicMob mythic : MythicBukkit.inst().getMobManager().getMobTypes()) {
                String s = mythic.toString().substring(10);
                s = s.substring(0, s.indexOf("}"));
                temp.add(s);
            }
        }
        this.allMobTypes = new ArrayList(temp);
        this.ranksEnabled = this.config.getBoolean("Ranks.Enabled");
        this.info_symbol = Material.getMaterial((String)Objects.requireNonNull(this.config.getString("Info_Symbol")).toUpperCase());
        this.dbType = this.config.getString("DBType");
        this.customMoney = this.config.getBoolean("Economy.Custom");
        this.customMoneyName = this.config.getString("Economy.Name");
        this.economyVault = this.config.getBoolean("Economy.Vault");
        this.economyVaultSymbol = this.config.getString("Economy.Symbol");
        this.prefix = this.config.getString("Prefix");
        this.sync = this.config.getBoolean("Sync");
        this.interval = this.config.getInt("Interval");
        this.blockEvent = this.config.getBoolean("BlockEvent");
        this.spawner = this.config.getBoolean("Kills.Spawner");
        this.random = this.config.getBoolean("Quests.Random");
        this.availableQuests = this.config.getInt("Quests.Available");
        this.randomQuestCoolDown = this.config.getInt("Quests.CoolDown");
        this.master = this.config.getBoolean("Quests.Master");
        if (this.plugin.settings.economy == null) {
            this.plugin.settings.vault = false;
            this.plugin.getLogger().warning("Vault found but no economy found! Ensure you have an economy plugin installed!");
        }
        if (this.plugin.settings.vault && this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().info("Vault found. Hooking into economy...");
        } else if (!this.plugin.settings.vault && this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().warning("Vault not found. No economy present...");
        }
        if (this.economyVault) {
            this.rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            assert (this.rsp != null);
            this.economy = (Economy)this.rsp.getProvider();
        }
        Set guiItemNames = Objects.requireNonNull(this.config.getConfigurationSection("GUI")).getKeys(false);
        if (!this.plugin.settings.luckPerms) {
            guiItemNames.remove("Ranks");
            guiItemNames.remove("Prefix");
            guiItemNames.remove("Suffix");
        }
        for (String s : guiItemNames) {
            MainMenuItem mainMenuItem = new MainMenuItem(s, this.config.getString("GUI." + s + ".Name"), Objects.requireNonNull(this.config.getString("GUI." + s + ".Material")).toUpperCase(), this.config.getString("GUI." + s + ".Lore"), this.config.getInt("GUI." + s + ".Index"));
            this.mainGUIMap.put(s, mainMenuItem);
            this.mainGUIItemMap.put(s, new MainItem(this.plugin, mainMenuItem));
        }
        Set npcNames = Objects.requireNonNull(this.config.getConfigurationSection("Citizens")).getKeys(false);
        for (Object s : npcNames) {
            NPCInfo npcInfo = new NPCInfo(this.config.getBoolean("Citizens." + (String)s + ".Enabled"), this.config.getString("Citizens." + (String)s + ".Name"));
            this.NPCs.put((String)s, npcInfo);
        }
        this.mysql.put("hostname", this.config.getString("MySQL.hostname"));
        this.mysql.put("port", this.config.getString("MySQL.port"));
        this.mysql.put("database", this.config.getString("MySQL.database"));
        this.mysql.put("main_table", this.config.getString("MySQL.main_table"));
        this.mysql.put("quests_table", this.config.getString("MySQL.quests_table"));
        this.mysql.put("date_table", this.config.getString("MySQL.date_table"));
        this.mysql.put("blocks_table", this.config.getString("MySQL.blocks_table"));
        this.mysql.put("passives_table", this.config.getString("MySQL.passives_table"));
        this.mysql.put("counter_table", this.config.getString("MySQL.counter_table"));
        this.mysql.put("random_table", this.config.getString("MySQL.random_table"));
        if (this.config.getString("MySQL.potions_table") == null) {
            if (Objects.requireNonNull(this.config.getString("MySQL.potions_table")).isBlank()) {
                if (this.pm.getDebug()) {
                    this.plugin.getLogger().info("You have no set a potions table in the config! Using default...");
                }
                this.mysql.put("potions_table", "potions");
            }
        } else {
            this.mysql.put("potions_table", this.config.getString("MySQL.potions_table"));
        }
        this.mysql.put("username", this.config.getString("MySQL.username"));
        this.mysql.put("password", this.config.getString("MySQL.password"));
        this.mysql.put("useSSL", this.config.getString("MySQL.useSSL"));
        this.mysql.put("allowPublicKeyRetrieval", this.config.getString("MySQL.allowPublicKeyRetrieval"));
        Set discordNames = Objects.requireNonNull(this.discordConfig.getConfigurationSection("")).getKeys(false);
        for (Object s : discordNames) {
            if (((String)s).equalsIgnoreCase("Enabled")) continue;
            Discord discord = new Discord(new DiscordWebhook(this.discordConfig.getString((String)s + ".webhookURL")), this.discordConfig.getBoolean((String)s + ".Enabled"), this.discordConfig.getString((String)s + ".webhookImage"), this.discordConfig.getString((String)s + ".webhookUser"), this.discordConfig.getBoolean((String)s + ".webhookEmbedded"), this.discordConfig.getString((String)s + ".webhookColor"));
            this.discords.put((String)s, discord);
        }
        this.questNames = Objects.requireNonNull(this.questsConfig.getConfigurationSection("")).getKeys(false);
        this.numberOfQuests = this.questNames.size();
        int k = 0;
        for (String str : this.questNames) {
            QuestMessage message = new QuestMessage();
            map = new TreeMap<String, String>();
            map.put("Completed", this.questsConfig.getString(str + ".Messages.Completed"));
            message.setDiscord(this.questsConfig.getBoolean(str + ".Messages.Discord"));
            message.setLogger(this.questsConfig.getBoolean(str + ".Messages.Logger"));
            message.setBroadcast(this.questsConfig.getBoolean(str + ".Messages.Broadcast"));
            message.setPlayer(this.questsConfig.getBoolean(str + ".Messages.Player"));
            message.setMessages(map);
            Quest quest = new Quest(str, k, this.questsConfig.getString(str + ".Title"), this.questsConfig.getString(str + ".Button"), this.questsConfig.getStringList(str + ".Lore"), this.plugin.misc.convertToStringMap(this.questsConfig.getStringList(str + ".Requirements")), this.questsConfig.getInt(str + ".Economy.Vault"), this.questsConfig.getInt(str + ".Economy.Currency"), this.plugin.misc.convertToMap(this.questsConfig.getStringList(str + ".Reward")), this.questsConfig.getBoolean(str + ".Messages.Broadcast"), this.questsConfig.getBoolean(str + ".Messages.Discord"), this.questsConfig.getBoolean(str + ".Messages.Player"), this.questsConfig.getBoolean(str + ".Messages.Logger"), this.questsConfig.getString(str + ".Messages.Completed"), this.questsConfig.getInt(str + ".Cooldown"), this.questsConfig.getInt(str + ".Limit"), message);
            ++k;
            this.quests.add(quest);
            this.questsMap.put(str, new QuestItem(this.plugin, quest));
        }
        this.passiveNames = Objects.requireNonNull(this.passivesConfig.getConfigurationSection("Passives")).getKeys(false);
        this.numberOfPassives = this.passiveNames.size();
        int[] i = new int[]{this.passivesConfig.getInt("Passives.Superheat.Iron_Cost"), this.passivesConfig.getInt("Passives.Superheat.Gold_Cost"), this.passivesConfig.getInt("Passives.Superheat.Copper_Cost")};
        Material[] mats = new Material[]{Material.valueOf((String)Objects.requireNonNull(this.passivesConfig.getString("Passives.CraftNetherTools.Material")).toUpperCase()), Material.valueOf((String)Objects.requireNonNull(this.passivesConfig.getString("Passives.CraftNetherWeapons.Material")).toUpperCase()), Material.valueOf((String)Objects.requireNonNull(this.passivesConfig.getString("Passives.CraftNetherArmor.Material")).toUpperCase())};
        int j = 0;
        for (String string : this.passiveNames) {
            Passive passive = new Passive(string, this.passivesConfig.getString("Passives." + string + ".Name"), this.passivesConfig.getStringList("Passives." + string + ".Description"), Material.valueOf((String)Objects.requireNonNull(this.passivesConfig.getString("Passives." + string + ".Symbol")).toUpperCase()), this.passivesConfig.getDouble("Passives." + string + ".Percent"), this.passivesConfig.getInt("Passives." + string + ".Economy.Vault"), this.passivesConfig.getInt("Passives." + string + ".Economy.Currency"), this.passivesConfig.getStringList("Passives." + string + ".Items"), this.passivesConfig.getDouble("Passives." + string + ".Amount"), i, this.passivesConfig.getInt("Passives." + string + ".Cost"), mats, j, this.plugin.misc.convertToMap(this.passivesConfig.getStringList("Passives." + string + ".Requirements.Quests")), this.passivesConfig.getBoolean("Passives." + string + ".Primary"), this.passivesConfig.getBoolean("Passives." + string + ".QuasiPrimary"), Material.valueOf((String)Objects.requireNonNull(this.passivesConfig.getString("Passives.Mixologist.PrimaryItem")).toUpperCase()), Material.valueOf((String)Objects.requireNonNull(this.passivesConfig.getString("Passives.Mixologist.QuasiPrimaryItem")).toUpperCase()), this.passivesConfig.getInt("Passives.Transmutation.GoldenApple"), this.passivesConfig.getInt("Passives.Transmutation.GoldenCarrot"), this.passivesConfig.getInt("Passives.Transmutation.EnchantedGoldenApple"), this.passivesConfig.getInt("Passives." + string + ".Cooldown"));
            ++j;
            this.passives.put(string, passive);
            this.passiveItems.put(string, new PassiveItem(this.plugin, passive));
        }
        this.cm = new CommandMessages();
        this.cm.setDiscord(this.messagesConfig.getBoolean("Commands.Discord"));
        this.cm.setLogger(this.messagesConfig.getBoolean("Commands.Logger"));
        this.cm.setBroadcast(this.messagesConfig.getBoolean("Commands.Broadcast"));
        this.cm.setPlayer(this.messagesConfig.getBoolean("Commands.Player"));
        map = new TreeMap<String, String>();
        map.put("Info", this.messagesConfig.getString("Commands.Messages.Info"));
        map.put("QuestGUI", this.messagesConfig.getString("Commands.Messages.QuestGUI"));
        map.put("PassivesGUI", this.messagesConfig.getString("Commands.Messages.PassivesGUI"));
        map.put("QuestNPC", this.messagesConfig.getString("Commands.Messages.QuestNPC"));
        map.put("PassivesNPC", this.messagesConfig.getString("Commands.Messages.PassivesNPC"));
        this.cm.setMessages(map);
        this.passivesMessageMap = new TreeMap();
        for (String pass : this.passiveNames) {
            PassivesMessage message = new PassivesMessage();
            message.setDiscord(this.messagesConfig.getBoolean("Passives." + pass + ".Discord"));
            message.setLogger(this.messagesConfig.getBoolean("Passives." + pass + ".Logger"));
            message.setBroadcast(this.messagesConfig.getBoolean("Passives." + pass + ".Broadcast"));
            message.setPlayer(this.messagesConfig.getBoolean("Passives." + pass + ".Player"));
            TreeMap<String, String> map2 = new TreeMap<String, String>();
            map2.put("Purchased", this.messagesConfig.getString("Passives." + pass + ".Messages.Purchased"));
            map2.put("Used", this.messagesConfig.getString("Passives." + pass + ".Messages.Used"));
            message.setMessages(map2);
            this.passivesMessageMap.put(pass, message);
        }
        this.rm = new RanksMessages();
        this.rm.setDiscord(this.messagesConfig.getBoolean("Ranks.Discord"));
        this.rm.setLogger(this.messagesConfig.getBoolean("Ranks.Broadcast"));
        this.rm.setBroadcast(this.messagesConfig.getBoolean("Ranks.Logger"));
        this.rm.setPlayer(this.messagesConfig.getBoolean("Ranks.Player"));
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("Purchased", this.messagesConfig.getString("Ranks.Messages.Purchased"));
        this.rm.setMessages(treeMap);
        this.tm = new TitlesMessages();
        this.tm.setDiscord(this.messagesConfig.getBoolean("Titles.Discord"));
        this.tm.setLogger(this.messagesConfig.getBoolean("Titles.Broadcast"));
        this.tm.setBroadcast(this.messagesConfig.getBoolean("Titles.Logger"));
        this.tm.setPlayer(this.messagesConfig.getBoolean("Titles.Player"));
        TreeMap<String, String> titlesMap = new TreeMap<String, String>();
        titlesMap.put("PrefixSet", this.messagesConfig.getString("Titles.Messages.PrefixSet"));
        titlesMap.put("SuffixSet", this.messagesConfig.getString("Titles.Messages.SuffixSet"));
        this.tm.setMessages(titlesMap);
        this.km = new KillMessages();
        this.mkm = new MythicKillMessages();
        this.km.setDiscord(this.messagesConfig.getBoolean("Kills.Minecraft.Discord"));
        this.km.setLogger(this.messagesConfig.getBoolean("Kills.Minecraft.Broadcast"));
        this.km.setBroadcast(this.messagesConfig.getBoolean("Kills.Minecraft.Logger"));
        this.km.setPlayer(this.messagesConfig.getBoolean("Kills.Minecraft.Player"));
        this.km.setMobs(this.messagesConfig.getStringList("Kills.Minecraft.Mobs"));
        this.mkm.setDiscord(this.messagesConfig.getBoolean("Kills.MythicMobs.Discord"));
        this.mkm.setLogger(this.messagesConfig.getBoolean("Kills.MythicMobs.Broadcast"));
        this.mkm.setBroadcast(this.messagesConfig.getBoolean("Kills.MythicMobs.Logger"));
        this.mkm.setMobs(this.messagesConfig.getStringList("Kills.MythicMobs.Mobs"));
        Set itemIDs = Objects.requireNonNull(this.itemsConfig.getConfigurationSection("")).getKeys(false);
        for (String s : itemIDs) {
            this.itemInfo.put(s, new ItemInfo(this.itemsConfig.getString(s + ".Name"), Objects.requireNonNull(this.itemsConfig.getString(s + ".Material")).toUpperCase(), this.itemsConfig.getStringList(s + ".Lore")));
        }
        this.autoMelonsConfig = new AutoMelonsConfig(this.melonsConfig.getInt("slicesReturned"), this.melonsConfig.getString("wandMaterial"), this.melonsConfig.getBoolean("Enabled"), this.melonsConfig.getBoolean("allowCraftMelons"), this.melonsConfig.getBoolean("useEmpty"), this.melonsConfig.getBoolean("allowFullInventory"), this.melonsConfig.getBoolean("Notifications.Discord"), this.melonsConfig.getBoolean("Notifications.Logger"), this.melonsConfig.getBoolean("Notifications.Broadcast"), this.melonsConfig.getBoolean("Notifications.Player"));
        if (this.plugin.settings.luckPerms && this.plugin.settings.ranksEnabled) {
            this.ranks = new RankSettings(this.plugin);
        }
        Set discord = Objects.requireNonNull(this.webConfig.getConfigurationSection("Discord")).getKeys(false);
        for (String s : discord) {
            if (!this.plugin.settings.discordSRV) continue;
            this.discordInfo.put(s, this.webConfig.getString("Discord." + s));
        }
        this.webPort = this.webConfig.getInt("Port");
        this.webEnabled = this.webConfig.getBoolean("Enabled");
        this.bosses = new ArrayList(this.webConfig.getStringList("Bosses"));
        this.webExpirationKeyTime = this.webConfig.getInt("Expiration");
    }

    public void notifyDiscord(DiscordWebhook hook, boolean webhookEnabled, String webhookUser, String webhookImage, String message, Color color) {
        if (webhookEnabled && hook != null) {
            DiscordWebhook.EmbedObject embed = new DiscordWebhook.EmbedObject();
            embed.setAuthor(webhookUser, "", webhookImage);
            embed.setDescription(message);
            embed.setColor(color);
            hook.addEmbed(embed);
            try {
                hook.execute();
            }
            catch (IOException e) {
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
            }
        }
    }

    public void notifyDiscord(DiscordWebhook hook, boolean webhookEnabled, String webhookUser, String webhookImage, String message, String color) {
        if (hook != null) {
            if (color.equalsIgnoreCase("white")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.white);
            }
            if (color.equalsIgnoreCase("black")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.black);
            }
            if (color.equalsIgnoreCase("blue")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.blue);
            }
            if (color.equalsIgnoreCase("cyan")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.cyan);
            }
            if (color.equalsIgnoreCase("dark_gray")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.darkGray);
            }
            if (color.equalsIgnoreCase("gray")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.gray);
            }
            if (color.equalsIgnoreCase("green")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.green);
            }
            if (color.equalsIgnoreCase("light_gray")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.lightGray);
            }
            if (color.equalsIgnoreCase("magenta")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.magenta);
            }
            if (color.equalsIgnoreCase("orange")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.orange);
            }
            if (color.equalsIgnoreCase("pink")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.pink);
            }
            if (color.equalsIgnoreCase("red")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.red);
            }
            if (color.equalsIgnoreCase("yellow")) {
                this.notifyDiscord(hook, webhookEnabled, webhookUser, webhookImage, message, Color.yellow);
            }
        }
    }

    public Passive getPassive(String name) {
        for (Passive p : this.passives.values()) {
            if (!p.name().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public void loadConfig() {
        this.config = this.plugin.getConfig();
    }

    public void loadQuestsConfig() {
        File questsFile = new File(this.plugin.getDataFolder(), "quests.yml");
        if (!questsFile.exists()) {
            this.plugin.saveResource("quests.yml", false);
        }
        this.questsConfig = YamlConfiguration.loadConfiguration((File)questsFile);
    }

    public void loadPassivesConfig() {
        this.passivesFile = new File(this.plugin.getDataFolder(), "passives.yml");
        if (!this.passivesFile.exists()) {
            this.plugin.saveResource("passives.yml", false);
        }
        this.passivesConfig = YamlConfiguration.loadConfiguration((File)this.passivesFile);
    }

    public void loadWebConfig() {
        this.webFile = new File(this.plugin.getDataFolder(), "web.yml");
        if (!this.webFile.exists()) {
            this.plugin.saveResource("web.yml", false);
        }
        this.webConfig = YamlConfiguration.loadConfiguration((File)this.webFile);
    }

    public void loadMessagesConfig() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void loadItemsConfig() {
        this.itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        if (!this.itemsFile.exists()) {
            this.plugin.saveResource("items.yml", false);
        }
        this.itemsConfig = YamlConfiguration.loadConfiguration((File)this.itemsFile);
    }

    public void loadMelonsConfig() {
        this.melonsDir = new File(this.plugin.getDataFolder() + File.separator + "AutoMelons");
        this.melonsFile = new File(this.plugin.getDataFolder(), "AutoMelons" + File.separator + "config.yml");
        if (!this.melonsFile.exists()) {
            boolean created = this.melonsDir.mkdir();
            if (created) {
                this.plugin.getLogger().info("AutoMelons directory created...");
            }
            this.plugin.saveResource("AutoMelons" + File.separator + "config.yml", false);
        }
        this.melonsConfig = YamlConfiguration.loadConfiguration((File)this.melonsFile);
    }

    public void loadDiscordConfig() {
        this.discordFile = new File(this.plugin.getDataFolder(), "discord.yml");
        if (!this.discordFile.exists()) {
            this.plugin.saveResource("discord.yml", false);
        }
        this.discordConfig = YamlConfiguration.loadConfiguration((File)this.discordFile);
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.loadQuestsConfig();
        this.loadPassivesConfig();
        this.loadMessagesConfig();
        this.loadPassivesConfig();
        this.loadWebConfig();
        this.loadDiscordConfig();
        this.loadItemsConfig();
        this.loadFiles();
        this.plugin.settings.ems.loadConfig();
        this.plugin.settings.ems.loadFiles();
        this.ranks.reloadConfigs();
    }
}

