/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.SQLite;

import com.itsrainingplex.Crafting.PotionID;
import com.itsrainingplex.Crafting.SplashPotionID;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.SQLite.Database;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class SQLite
extends Database {
    private final RaindropQuests plugin;
    public String dbname;
    public StringBuilder counterTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + "counter" + " (`uuid` varchar(255) NOT NULL,");
    public StringBuilder potionTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + "potions" + " (  `uuid` varchar(255) NOT NULL,");
    public StringBuilder questsTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS quest_last (`uuid` varchar(255) NOT NULL,`player` varchar(255) NOT NULL,");
    public StringBuilder questsCompleteTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS quests_tally (`uuid` varchar(255) NOT NULL,`player` varchar(255) NOT NULL,");
    public StringBuilder randomTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS ").append("random").append(" (").append("enabled int(1) NOT NULL,").append("random int(9) NOT NULL,").append("last_run varchar(64) NOT NULL,");
    public StringBuilder mainTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS RaindropQuests (`uuid` varchar(255) NOT NULL,`player` varchar(255) NOT NULL,`currency` int(11) NOT NULL,`quests` int(11) NOT NULL,`wood_passive` int(1) NOT NULL,`iron_passive` int(1) NOT NULL,`gold_passive` int(1) NOT NULL,`diamond_passive` int(1) NOT NULL,`nether_passive` int(1) NOT NULL,`bonus_passive` int(1) NOT NULL,`potion_return` int(1) NOT NULL,`potion_extend` int(1) NOT NULL,`potion_strength` int(1) NOT NULL,`superheat` int(1) NOT NULL,`transmogrification` int(1) NOT NULL,`craftnethertools` int(1) NOT NULL,`craftnetherweapons` int(1) NOT NULL,`craftnetherarmor` int(1) NOT NULL,`condense` int(1) NOT NULL,`expedire` int(1) NOT NULL,`mixologist` int(1) NOT NULL,`transmutation` int(1) NOT NULL,`crystallize` int(1),`passive19` int(1),PRIMARY KEY (`uuid`));");
    public StringBuilder blockTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS block_data (`id` int(64) NOT NULL,`blockdata` varchar(1024) NOT NULL,PRIMARY KEY (`id`));");
    public StringBuilder passivesTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS passives (`uuid` varchar(255) NOT NULL,`player` varchar(255) NOT NULL,`wood_passive` varchar(255) NOT NULL,`iron_passive` varchar(255) NOT NULL,`gold_passive` varchar(255) NOT NULL,`diamond_passive` varchar(255) NOT NULL,`nether_passive` varchar(255) NOT NULL,`bonus_passive` varchar(255) NOT NULL,`potion_return` varchar(255) NOT NULL,`potion_extend` varchar(255) NOT NULL,`potion_strength` varchar(255) NOT NULL,`superheat` varchar(255) NOT NULL,`transmogrification` varchar(255) NOT NULL,`craftnethertools` varchar(255) NOT NULL,`craftnetherweapons` varchar(255) NOT NULL,`craftnetherarmor` varchar(255) NOT NULL,`condense` varchar(255) NOT NULL,`expedire` varchar(255) NOT NULL,`mixologist` varchar(255) NOT NULL,`transmutation` varchar(255) NOT NULL,`crystallize` varchar(255),`passive19` varchar(255),PRIMARY KEY (`uuid`));");

    public SQLite(RaindropQuests plugin) {
        super(plugin);
        this.plugin = plugin;
        this.dbname = plugin.getConfig().getString("SQLite.Filename", "RaindropQuests");
        for (int i = 0; i < plugin.settings.numberOfQuests - 1; ++i) {
            this.questsTableToken.append("`").append(plugin.settings.quests.get(i).getName()).append("` varchar(32) NOT NULL,");
            this.questsCompleteTableToken.append("`").append(plugin.settings.quests.get(i).getName()).append("` varchar(32) NOT NULL,");
            this.randomTableToken.append(plugin.settings.quests.get(i).getName()).append(" int(1) NOT NULL,");
        }
        this.questsTableToken.append("`").append(plugin.settings.quests.get(plugin.settings.numberOfQuests - 1).getName()).append("` varchar(32) NOT NULL,PRIMARY KEY (`uuid`));");
        this.questsCompleteTableToken.append("`").append(plugin.settings.quests.get(plugin.settings.numberOfQuests - 1).getName()).append("` varchar(32) NOT NULL,PRIMARY KEY (`uuid`));");
        this.randomTableToken.append(plugin.settings.quests.get(plugin.settings.numberOfQuests - 1).getName()).append(" varchar(32) NOT NULL, PRIMARY KEY (enabled));");
        for (String s : plugin.settings.allMobTypes) {
            this.counterTableToken.append(s).append(" int(7) NOT NULL,");
        }
        this.counterTableToken.append("PRIMARY KEY (uuid));");
        for (PotionID potionID : PotionID.values()) {
            this.potionTableToken.append(potionID.name()).append(" int(9) NOT NULL,");
        }
        for (Enum enum_ : SplashPotionID.values()) {
            this.potionTableToken.append(enum_.name()).append(" int(9) NOT NULL,");
        }
        this.potionTableToken.append("PRIMARY KEY (uuid));");
    }

    @Override
    public Connection getSQLConnection() {
        File dataFolder = new File(this.plugin.getDataFolder(), this.dbname + ".db");
        if (!dataFolder.exists()) {
            try {
                boolean created = dataFolder.createNewFile();
                if (this.plugin.settings.pm.getExtendedDebug() && created) {
                    this.plugin.getLogger().info("SQLite database file created");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "File write error: " + this.dbname + ".db");
            }
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dataFolder);
            return this.connection;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite exception on initialize", ex);
        }
        catch (ClassNotFoundException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "You need the SQLite JBDC library. Please contact the dev on discord!");
        }
        return null;
    }

    @Override
    public void load() {
        this.connection = this.getSQLConnection();
        try {
            Statement s = this.connection.createStatement();
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(this.mainTableToken.toString());
                this.plugin.getLogger().info(this.questsTableToken.toString());
                this.plugin.getLogger().info(this.questsCompleteTableToken.toString());
                this.plugin.getLogger().info(this.blockTableToken.toString());
                this.plugin.getLogger().info(this.passivesTableToken.toString());
                this.plugin.getLogger().info(this.counterTableToken.toString());
                this.plugin.getLogger().info(this.potionTableToken.toString());
                this.plugin.getLogger().info(this.randomTableToken.toString());
            }
            s.executeUpdate(this.mainTableToken.toString());
            s.executeUpdate(this.questsTableToken.toString());
            s.executeUpdate(this.questsCompleteTableToken.toString());
            s.executeUpdate(this.blockTableToken.toString());
            s.executeUpdate(this.passivesTableToken.toString());
            s.executeUpdate(this.counterTableToken.toString());
            s.executeUpdate(this.potionTableToken.toString());
            s.executeUpdate(this.randomTableToken.toString());
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.initialize();
    }
}

