/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.SQLite;

import com.itsrainingplex.Block.Block;
import com.itsrainingplex.Crafting.PotionID;
import com.itsrainingplex.Crafting.SplashPotionID;
import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.MySQL.SQLGetter;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.SQLite.Errors;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class Database
implements DBInterface {
    private final RaindropQuests plugin;
    public Connection connection;

    public Database(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public abstract Connection getSQLConnection();

    public abstract void load();

    public void initialize() {
        this.connection = this.getSQLConnection();
        try {
            PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM RaindropQuests WHERE uuid = ?");
            PreparedStatement ps2 = this.connection.prepareStatement("SELECT * FROM quests_tally WHERE uuid = ?");
            PreparedStatement ps3 = this.connection.prepareStatement("SELECT * FROM quest_last WHERE uuid = ?");
            PreparedStatement ps4 = this.connection.prepareStatement("SELECT * FROM block_data WHERE blockdata = ?");
            PreparedStatement ps5 = this.connection.prepareStatement("SELECT * FROM passives WHERE uuid = ?");
            PreparedStatement ps6 = this.connection.prepareStatement("SELECT * FROM counter WHERE uuid = ?");
            PreparedStatement ps7 = this.connection.prepareStatement("SELECT * FROM potions WHERE uuid = ?");
            PreparedStatement ps8 = this.connection.prepareStatement("SELECT * FROM random WHERE enabled = ?");
            ResultSet rs = ps.executeQuery();
            ResultSet rs2 = ps2.executeQuery();
            ResultSet rs3 = ps3.executeQuery();
            ResultSet rs4 = ps4.executeQuery();
            ResultSet rs5 = ps5.executeQuery();
            ResultSet rs6 = ps6.executeQuery();
            ResultSet rs7 = ps7.executeQuery();
            ResultSet rs8 = ps8.executeQuery();
            this.close(ps, rs);
            this.close(ps2, rs2);
            this.close(ps3, rs3);
            this.close(ps4, rs4);
            this.close(ps5, rs5);
            this.close(ps6, rs6);
            this.close(ps7, rs7);
            this.close(ps8, rs8);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void loadAllKillData() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM counter;");
            SQLGetter.runKillDataFromLoad(ps, this.plugin);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void dropColumn(String table, String column) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("ALTER TABLE " + table + " DROP COLUMN " + column);
            ps.executeQuery();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColumnName(String table, String oldColumn, String newColumn) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("ALTER TABLE " + table + " RENAME COLUMN " + oldColumn + " TO " + newColumn);
            ps.executeQuery();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    @Override
    public String[] getColumnNames(String table) {
        String[] columns;
        try {
            Connection conn = this.getSQLConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + table);
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData md = rs.getMetaData();
            int count = md.getColumnCount();
            columns = new String[count];
            for (int i = 1; i <= count; ++i) {
                columns[i - 1] = md.getColumnLabel(i);
            }
        }
        catch (SQLException ex) {
            columns = new String[]{};
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return columns;
    }

    @Override
    public void setPotionCount(String uuid, String potion, Integer amount) {
        this.setIntForPlayer("potions", uuid, potion, amount);
    }

    @Override
    public void setKillCount(String uuid, String mob, Integer amount) {
        this.setIntForPlayer("counter", uuid, mob, amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIntForPlayer(String table, String uuid, String potion, Integer amount) {
        if (amount == null) {
            return;
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE " + table + " SET " + potion + "=" + amount + " WHERE uuid=?");
            ps.setString(1, uuid);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + (PreparedStatement)ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringData(String uuid, String column, String data) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE passives SET " + column + "=" + data + " WHERE uuid=?");
            ps.setString(1, uuid);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + (PreparedStatement)ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getCurrency(String uuid) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM RaindropQuests WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                Integer n = rs.getInt("currency");
                return n;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPlayer(String uuid, String table) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getQuests(String uuid) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM RaindropQuests WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                Integer n = rs.getInt("quests");
                return n;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0;
    }

    @Override
    public String getQuestTime(String uuid, String quest) {
        return this.getQuest(uuid, quest, "quest_last");
    }

    @Override
    public String getQuestTally(String uuid, String quest) {
        return this.getQuest(uuid, quest, "quests_tally");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQuest(String uuid, String quest, String table) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                String string = rs.getString(quest);
                return string;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return "0";
    }

    @Override
    public ArrayList<String> getAllPlayers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Connection conn = this.getSQLConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT uuid FROM RaindropQuests");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("uuid"));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Block> getBlockData() {
        Connection conn = null;
        PreparedStatement ps = null;
        ArrayList<String> temp = new ArrayList<String>();
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM block_data;");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                temp.add(rs.getString("blockdata").replaceAll("\"\"", "\""));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return this.plugin.settings.blockHandler.loadBlockData(temp);
    }

    @Override
    public void setDateTable(Player player, String[] str) {
        this.setTable(player, str, "quest_last");
    }

    @Override
    public void setQuestsTable(Player player, String[] str) {
        this.setTable(player, str, "quests_tally");
    }

    @Override
    public void setPassivesTable(Player player, String[] str) {
        this.runPassiveSet(player, str, "passives");
    }

    @Override
    public String getPassiveTime(String uuid, String passive) {
        return this.getQuest(uuid, passive, "passives");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassive(@NotNull Player player, @NotNull String passive, Integer value) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE RaindropQuests set " + passive.toLowerCase() + "=" + value + " WHERE uuid=\"" + player.getUniqueId() + "\"");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrency(@NotNull Player player, Integer value) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE RaindropQuests set currency=" + value + " WHERE uuid=\"" + player.getUniqueId() + "\"");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    @Override
    public int getPotionCount(String uuid, String column) {
        return this.getIntFromTable(uuid, column, "potions");
    }

    @Override
    public int getKillCount(String uuid, String column) {
        return this.getIntFromTable(uuid, column, "counter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<String, Integer> getAllKills(String uuid) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        Connection conn = null;
        Statement ps = null;
        try {
            Object meta;
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM counter WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                meta = rs.getMetaData();
                int columns = meta.getColumnCount();
                ArrayList<String> mobs = new ArrayList<String>();
                for (int i = 1; i < columns; ++i) {
                    if (meta.getColumnName(i).equalsIgnoreCase("uuid")) continue;
                    mobs.add(meta.getColumnName(i));
                }
                for (String s : mobs) {
                    map.put(s, rs.getInt(s));
                }
            }
            meta = map;
            return meta;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIntFromTable(String uuid, String column, String table) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT " + column + " FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            int n = rs.getInt(column);
            return n;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlockData(ArrayList<String> data) {
        if (this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().info("Updating block data..");
        }
        for (int i = 0; i < data.size(); ++i) {
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(data.get(i));
            }
            Connection conn = null;
            PreparedStatement ps = null;
            String s = data.get(i);
            s = s.replaceAll("\"", "\"\"");
            try {
                conn = this.getSQLConnection();
                ps = conn.prepareStatement("REPLACE INTO block_data(id,blockdata) VALUES(?,?)");
                ps.setInt(1, i);
                ps.setString(2, s);
                if (this.plugin.settings.pm.getExtendedDebug()) {
                    this.plugin.getLogger().info("Running query: " + ps);
                }
                ps.executeUpdate();
                continue;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
                continue;
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
                }
            }
        }
        if (this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().info("Block data updated..");
        }
        this.messageBlockUpdate(data, this.plugin);
    }

    @Override
    public void messageBlockUpdate(ArrayList<String> data, @NotNull RaindropQuests plugin) {
        if (plugin.settings.pm.getExtendedDebug()) {
            plugin.getLogger().info(data.toString());
        }
        if (plugin.settings.pm.getDebug()) {
            if (data.size() < 2) {
                if (data.size() % 5 == 0) {
                    plugin.getLogger().info("Loaded approximately " + data.size() * 5 + " blocks  into " + data.size() + " rows");
                } else {
                    plugin.getLogger().info("Loaded approximately " + data.get(0).length() / 81 + " blocks  into " + data.size() + " rows");
                }
            } else {
                plugin.getLogger().info("Loaded approximately " + (data.size() * 5 + data.get(data.size() - 1).length() / 81) + " blocks  into " + data.size() + " rows");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getPassiveStatus(Player player, String passive) {
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info("Getting passive status for " + player.getName() + "...");
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT " + passive.toLowerCase() + " FROM RaindropQuests WHERE uuid =\"" + player.getUniqueId() + "\"");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            Integer n = rs.getInt(passive);
            return n;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTable(Player player, String[] str, String table) {
        if (this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().info("Updating data for " + player.getName() + "...");
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            String statement = "REPLACE INTO " + table + " (uuid,player,";
            ps = this.plugin.misc.getPreparedStatementQuest(conn, statement, this.plugin);
            this.setupStatement(player, str, (PreparedStatement)ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPassiveSet(Player player, String[] str, String table) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            String statement = "REPLACE INTO " + table + " (uuid,player,";
            ps = this.getPreparedStatementPassive(conn, statement, this.plugin);
            this.setupStatement(player, str, (PreparedStatement)ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    private void setupStatement(@NotNull Player player, String @NotNull [] str, @NotNull PreparedStatement ps) throws SQLException {
        ps.setString(1, player.getUniqueId().toString());
        ps.setString(2, player.getName().toLowerCase());
        for (int i = 3; i < str.length + 3; ++i) {
            ps.setString(i, str[i - 3]);
        }
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info("Running query: " + ps);
        }
        ps.executeUpdate();
    }

    private PreparedStatement getPreparedStatementPassive(Connection conn, String statement, @NotNull RaindropQuests plugin) throws SQLException {
        StringBuilder statementBuilder = new StringBuilder((String)statement);
        for (String st : plugin.settings.passiveNames) {
            statementBuilder.append(st).append(",");
        }
        statement = statementBuilder.toString();
        statement = ((String)statement).substring(0, ((String)statement).length() - 1);
        statement = (String)statement + ") VALUES(?,?,";
        statement = (String)statement + "?,".repeat(plugin.settings.passiveNames.size());
        statement = ((String)statement).substring(0, ((String)statement).length() - 1);
        statement = (String)statement + ")";
        PreparedStatement ps = conn.prepareStatement((String)statement);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlayerToPotionsTable(Player player) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO potions (uuid,");
            for (PotionID potionID : PotionID.values()) {
                statement.append(potionID.name()).append(",");
            }
            for (Enum enum_ : SplashPotionID.values()) {
                statement.append(enum_.name()).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(\"").append(player.getUniqueId()).append("\",");
            statement.append("0,".repeat(PotionID.values().length));
            statement.append("0,".repeat(SplashPotionID.values().length));
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean randomEnabled() {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT enabled FROM random");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            if ((rs = ps.executeQuery()).next()) {
                if (rs.getInt("enabled") == 1) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQuestRefreshTime() {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT last_run FROM random");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            if ((rs = ps.executeQuery()).next()) {
                String string = rs.getString("last_run");
                return string;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkQuestRandomList(String quest) {
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT " + quest + " FROM random");
            rs = ps.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(quest);
                return n;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRandomTable(int enabled, int random, String date, String[] quests) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO random (enabled,random,last_run,");
            for (int i = 0; i < this.plugin.settings.numberOfQuests; ++i) {
                statement.append(this.plugin.settings.quests.get(i).getName()).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(").append(enabled).append(",").append(random).append(",").append(date).append(",");
            for (String s : quests) {
                statement.append(s).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRandomTable() {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            StringBuilder statement = new StringBuilder("SELECT * FROM ").append("random");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            ps = conn.prepareStatement(statement.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getInt("enabled") != 1) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlayerToCounterTable(Player player) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO counter (uuid,");
            for (String s : this.plugin.settings.allMobTypes) {
                statement.append(s).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(\"").append(player.getUniqueId()).append("\",");
            statement.append("0,".repeat(this.plugin.settings.allMobTypes.size()));
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMainTable(Player player, Integer currency, Integer quests, Integer wood_passive, Integer iron_passive, Integer gold_passive, Integer diamond_passive, Integer nether_passive, Integer bonus_passive, Integer potion_return, Integer potion_extend, Integer potion_strength, Integer superheat, Integer transmog, Integer CraftNetherTools, Integer CraftNetherWeapons, Integer CraftNetherArmor, Integer condense, Integer expedire, Integer mixologist, Integer transmutation, Integer crystallize, Integer passive19) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("REPLACE INTO RaindropQuests (uuid,player,currency,quests,wood_passive,iron_passive,gold_passive,diamond_passive,nether_passive,bonus_passive,potion_return,potion_extend,potion_strength,superheat,transmogrification,craftnethertools,craftnetherweapons,craftnetherarmor,condense,expedire,mixologist,transmutation,crystallize,passive19) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            this.plugin.misc.setupPreparedStatement(player, currency, quests, wood_passive, iron_passive, gold_passive, diamond_passive, nether_passive, bonus_passive, potion_return, potion_extend, potion_strength, superheat, transmog, CraftNetherTools, CraftNetherWeapons, CraftNetherArmor, condense, expedire, mixologist, transmutation, crystallize, passive19, ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    public void close(PreparedStatement ps, ResultSet rs) {
        try {
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe(ex.toString());
        }
    }

    @Override
    public String toString() {
        return "This is a Database class object";
    }
}

