/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Ranks;

import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class Rank
implements Comparable<Rank> {
    public String rankName;
    public String luckPermGroup;
    public String prefix;
    public String suffix;
    public String rankID;
    public String material;
    public List<String> requiredRank;
    public List<String> mcMMO;
    public List<String> path;
    public List<String> cost;
    public List<String> jobsReborn;
    public List<String> kills;
    public List<String> commands;
    public TreeMap<String, Integer> jobsMap = new TreeMap();
    public TreeMap<String, Integer> killsMap = new TreeMap();
    public TreeMap<String, Integer> costMap = new TreeMap();
    public TreeMap<String, Integer> mcMMOMap = new TreeMap();
    public TreeMap<String, Integer> craftingMap = new TreeMap();
    public List<String> pathNames;
    public List<String> requiredRankNames;
    public int weight;
    public int tier;

    public Rank(String rankName, String material, String rankID, List<String> requiredRank, List<String> mcMMO, List<String> jobsReborn, List<String> kills, List<String> craftingList, List<String> path, String luckPermGroup, String prefix, String suffix, List<String> cost, int weight, int tier, List<String> commands) {
        this.rankName = rankName;
        this.material = material.toUpperCase();
        this.rankID = rankID;
        this.requiredRank = requiredRank;
        this.mcMMO = mcMMO;
        this.jobsReborn = jobsReborn;
        this.kills = kills;
        this.path = path;
        this.luckPermGroup = luckPermGroup;
        this.prefix = prefix;
        this.suffix = suffix;
        this.cost = cost;
        this.weight = weight;
        this.tier = tier;
        this.commands = commands;
        if (weight != -1) {
            String[] s;
            for (String str : craftingList) {
                s = str.split(":");
                s = new String[]{s[0].toLowerCase() + ":" + s[1].toLowerCase(), s[2].toLowerCase()};
                this.craftingMap.put("minecraft:" + s[0], Integer.valueOf(s[1]));
            }
            for (String str : cost) {
                if (str.contains("{")) {
                    s = str.split(":");
                    s = new String[]{s[0].toLowerCase() + ":" + s[1].toLowerCase(), s[2].toLowerCase()};
                } else {
                    s = str.split(":");
                }
                if (s[0].equalsIgnoreCase("JobsReborn")) {
                    this.costMap.put(s[0].toLowerCase() + ":" + s[1].toLowerCase(), Integer.valueOf(s[2]));
                    continue;
                }
                if (s[0].equalsIgnoreCase("mcMMO")) {
                    this.costMap.put(s[0].toLowerCase() + ":" + s[1].toLowerCase(), Integer.valueOf(s[2]));
                    continue;
                }
                if (s[0].equalsIgnoreCase("MC")) {
                    this.costMap.put(s[0].toLowerCase() + ":" + s[1].toLowerCase(), Integer.valueOf(s[2]));
                    continue;
                }
                this.costMap.put(s[0].toLowerCase(), Integer.valueOf(s[1]));
            }
            for (String str : mcMMO) {
                s = str.split(":");
                this.mcMMOMap.put(s[0].toLowerCase(), Integer.valueOf(s[1]));
            }
            for (String str : jobsReborn) {
                s = str.split(":");
                this.jobsMap.put(s[0].toLowerCase(), Integer.valueOf(s[1]));
            }
            for (String str : kills) {
                s = str.split(":");
                if (s[0].equalsIgnoreCase("PVP")) {
                    this.killsMap.put("PlayerKills".toLowerCase(), Integer.valueOf(s[1]));
                    continue;
                }
                this.killsMap.put(s[1].toLowerCase(), Integer.valueOf(s[2]));
            }
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.rankName + "\n" + this.requiredRank.toString() + "\n" + this.mcMMO.toString() + "\n" + this.jobsReborn.toString() + "\n" + this.path.toString() + "\n" + this.luckPermGroup + "\n" + this.cost.toString() + "\n" + this.weight + "\n" + this.tier;
    }

    @Override
    public int compareTo(@NotNull Rank o) {
        Integer i = o.weight;
        Integer j = this.weight;
        return j.compareTo(i);
    }
}

