/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Quests;

import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.Quests.QuestItem;
import com.itsrainingplex.RaindropQuests;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class RandomQuestsRunnable {
    private final RaindropQuests plugin;

    public RandomQuestsRunnable(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.plugin.settings.random) {
            if (this.plugin.settings.pm.getDebug()) {
                this.plugin.getLogger().info("Random quests enabled! Selecting quests and starting cool down...");
            }
            Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
                if (this.plugin.settings.master) {
                    if (!db.checkRandomTable()) {
                        db.updateRandomTable(1, this.plugin.settings.availableQuests, String.valueOf(System.currentTimeMillis()), this.selectNewQuests());
                        BaseComponent[] component = new ComponentBuilder("Quests have updated!").color(ChatColor.RED).create();
                        this.plugin.getServer().spigot().broadcast(component);
                    } else if (!db.getQuestRefreshTime().equals("")) {
                        if ((long)this.plugin.settings.randomQuestCoolDown * 1000L < System.currentTimeMillis() - Long.parseLong(db.getQuestRefreshTime())) {
                            db.updateRandomTable(1, this.plugin.settings.availableQuests, String.valueOf(System.currentTimeMillis()), this.selectNewQuests());
                            BaseComponent[] component = new ComponentBuilder("Quests have updated!").color(ChatColor.RED).create();
                            this.plugin.getServer().spigot().broadcast(component);
                        }
                    } else {
                        ArrayList<QuestItem> list = new ArrayList<QuestItem>();
                        for (QuestItem qi : this.plugin.settings.questsMap.values()) {
                            if (db.checkQuestRandomList(qi.quest.getName()) != 1) continue;
                            list.add(qi);
                        }
                        this.plugin.settings.randomQuests = list;
                    }
                } else {
                    ArrayList<QuestItem> list = new ArrayList<QuestItem>();
                    for (QuestItem qi : this.plugin.settings.questsMap.values()) {
                        if (db.checkQuestRandomList(qi.quest.getName()) != 1) continue;
                        list.add(qi);
                    }
                    this.plugin.settings.randomQuests = list;
                }
            }, 0L, 6000L);
        }
    }

    private String[] selectNewQuests() {
        Object[] quests = new String[this.plugin.settings.numberOfQuests];
        Arrays.fill(quests, "0");
        Collection<QuestItem> questGUIItems = this.plugin.settings.questsMap.values();
        ArrayList<QuestItem> questItems = new ArrayList<QuestItem>(questGUIItems);
        ArrayList<QuestItem> temp = new ArrayList<QuestItem>();
        if (this.plugin.settings.availableQuests < this.plugin.settings.questsMap.values().size()) {
            Random rand = new Random();
            for (int i = 0; i < this.plugin.settings.availableQuests; ++i) {
                QuestItem qi = (QuestItem)questItems.get(rand.nextInt(questItems.size()));
                quests[qi.quest.getId()] = "1";
                temp.add(qi);
                questItems.remove(qi);
            }
            this.plugin.settings.randomQuests = temp;
        } else {
            this.plugin.getLogger().warning("Number of available quests in config is lower than total quests created in quests.yml. Lower Quests.Available value or disable Quests.Random in config.yml");
        }
        this.plugin.getLogger().info(Arrays.toString(quests));
        return quests;
    }
}

