/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.NanoHTTPD;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.itsrainingplex.Crafting.PotionID;
import com.itsrainingplex.Crafting.SplashPotionID;
import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.Rank;
import github.scarsz.discordsrv.DiscordSRV;
import io.lumine.mythic.bukkit.utils.lib.lang3.text.WordUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.NanoHTTPD;
import org.nanohttpd.protocols.http.content.CookieHandler;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;

public class WebHandler {
    private final RaindropQuests plugin;

    public WebHandler(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public Response getUUID() {
        return Response.newFixedLengthResponse(UUID.randomUUID().toString());
    }

    public Response setDiscordData(@NotNull IHTTPSession session, HashMap<UUID, String> sessions, HashMap<UUID, HashMap<String, String>> users, HashMap<UUID, Date> expiration) {
        HashMap<String, String> content = new HashMap<String, String>();
        try {
            session.parseBody(content);
            if (content.containsKey("postData")) {
                String discordData = content.get("postData");
                JsonObject json = (JsonObject)new Gson().fromJson(discordData, JsonObject.class);
                UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(json.get("id").getAsString());
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                CookieHandler ch = new CookieHandler(session.getHeaders());
                ch.set("RaindropQuests", json.get("session").getAsString(), 30);
                sessions.put(player.getUniqueId(), json.get("session").getAsString());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", json.get("id").getAsString());
                map.put("username", json.get("username").getAsString());
                map.put("discriminator", json.get("discriminator").getAsString());
                map.put("avatar", json.get("avatar").getAsString());
                users.put(player.getUniqueId(), map);
                expiration.put(player.getUniqueId(), new Date());
                Response response = Response.newFixedLengthResponse("Discord data received");
                ch.unloadQueue(response);
                return response;
            }
        }
        catch (IOException | NanoHTTPD.ResponseException e) {
            throw new RuntimeException(e);
        }
        return Response.newFixedLengthResponse("Not a player");
    }

    private boolean checkDate(Date givenDate) {
        long currentMillis = new Date().getTime();
        long millisIn30Days = (long)this.plugin.settings.webExpirationKeyTime * 24L * 60L * 60L * 1000L;
        return givenDate.getTime() > currentMillis - millisIn30Days;
    }

    public Response getAvatar(@NotNull IHTTPSession session, HashMap<UUID, String> sessions, HashMap<UUID, HashMap<String, String>> users) {
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                Gson gson = new Gson();
                return Response.newFixedLengthResponse(gson.toJson(users.get(uuid)));
            }
        }
        return Response.newFixedLengthResponse("Not a player");
    }

    public Response getPlayerKills(@NotNull IHTTPSession session, HashMap<UUID, String> sessions) {
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
                TreeMap<String, Integer> map = db.getAllKills(uuid.toString());
                Gson gson = new Gson();
                return Response.newFixedLengthResponse(gson.toJson(map));
            }
        }
        return Response.newFixedLengthResponse("Not a player");
    }

    public Response getBosses() {
        Gson gson = new Gson();
        return Response.newFixedLengthResponse(gson.toJson(this.plugin.settings.bosses));
    }

    public Response getPlayerData(@NotNull IHTTPSession session, HashMap<UUID, String> sessions) {
        Rank highestRank = null;
        ArrayList<Rank> playerRanks = new ArrayList<Rank>();
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                for (String s : this.plugin.settings.ranks.lpm.getPlayerGroups(player)) {
                    if (s.equalsIgnoreCase("default")) continue;
                    playerRanks.add(this.plugin.settings.ranks.ranks.get(s));
                }
                for (Rank rank : playerRanks) {
                    if (highestRank == null) {
                        highestRank = rank;
                        continue;
                    }
                    if (highestRank.weight >= rank.weight) continue;
                    highestRank = rank;
                }
                Collections.sort(playerRanks);
                TreeMap<String, String> playerData = new TreeMap<String, String>();
                playerData.put("name", player.getName());
                playerData.put("uuid", player.getUniqueId().toString());
                if (player instanceof Player) {
                    Player online = player.getPlayer();
                    assert (online != null);
                    playerData.put("address", Objects.requireNonNull(online.getAddress()).toString());
                } else {
                    playerData.put("address", "Offline");
                }
                if (highestRank == null) {
                    playerData.put("highest", "Not Yet Ranked Up!");
                } else {
                    playerData.put("highest", highestRank.rankName);
                }
                Gson gson = new Gson();
                return Response.newFixedLengthResponse(gson.toJson(playerData));
            }
        }
        return Response.newFixedLengthResponse("Not a player");
    }

    public Response getAuthURL() {
        return Response.newFixedLengthResponse(this.plugin.settings.discordInfo.get("OAuth_URL"));
    }

    /*
     * WARNING - void declaration
     */
    public Response getRank(@NotNull IHTTPSession session) {
        if (session.getParameters().containsKey("rank")) {
            Gson gson = new Gson();
            Rank rank = this.plugin.settings.ranks.ranks.get(session.getParameters().get("rank").toString().replaceAll("\\[", "").replaceAll("\\]", ""));
            TreeMap<String, Integer> map = rank.craftingMap;
            TreeMap<String, Integer> friendly = new TreeMap<String, Integer>();
            for (String string : map.keySet()) {
                void var7_7;
                if (!string.startsWith("minecraft:")) {
                    String string2 = "minecraft:" + string;
                }
                if (var7_7.contains("splash")) {
                    friendly.put(WordUtils.capitalizeFully((String)SplashPotionID.getNameByValue((String)var7_7).replaceAll("_", " ")), map.get(var7_7));
                    continue;
                }
                friendly.put(WordUtils.capitalizeFully((String)PotionID.getNameByValue((String)var7_7).replaceAll("_", " ")), map.get(var7_7));
            }
            rank.material = rank.material.toUpperCase();
            rank.craftingMap = friendly;
            return Response.newFixedLengthResponse(gson.toJson((Object)rank));
        }
        return Response.newFixedLengthResponse("Rank not found");
    }

    public Response removeSession(@NotNull IHTTPSession session, HashMap<UUID, String> sessions, HashMap<UUID, HashMap<String, String>> users, HashMap<UUID, Date> expiration) {
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                sessions.remove(uuid);
                users.remove(uuid);
                expiration.remove(uuid);
            }
        }
        return Response.newFixedLengthResponse("Logged out");
    }

    public Response getPlayerRanks(@NotNull IHTTPSession session, HashMap<UUID, String> sessions) {
        Rank highestRank = null;
        ArrayList<Rank> playerRanks = new ArrayList<Rank>();
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                for (String s : this.plugin.settings.ranks.lpm.getPlayerGroups(player)) {
                    if (s.equalsIgnoreCase("default")) continue;
                    playerRanks.add(this.plugin.settings.ranks.ranks.get(s));
                }
                for (Rank rank : playerRanks) {
                    if (highestRank == null) {
                        highestRank = rank;
                        continue;
                    }
                    if (highestRank.weight >= rank.weight) continue;
                    highestRank = rank;
                }
                Collections.sort(playerRanks);
                Gson gson = new Gson();
                for (Rank r : playerRanks) {
                    for (String s : r.cost) {
                        if (s.contains("splash")) {
                            r.cost.set(r.cost.indexOf(s), SplashPotionID.valueOf(SplashPotionID.getNameByValue("minecraft:" + s.substring(0, s.length() - 2))).getFriendlyName());
                        }
                        r.material = r.material.toLowerCase();
                    }
                }
                return Response.newFixedLengthResponse(gson.toJson(playerRanks));
            }
        }
        return Response.newFixedLengthResponse("Not a player");
    }

    public Response getPlayerPermissions(@NotNull IHTTPSession session, HashMap<UUID, String> sessions) {
        if (session.getUri().toLowerCase().startsWith("/api/player/permissions") && session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                Gson gson = new Gson();
                String string = gson.toJson(this.plugin.settings.ranks.lpm.getPermissions(player));
                return Response.newFixedLengthResponse(string);
            }
        }
        return Response.newFixedLengthResponse("Not a player");
    }

    public Response getDiscordBotInfo() {
        Gson gson = new Gson();
        return Response.newFixedLengthResponse(gson.toJson(this.plugin.settings.discordInfo));
    }

    public Response getEconomySymbol() {
        return Response.newFixedLengthResponse(this.plugin.settings.economyVaultSymbol);
    }

    public Response checkValidSession(@NotNull IHTTPSession session, HashMap<UUID, String> sessions, HashMap<UUID, Date> expiration) {
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase()) || !this.checkDate(expiration.get(uuid))) continue;
                return Response.newFixedLengthResponse("Valid");
            }
        }
        return Response.newFixedLengthResponse("Invalid");
    }

    public Response getQuests(@NotNull IHTTPSession session, HashMap<UUID, String> sessions) {
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                Gson gson = new Gson();
                return Response.newFixedLengthResponse(gson.toJson(this.plugin.settings.quests));
            }
        }
        return Response.newFixedLengthResponse("Player not found");
    }

    public Response getPlaceholder(@NotNull IHTTPSession session, HashMap<UUID, String> sessions) {
        HashMap<String, String> content = new HashMap<String, String>();
        try {
            session.parseBody(content);
            String placeholderData = content.get("postData");
            JsonObject json = (JsonObject)new Gson().fromJson(placeholderData, JsonObject.class);
            for (UUID uuid : sessions.keySet()) {
                if (!sessions.get(uuid).equalsIgnoreCase(json.get("session").toString().substring(1, json.get("session").toString().length() - 1))) continue;
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                return Response.newFixedLengthResponse(PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)json.get("placeholder").toString().substring(1, json.get("placeholder").toString().length() - 1)));
            }
        }
        catch (IOException | NanoHTTPD.ResponseException e) {
            throw new RuntimeException(e);
        }
        return Response.newFixedLengthResponse("Player not found");
    }

    public Response checkOperatorStatus(@NotNull IHTTPSession session, HashMap<UUID, String> sessions) {
        if (session.getParameters().containsKey("session")) {
            for (UUID uuid : sessions.keySet()) {
                if (!session.getParameters().get("session").toString().replaceAll("\\[", "").replaceAll("\\]", "").equalsIgnoreCase(sessions.get(uuid).toLowerCase())) continue;
                return Response.newFixedLengthResponse(String.valueOf(Bukkit.getOfflinePlayer((UUID)uuid).isOp()));
            }
        }
        return Response.newFixedLengthResponse("Player not found");
    }

    public Response getRanksTree() {
        ArrayList<Rank> ranks = new ArrayList<Rank>(this.plugin.settings.ranks.ranks.values());
        Collections.sort(ranks);
        Gson gson = new Gson();
        return Response.newFixedLengthResponse(gson.toJson(ranks));
    }

    public boolean isRankPage(@NotNull IHTTPSession session) {
        if (this.plugin.settings.ranks != null) {
            for (Rank rank : this.plugin.settings.ranks.ranks.values()) {
                if (!session.getUri().equalsIgnoreCase("/" + rank.rankID + ".html")) continue;
                return true;
            }
        }
        return false;
    }

    public Response getFavIcon() {
        InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www/logo.png");
        return Response.newChunkedResponse(Status.OK, "image/png", in);
    }

    public Response getReactFiles(@NotNull IHTTPSession session) {
        if (session.getUri().contains(".js")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "application/javascript", in);
        }
        if (session.getUri().contains(".html")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "text/html", in);
        }
        if (session.getUri().contains(".css")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "text/css", in);
        }
        if (session.getUri().contains(".jpg")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "image/jpeg", in);
        }
        if (session.getUri().contains(".png")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "image/png", in);
        }
        if (session.getUri().contains(".jsx")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "text/babel", in);
        }
        if (session.getUri().contains(".svg")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "image/svg+xml", in);
        }
        if (session.getUri().contains(".ico")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "image/x-icon", in);
        }
        if (session.getUri().contains(".json")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "application/json", in);
        }
        InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www/react/index.html");
        return Response.newChunkedResponse(Status.OK, "text/html", in);
    }

    public Response getStaticFiles(@NotNull IHTTPSession session) {
        if (session.getUri().contains(".js")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "application/javascript", in);
        }
        if (session.getUri().contains(".html")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www/html" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "text/html", in);
        }
        if (session.getUri().contains(".css")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "text/css", in);
        }
        if (session.getUri().contains(".jpg")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "image/jpeg", in);
        }
        if (session.getUri().contains(".png")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "image/png", in);
        }
        if (session.getUri().contains(".jsx")) {
            InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www" + session.getUri());
            return Response.newChunkedResponse(Status.OK, "text/babel", in);
        }
        InputStream in = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/www/html/index.html");
        return Response.newChunkedResponse(Status.OK, "text/html", in);
    }
}

