/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.NanoHTTPD;

import com.itsrainingplex.NanoHTTPD.WebHandler;
import com.itsrainingplex.RaindropQuests;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.NanoHTTPD;
import org.nanohttpd.protocols.http.response.Response;

public class App
extends NanoHTTPD {
    private final RaindropQuests plugin;
    private final HashMap<UUID, String> sessions = new HashMap();
    private final HashMap<UUID, Date> expiration = new HashMap();
    private final HashMap<UUID, HashMap<String, String>> users = new HashMap();
    private final WebHandler webHandler;

    public App(RaindropQuests plugin, int port) throws IOException {
        super(port);
        this.plugin = plugin;
        this.webHandler = new WebHandler(plugin);
        this.start(5000, false);
    }

    @Override
    public Response serve(@NotNull IHTTPSession session) {
        String url = session.getUri();
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf(63));
        }
        if (this.webHandler.isRankPage(session)) {
            return Response.newFixedLengthResponse(this.plugin.settings.rankHTML.getRankPage(session.getUri().substring(1, session.getUri().length() - 5)));
        }
        switch (url) {
            case "/api/auth/url": {
                return this.webHandler.getAuthURL();
            }
            case "/api/auth/remove": {
                return this.webHandler.removeSession(session, this.sessions, this.users, this.expiration);
            }
            case "/api/auth/discord": {
                return this.webHandler.getDiscordBotInfo();
            }
            case "/api/auth/session/": {
                return this.webHandler.checkValidSession(session, this.sessions, this.expiration);
            }
            case "/api/player/discord": {
                return this.webHandler.setDiscordData(session, this.sessions, this.users, this.expiration);
            }
            case "/api/player/ranks/": {
                return this.webHandler.getPlayerRanks(session, this.sessions);
            }
            case "/api/player/permissions/": {
                return this.webHandler.getPlayerPermissions(session, this.sessions);
            }
            case "/api/player/avatar/": {
                return this.webHandler.getAvatar(session, this.sessions, this.users);
            }
            case "/api/player/data/": {
                return this.webHandler.getPlayerData(session, this.sessions);
            }
            case "/api/player/op/": {
                return this.webHandler.checkOperatorStatus(session, this.sessions);
            }
            case "/api/player/uuid": {
                return this.webHandler.getUUID();
            }
            case "/api/player/kills/": {
                return this.webHandler.getPlayerKills(session, this.sessions);
            }
            case "/api/quests/info/": {
                return this.webHandler.getQuests(session, this.sessions);
            }
            case "/api/bosses/info": {
                return this.webHandler.getBosses();
            }
            case "/api/rank/info/": {
                return this.webHandler.getRank(session);
            }
            case "/api/tree/info": {
                return this.webHandler.getRanksTree();
            }
            case "/api/placeholder/run": {
                return this.webHandler.getPlaceholder(session, this.sessions);
            }
            case "/favicon.ico": {
                return this.webHandler.getFavIcon();
            }
            case "/plugin/economy/symbol": {
                return this.webHandler.getEconomySymbol();
            }
        }
        return this.webHandler.getStaticFiles(session);
    }
}

