/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.MySQL;

import com.itsrainingplex.Block.Block;
import com.itsrainingplex.Counters.KillCount;
import com.itsrainingplex.Crafting.PotionID;
import com.itsrainingplex.Crafting.SplashPotionID;
import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.SQLite.Errors;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SQLGetter
implements DBInterface {
    private final RaindropQuests plugin;
    private final String main;
    private final String questLastTable;
    private final String questTallyTable;
    private final String blockData;
    private final String passiveTable;
    private final String counterTable;
    private final String randomTable;
    private final String potionTable;

    public SQLGetter(@NotNull RaindropQuests plugin) {
        this.plugin = plugin;
        this.main = plugin.settings.mysql.get("main_table");
        this.questTallyTable = plugin.settings.mysql.get("quests_table");
        this.questLastTable = plugin.settings.mysql.get("date_table");
        this.blockData = plugin.settings.mysql.get("blocks_table");
        this.passiveTable = plugin.settings.mysql.get("passives_table");
        this.counterTable = plugin.settings.mysql.get("counter_table");
        this.randomTable = plugin.settings.mysql.get("random_table");
        this.potionTable = plugin.settings.mysql.get("potions_table");
    }

    public void createTable() {
        String tokensMainTable = "CREATE TABLE IF NOT EXISTS " + this.main + "(uuid VARCHAR(255) NOT NULL,player VARCHAR(255) NOT NULL,currency int NOT NULL,quests int NOT NULL,wood_passive int NOT NULL,iron_passive int NOT NULL,gold_passive int NOT NULL,diamond_passive int NOT NULL,nether_passive int NOT NULL,bonus_passive int NOT NULL,potion_return int NOT NULL,potion_extend int NOT NULL,potion_strength int NOT NULL,superheat int NOT NULL,transmogrification int NOT NULL,craftnethertools int NOT NULL,craftnetherweapons int NOT NULL,craftnetherarmor int NOT NULL,condense int NOT NULL,expedire int NOT NULL,mixologist int NOT NULL,transmutation int NOT NULL,crystallize int NOT NULL,passive19 int NOT NULL,PRIMARY KEY (uuid));";
        String tokensPassivesTable = "CREATE TABLE IF NOT EXISTS " + this.passiveTable + "(uuid VARCHAR(255) NOT NULL,player VARCHAR(255) NOT NULL,wood_passive VARCHAR(255) NOT NULL,iron_passive VARCHAR(255) NOT NULL,gold_passive VARCHAR(255) NOT NULL,diamond_passive VARCHAR(255) NOT NULL,nether_passive VARCHAR(255) NOT NULL,bonus_passive VARCHAR(255) NOT NULL,potion_return VARCHAR(255) NOT NULL,potion_extend VARCHAR(255) NOT NULL,potion_strength VARCHAR(255) NOT NULL,superheat VARCHAR(255) NOT NULL,transmogrification VARCHAR(255) NOT NULL,craftnethertools VARCHAR(255) NOT NULL,craftnetherweapons VARCHAR(255) NOT NULL,craftnetherarmor VARCHAR(255) NOT NULL,condense VARCHAR(255) NOT NULL,expedire VARCHAR(255) NOT NULL,mixologist VARCHAR(255) NOT NULL,transmutation VARCHAR(255) NOT NULL,crystallize VARCHAR(255),passive19 VARCHAR(255),PRIMARY KEY (uuid));";
        StringBuilder tokensQuestsTable = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.questTallyTable + " (uuid VARCHAR(255) NOT NULL,player varchar(32) NOT NULL,");
        StringBuilder tokensDateTable = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.questLastTable + " (uuid VARCHAR(255) NOT NULL,player varchar(32) NOT NULL,");
        StringBuilder tokensRandomTable = new StringBuilder("CREATE TABLE IF NOT EXISTS ").append(this.randomTable).append(" (").append("enabled int(1) NOT NULL,").append("random int(9) NOT NULL,").append("last_run varchar(64) NOT NULL,");
        for (int i = 0; i < this.plugin.settings.numberOfQuests - 1; ++i) {
            tokensQuestsTable.append(this.plugin.settings.quests.get(i).getName()).append(" varchar(32) NOT NULL,");
            tokensDateTable.append(this.plugin.settings.quests.get(i).getName()).append(" varchar(32) NOT NULL,");
            tokensRandomTable.append(this.plugin.settings.quests.get(i).getName()).append(" int(1) NOT NULL,");
        }
        tokensQuestsTable.append(this.plugin.settings.quests.get(this.plugin.settings.numberOfQuests - 1).getName()).append(" varchar(32) NOT NULL,PRIMARY KEY (uuid));");
        tokensDateTable.append(this.plugin.settings.quests.get(this.plugin.settings.numberOfQuests - 1).getName()).append(" varchar(32) NOT NULL,PRIMARY KEY (uuid));");
        tokensRandomTable.append(this.plugin.settings.quests.get(this.plugin.settings.numberOfQuests - 1).getName()).append(" varchar(32) NOT NULL, PRIMARY KEY (enabled));");
        String tokensBlockData = "CREATE TABLE IF NOT EXISTS " + this.blockData + " (id int NOT NULL,blockdata varchar(1024) NOT NULL, PRIMARY KEY (id));";
        StringBuilder counterData = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.counterTable + " (uuid varchar(255) NOT NULL,");
        for (String string : this.plugin.settings.allMobTypes) {
            counterData.append(string).append(" int(7),");
        }
        counterData.append("PRIMARY KEY (uuid));");
        StringBuilder tokensPotionTable = new StringBuilder("CREATE TABLE IF NOT EXISTS ").append(this.potionTable).append(" (").append("`uuid` varchar(255) NOT NULL,");
        for (PotionID potionID : PotionID.values()) {
            tokensPotionTable.append(potionID.name()).append(" int(9) NOT NULL,");
        }
        for (SplashPotionID splashPotionID : SplashPotionID.values()) {
            tokensPotionTable.append(splashPotionID.name()).append(" int(9) NOT NULL,");
        }
        tokensPotionTable.append("PRIMARY KEY (uuid));");
        try (PreparedStatement preparedStatement = this.plugin.settings.sql.getConnection().prepareStatement(tokensMainTable);
             PreparedStatement ps2 = this.plugin.settings.sql.getConnection().prepareStatement(tokensQuestsTable.toString());
             PreparedStatement ps3 = this.plugin.settings.sql.getConnection().prepareStatement(tokensDateTable.toString());
             PreparedStatement preparedStatement2 = this.plugin.settings.sql.getConnection().prepareStatement(tokensBlockData);
             PreparedStatement ps5 = this.plugin.settings.sql.getConnection().prepareStatement(tokensPassivesTable);
             PreparedStatement ps6 = this.plugin.settings.sql.getConnection().prepareStatement(counterData.toString());
             PreparedStatement ps7 = this.plugin.settings.sql.getConnection().prepareStatement(tokensPotionTable.toString());
             PreparedStatement ps8 = this.plugin.settings.sql.getConnection().prepareStatement(tokensRandomTable.toString());){
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + preparedStatement.toString());
                this.plugin.getLogger().info("Running query: " + ps2.toString());
                this.plugin.getLogger().info("Running query: " + ps3.toString());
                this.plugin.getLogger().info("Running query: " + preparedStatement2.toString());
                this.plugin.getLogger().info("Running query: " + ps5.toString());
                this.plugin.getLogger().info("Running query: " + ps6.toString());
                this.plugin.getLogger().info("Running query: " + ps7.toString());
                this.plugin.getLogger().info("Running query: " + ps8.toString());
            }
            preparedStatement.executeUpdate();
            ps2.executeUpdate();
            ps3.executeUpdate();
            preparedStatement2.executeUpdate();
            ps5.executeUpdate();
            ps6.executeUpdate();
            ps7.executeUpdate();
            ps8.executeUpdate();
        }
        catch (SQLException sQLException) {
            StringWriter errors = new StringWriter();
            sQLException.printStackTrace(new PrintWriter(errors));
            Bukkit.getLogger().warning(errors.toString());
        }
    }

    @Override
    public Integer getCurrency(String uuid) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.main + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return rs.getInt("currency");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    @Override
    public boolean isPlayer(String uuid, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return true;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return false;
    }

    @Override
    public Integer getQuests(String uuid) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.main + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return rs.getInt("quests");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    @Override
    public void setStringData(String uuid, String column, String data) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.passiveTable + " SET " + column + "=" + data + " WHERE uuid=?");
            ps.setString(1, uuid);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public String getQuestTime(String uuid, String quest) {
        return this.getQuest(uuid, quest, this.questTallyTable);
    }

    @Override
    public String getPassiveTime(String uuid, String passive) {
        return this.getQuest(uuid, passive, this.passiveTable);
    }

    @Override
    public String getQuestTally(String uuid, String quest) {
        return this.getQuest(uuid, quest, this.questTallyTable);
    }

    @Override
    public String getQuest(String uuid, String quest, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return rs.getString(quest);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return "0";
    }

    @Override
    public void setDateTable(Player player, String[] str) {
        this.setTable(player, str, this.questLastTable);
    }

    @Override
    public void setQuestsTable(Player player, String[] str) {
        this.setTable(player, str, this.questTallyTable);
    }

    private void setTable(Player player, String[] str, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            String statement = "REPLACE INTO " + table + " (player,uuid,";
            PreparedStatement ps = this.plugin.misc.getPreparedStatementQuest(conn, statement, this.plugin);
            this.setupStatement(player, str, ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    private void runPassiveSet(Player player, String[] str, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            String statement = "REPLACE INTO " + table + " (player,uuid,";
            PreparedStatement ps = this.getPreparedStatementPassive(conn, statement, this.plugin);
            this.setupStatement(player, str, ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    private void setupStatement(Player player, String[] str, PreparedStatement ps) throws SQLException {
        ps.setString(1, player.getName().toLowerCase());
        ps.setString(2, player.getUniqueId().toString());
        for (int i = 3; i < str.length + 3; ++i) {
            ps.setString(i, str[i - 3]);
        }
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info("Running query: " + ps);
        }
        ps.executeUpdate();
    }

    private PreparedStatement getPreparedStatementPassive(Connection conn, String statement, RaindropQuests plugin) throws SQLException {
        StringBuilder statementBuilder = new StringBuilder((String)statement);
        for (String st : plugin.settings.passiveNames) {
            statementBuilder.append(st).append(",");
        }
        statement = statementBuilder.toString();
        statement = (String)statement + "passive19";
        statement = (String)statement + ") VALUES(?,?,";
        statement = (String)statement + "?,".repeat(plugin.settings.passiveNames.size());
        statement = (String)statement + "?)";
        PreparedStatement ps = conn.prepareStatement((String)statement);
        return ps;
    }

    @Override
    public void addPlayerToPotionsTable(Player player) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO " + this.potionTable + " (uuid,");
            for (PotionID potionID : PotionID.values()) {
                statement.append(potionID.name()).append(",");
            }
            for (Enum enum_ : SplashPotionID.values()) {
                statement.append(enum_.name()).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(\"").append(player.getUniqueId()).append("\",");
            statement.append("0,".repeat(PotionID.values().length));
            statement.append("0,".repeat(SplashPotionID.values().length));
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            PreparedStatement ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    @Deprecated
    public boolean randomEnabled() {
        try {
            ResultSet rs;
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT enabled FROM " + this.randomTable);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            if ((rs = ps.executeQuery()).next()) {
                return rs.getInt("enabled") == 1;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return false;
    }

    @Override
    public String getQuestRefreshTime() {
        try {
            ResultSet rs;
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT last_run FROM " + this.randomTable);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            if ((rs = ps.executeQuery()).next()) {
                return rs.getString("last_run");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return "";
    }

    @Override
    public int checkQuestRandomList(String quest) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT " + quest + " FROM " + this.randomTable);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getInt(quest);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    @Override
    public void updateRandomTable(int enabled, int random, String date, String[] quests) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO " + this.randomTable + " (enabled,random,last_run,");
            for (int i = 0; i < this.plugin.settings.numberOfQuests; ++i) {
                statement.append(this.plugin.settings.quests.get(i).getName()).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(").append(enabled).append(",").append(random).append(",").append(date).append(",");
            for (String s : quests) {
                statement.append(s).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            PreparedStatement ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public boolean checkRandomTable() {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            StringBuilder statement = new StringBuilder("SELECT * FROM ").append(this.randomTable);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            PreparedStatement ps = conn.prepareStatement(statement.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getInt("enabled") != 1) continue;
                return true;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return false;
    }

    @Override
    public void addPlayerToCounterTable(Player player) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO " + this.counterTable + " (uuid,");
            for (String s : this.plugin.settings.allMobTypes) {
                statement.append(s).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(\"").append(player.getUniqueId()).append("\",");
            statement.append("0,".repeat(this.plugin.settings.allMobTypes.size()));
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(statement.toString());
            }
            PreparedStatement ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public void setPassive(Player player, String passive, Integer value) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.main + " set " + passive + "=? WHERE uuid=?");
            ps.setInt(1, value);
            ps.setString(2, player.getUniqueId().toString());
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public void setCurrency(Player player, Integer value) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.main + " set currency=? WHERE uuid=?");
            ps.setInt(1, value);
            ps.setString(2, player.getUniqueId().toString());
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public void setPassivesTable(Player player, String[] str) {
        this.runPassiveSet(player, str, this.passiveTable);
    }

    @Override
    public Integer getPassiveStatus(Player player, String passive) {
        try {
            ResultSet rs;
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT " + passive.toLowerCase() + " FROM " + this.main + " WHERE uuid = ?");
            ps.setString(1, player.getUniqueId().toString());
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            if ((rs = ps.executeQuery()).next()) {
                return rs.getInt(passive);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return null;
    }

    @Override
    public ArrayList<String> getAllPlayers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT uuid FROM " + this.main);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("uuid"));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return list;
    }

    @Override
    public void messageBlockUpdate(ArrayList<String> data, RaindropQuests plugin) {
        if (plugin.settings.pm.getExtendedDebug()) {
            plugin.getLogger().info(data.toString());
        }
        if (plugin.settings.pm.getDebug()) {
            if (data.size() < 2) {
                if (data.size() % 5 == 0) {
                    plugin.getLogger().info("Loaded approximately " + data.size() * 5 + " blocks  into " + data.size() + " rows");
                } else {
                    plugin.getLogger().info("Loaded approximately " + data.get(0).length() / 81 + " blocks  into " + data.size() + " rows");
                }
            } else {
                plugin.getLogger().info("Loaded approximately " + (data.size() * 5 + data.get(data.size() - 1).length() / 81) + " blocks  into " + data.size() + " rows");
            }
        }
    }

    @Override
    public void updateBlockData(ArrayList<String> data) {
        PreparedStatement ps;
        Connection conn;
        this.messageBlockUpdate(data, this.plugin);
        try {
            conn = this.plugin.settings.sql.getConnection();
            ps = conn.prepareStatement("TRUNCATE TABLE " + this.blockData);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        for (int i = 0; i < data.size(); ++i) {
            String s = data.get(i);
            try {
                conn = this.plugin.settings.sql.getConnection();
                ps = conn.prepareStatement("REPLACE INTO " + this.blockData + "(id,blockdata) VALUES(?,?)");
                ps.setInt(1, i);
                ps.setString(2, s);
                if (this.plugin.settings.pm.getExtendedDebug()) {
                    this.plugin.getLogger().info("Running query: " + ps);
                }
                ps.executeUpdate();
                continue;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
            }
        }
    }

    @Override
    public void setPotionCount(String uuid, String potion, Integer amount) {
        if (amount == null) {
            return;
        }
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.potionTable + " SET " + potion + "=" + amount + " WHERE uuid=?");
            ps.setString(1, uuid);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public void setKillCount(String uuid, String mob, Integer amount) {
        if (amount == null) {
            return;
        }
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.counterTable + " SET " + mob + "=" + amount + " WHERE uuid=?");
            ps.setString(1, uuid);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    @Deprecated
    public void loadAllKillData() {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.counterTable + ";");
            SQLGetter.runKillDataFromLoad(ps, this.plugin);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Deprecated
    public static void runKillDataFromLoad(PreparedStatement ps, RaindropQuests plugin) throws SQLException {
        if (plugin.settings.pm.getExtendedDebug()) {
            plugin.getLogger().info("Running query: " + ps.toString());
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            UUID id = UUID.fromString(rs.getString("uuid"));
            KillCount kc = new KillCount(plugin, id);
            for (String s : plugin.settings.mythicMobTypes) {
                kc.mythicMobKills.put(s, rs.getInt(s));
            }
            for (String s : plugin.settings.vanillaMobsTypes) {
                kc.vanillaMobKills.put(s, rs.getInt(s));
            }
            plugin.settings.playerKills.put(id, kc);
        }
    }

    public void dropColumn(String table, String column) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("ALTER TABLE " + table + " DROP COLUMN " + column);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public void setColumnName(String table, String oldColumn, String newColumn) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("ALTER TABLE " + table + " RENAME COLUMN " + oldColumn + " TO " + newColumn);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public String[] getColumnNames(String table) {
        String[] columns;
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + table);
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData md = rs.getMetaData();
            int count = md.getColumnCount();
            columns = new String[count];
            for (int i = 1; i <= count; ++i) {
                columns[i - 1] = md.getColumnLabel(i);
            }
        }
        catch (SQLException ex) {
            columns = new String[]{};
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return columns;
    }

    @Override
    public int getPotionCount(String uuid, String potion) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.potionTable + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                return rs.getInt(potion);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    @Override
    public int getKillCount(String uuid, String entity) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.counterTable + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                return rs.getInt(entity);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    @Override
    public TreeMap<String, Integer> getAllKills(String uuid) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.counterTable + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ResultSetMetaData meta = rs.getMetaData();
                int columns = meta.getColumnCount();
                ArrayList<String> mobs = new ArrayList<String>();
                for (int i = 1; i < columns; ++i) {
                    if (meta.getColumnName(i).equalsIgnoreCase("uuid")) continue;
                    mobs.add(meta.getColumnName(i));
                }
                for (String s : mobs) {
                    map.put(s, rs.getInt(s));
                }
            }
            return map;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
            return map;
        }
    }

    @Override
    public ArrayList<Block> getBlockData() {
        ArrayList<String> temp = new ArrayList<String>();
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.blockData + ";");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                temp.add(rs.getString("blockdata"));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info(temp.toString());
        }
        return this.plugin.settings.blockHandler.loadBlockData(temp);
    }

    @Override
    public void setMainTable(Player player, Integer currency, Integer quests, Integer wood_passive, Integer iron_passive, Integer gold_passive, Integer diamond_passive, Integer nether_passive, Integer bonus_passive, Integer potion_return, Integer potion_extend, Integer potion_strength, Integer superheat, Integer transmog, Integer CraftNetherTools, Integer CraftNetherWeapons, Integer CraftNetherArmor, Integer condense, Integer expedire, Integer mixologist, Integer transmutation, Integer crystallize, Integer passive19) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("REPLACE INTO " + this.main + "(uuid,player,currency,quests,wood_passive,iron_passive,gold_passive,diamond_passive,nether_passive,bonus_passive,potion_return,potion_extend,potion_strength,superheat,transmogrification,craftnethertools,craftnetherweapons,craftnetherarmor,condense,expedire,mixologist,transmutation,crystallize,passive19) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            this.plugin.misc.setupPreparedStatement(player, currency, quests, wood_passive, iron_passive, gold_passive, diamond_passive, nether_passive, bonus_passive, potion_return, potion_extend, potion_strength, superheat, transmog, CraftNetherTools, CraftNetherWeapons, CraftNetherArmor, condense, expedire, mixologist, transmutation, crystallize, passive19, ps);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Override
    public String toString() {
        return "This is a SQLGetter class object";
    }
}

