/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.LuckPerms;

import com.itsrainingplex.LuckPerms.SuffixItem;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.Rank;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.impl.SimpleGUI;
import de.studiocode.invui.window.impl.single.SimpleWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class SuffixManager {
    private final RaindropQuests plugin;

    public SuffixManager(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public void createSuffixGUI(Player player) {
        GUI gui;
        if (!this.plugin.settings.luckPerms) {
            if (this.plugin.settings.pm.getDebug()) {
                this.plugin.getLogger().warning("LuckPerms not found. Cancelling GUI...");
            }
            return;
        }
        ArrayList<String> playerSuffixes = this.getPlayerSuffixes(player);
        Collection<SuffixItem> suffixesGUIItems = this.plugin.settings.ranks.suffixGUIItem.values();
        ArrayList<SuffixItem> suffixItems = new ArrayList<SuffixItem>(suffixesGUIItems);
        ArrayList<SuffixItem> playerSuffixItems = new ArrayList<SuffixItem>();
        for (SuffixItem item : suffixItems) {
            for (String s : playerSuffixes) {
                if (!item.rank.suffix.equalsIgnoreCase(s)) continue;
                playerSuffixItems.add(item);
            }
        }
        if (this.plugin.settings.ranks.guiType.equalsIgnoreCase("Tab")) {
            ArrayList<GUI> guiList = new ArrayList<GUI>();
            for (int i = 1; i < 10; ++i) {
                SimpleGUI tempGUI = new SimpleGUI(9, 6);
                for (SuffixItem suffixItem : playerSuffixItems) {
                    if (suffixItem.rank.tier != i) continue;
                    tempGUI.addItems(suffixItem);
                }
                if (this.plugin.settings.towny && i == this.plugin.settings.ranks.townySuffixTab && this.plugin.settings.ranks.townySuffix) {
                    Rank rank;
                    Object str;
                    if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkKing(player)) {
                        str = this.plugin.settings.ranks.nationNameSuffix ? this.plugin.settings.ranks.townyManager.getKingName(player) + " of " + this.plugin.settings.ranks.townyManager.getNationName(player) : this.plugin.settings.ranks.townyManager.getKingName(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getKingName(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new SuffixItem(this.plugin, rank));
                    } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getNationRank(player).isBlank()) {
                        str = this.plugin.settings.ranks.nationNamePrefix ? this.plugin.settings.ranks.townyManager.getNationRank(player) + " of " + this.plugin.settings.ranks.townyManager.getNationName(player) : this.plugin.settings.ranks.townyManager.getNationRank(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getNationRank(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new SuffixItem(this.plugin, rank));
                    }
                    if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkMayor(player)) {
                        str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getMayorName(player) + " of " + this.plugin.settings.ranks.townyManager.getTownName(player) : this.plugin.settings.ranks.townyManager.getMayorName(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getMayorName(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new SuffixItem(this.plugin, rank));
                    } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getTownRank(player).isBlank()) {
                        str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getTownRank(player) + " of " + this.plugin.settings.ranks.townyManager.getTownName(player) : this.plugin.settings.ranks.townyManager.getTownRank(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getTownRank(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new SuffixItem(this.plugin, rank));
                    }
                }
                guiList.add(tempGUI);
            }
            gui = this.plugin.settings.ranks.guiManager.getTabbedGUI(guiList);
        } else {
            gui = this.plugin.settings.ranks.guiType.equalsIgnoreCase("Scroll") ? this.plugin.settings.ranks.guiManager.getSuffixScrolledGUI(this.createTownySuffixItem(player, playerSuffixItems)) : this.plugin.settings.ranks.guiManager.getSuffixPagedGUI(this.createTownySuffixItem(player, playerSuffixItems));
        }
        new SimpleWindow(player, "Suffix Menu", gui).show();
    }

    private List<SuffixItem> createTownySuffixItem(Player player, List<SuffixItem> playerSuffixItems) {
        if (!this.plugin.settings.towny) {
            return playerSuffixItems;
        }
        if (this.plugin.settings.ranks.townySuffix) {
            Rank rank;
            Object str;
            if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkKing(player)) {
                str = this.plugin.settings.ranks.nationNamePrefix ? this.plugin.settings.ranks.townyManager.getNationName(player) + " " + this.plugin.settings.ranks.townyManager.getKingName(player) : this.plugin.settings.ranks.townyManager.getKingName(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getKingName(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerSuffixItems.add(new SuffixItem(this.plugin, rank));
            } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getNationRank(player).isBlank()) {
                str = this.plugin.settings.ranks.nationNamePrefix ? this.plugin.settings.ranks.townyManager.getNationName(player) + " " + this.plugin.settings.ranks.townyManager.getNationRank(player) : this.plugin.settings.ranks.townyManager.getNationRank(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getNationRank(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerSuffixItems.add(new SuffixItem(this.plugin, rank));
            }
            if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkMayor(player)) {
                str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getTownName(player) + " " + this.plugin.settings.ranks.townyManager.getMayorName(player) : this.plugin.settings.ranks.townyManager.getMayorName(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getMayorName(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerSuffixItems.add(new SuffixItem(this.plugin, rank));
            } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getTownRank(player).isBlank()) {
                str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getTownName(player) + " " + this.plugin.settings.ranks.townyManager.getTownRank(player) : this.plugin.settings.ranks.townyManager.getTownRank(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getTownRank(player), this.plugin.settings.ranks.townSuffixMaterial, "Towny", null, null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerSuffixItems.add(new SuffixItem(this.plugin, rank));
            }
        }
        return playerSuffixItems;
    }

    public ArrayList<String> getPlayerSuffixes(Player player) {
        Set<String> groups = this.plugin.settings.ranks.lpm.getPlayerGroups((OfflinePlayer)player);
        ArrayList<String> suffixes = new ArrayList<String>();
        for (String s : groups) {
            for (Rank rank : this.plugin.settings.ranks.ranks.values()) {
                if (!rank.rankID.equalsIgnoreCase(s.toLowerCase())) continue;
                suffixes.add(rank.suffix);
            }
            for (Rank altRank : this.plugin.settings.ranks.altRanks.values()) {
                if (!altRank.rankID.equalsIgnoreCase(s.toLowerCase())) continue;
                suffixes.add(altRank.suffix);
            }
        }
        suffixes.remove("None");
        suffixes.remove("none");
        suffixes = this.removeDuplicates(suffixes);
        return suffixes;
    }

    public <T> ArrayList<T> removeDuplicates(ArrayList<T> list) {
        ArrayList<T> newList = new ArrayList<T>();
        for (T element : list) {
            if (newList.contains(element)) continue;
            newList.add(element);
        }
        return newList;
    }
}

