/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.LuckPerms;

import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.Rank;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.query.QueryOptions;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LuckPermsManager {
    private final RaindropQuests plugin;

    public LuckPermsManager(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public User getLuckPermUser(UUID uuid) {
        return ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getPlayerAdapter(Player.class).getUser((Object)Objects.requireNonNull(Bukkit.getPlayer((UUID)uuid)));
    }

    public Set<String> getPlayerGroups(OfflinePlayer player) {
        if (player.getPlayer() != null) {
            Collection nodes = Objects.requireNonNull(((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getUserManager().getUser(player.getUniqueId())).getNodes();
            return nodes.stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(arg_0 -> ((NodeType)NodeType.INHERITANCE).cast(arg_0)).map(InheritanceNode::getGroupName).collect(Collectors.toSet());
        }
        User user = this.getOfflineUser(player);
        Collection nodes = user.getNodes();
        return nodes.stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(arg_0 -> ((NodeType)NodeType.INHERITANCE).cast(arg_0)).map(InheritanceNode::getGroupName).collect(Collectors.toSet());
    }

    public User getOfflineUser(OfflinePlayer player) {
        UserManager userManager = ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getUserManager();
        CompletableFuture userFuture = userManager.loadUser(player.getUniqueId());
        return (User)userFuture.join();
    }

    public ArrayList<String> getPermissions(OfflinePlayer player) {
        Collection nodes;
        ArrayList<String> list = new ArrayList<String>();
        if (player.getPlayer() != null) {
            nodes = Objects.requireNonNull(((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getUserManager().getUser(player.getUniqueId())).resolveInheritedNodes(QueryOptions.nonContextual());
        } else {
            User user = this.getOfflineUser(player);
            nodes = user.resolveInheritedNodes(QueryOptions.nonContextual());
        }
        for (Node node : nodes) {
            if (node.getKey().toLowerCase().startsWith("displayname") || node.getKey().toLowerCase().startsWith("weight") || node.getKey().toLowerCase().startsWith("group")) continue;
            list.add(node.getKey());
        }
        Collections.sort(list);
        return list;
    }

    public boolean checkPlayerHasGroup(Player player, String group) {
        Set<String> groups = this.getPlayerGroups((OfflinePlayer)player);
        return groups.contains(group.toLowerCase());
    }

    public void createGroups(TreeMap<String, Rank> map) {
        Set groupSet = ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getGroupManager().getLoadedGroups();
        for (Rank rank : map.values()) {
            this.plugin.getLogger().info("Creating group " + rank.rankName);
            boolean found = false;
            for (Group g : groupSet) {
                if (!g.getName().equalsIgnoreCase(rank.rankID)) continue;
                int weight = -1;
                if (g.getWeight().isPresent()) {
                    weight = g.getWeight().getAsInt();
                }
                if (weight != -1 && weight == rank.weight) break;
                this.plugin.getLogger().info("Weight command " + rank.rankName);
                Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)("lp group " + rank.rankID + " setweight " + rank.weight));
                found = true;
                break;
            }
            if (found) continue;
            this.plugin.getLogger().info("Create command " + rank.rankName);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)("lp creategroup " + rank.rankID + " " + rank.weight + " \"" + rank.rankName + "\""));
        }
    }

    public boolean checkGroups(TreeMap<String, Rank> map) {
        Set groupSet = ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getGroupManager().getLoadedGroups();
        for (Rank rank : map.values()) {
            boolean found = false;
            for (Group g : groupSet) {
                if (g.getName().equalsIgnoreCase(rank.rankID)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void setPlayerPrefix(Player player, String prefix, int priority) {
        PrefixNode node = (PrefixNode)PrefixNode.builder((String)prefix, (int)priority).build();
        User user = ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getPlayerAdapter(Player.class).getUser((Object)player);
        user.data().add((Node)node);
        ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getUserManager().saveUser(user);
    }

    public void removePlayerPrefix(Player player, int priority) {
        User user = ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getPlayerAdapter(Player.class).getUser((Object)player);
        SortedMap prefixes = user.getCachedData().getMetaData().getPrefixes();
        for (Integer i : prefixes.keySet()) {
            if (i != priority) continue;
            user.data().remove((Node)PrefixNode.builder((String)((String)prefixes.get(i)), (int)i).build());
        }
        ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getUserManager().saveUser(user);
    }

    public void setPlayerSuffix(Player player, String suffix, int priority) {
        SuffixNode node = (SuffixNode)SuffixNode.builder((String)suffix, (int)priority).build();
        User user = ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getPlayerAdapter(Player.class).getUser((Object)player);
        user.data().add((Node)node);
        ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getUserManager().saveUser(user);
    }

    public void removePlayerSuffix(Player player, int priority) {
        User user = ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getPlayerAdapter(Player.class).getUser((Object)player);
        SortedMap suffixes = user.getCachedData().getMetaData().getSuffixes();
        for (Integer i : suffixes.keySet()) {
            if (i != priority) continue;
            user.data().remove((Node)SuffixNode.builder((String)((String)suffixes.get(i)), (int)i).build());
        }
        ((LuckPerms)Objects.requireNonNull(Bukkit.getServicesManager().getRegistration(LuckPerms.class)).getProvider()).getUserManager().saveUser(user);
    }
}

