/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Listeners;

import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.RaindropQuests;
import java.util.Objects;
import java.util.Random;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class Potions
implements Listener {
    private final RaindropQuests plugin;

    public Potions(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onConsume(PlayerItemConsumeEvent event) {
        String[] str = new String[this.plugin.settings.passiveNames.size()];
        ItemStack consumed = event.getItem();
        if (consumed.getType().equals((Object)Material.POTION)) {
            int j;
            BaseComponent[] component;
            PotionMeta pot = (PotionMeta)consumed.getItemMeta();
            DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
            if (event.getPlayer().hasPermission("RaindropQuests.passive.Potion_Return") && db.getPassiveStatus(event.getPlayer(), "Potion_Return") == 1) {
                if (System.currentTimeMillis() - Long.parseLong(db.getPassiveTime(event.getPlayer().getUniqueId().toString(), this.plugin.settings.passives.get("Potion_Return").name())) <= (long)this.plugin.settings.passives.get("Potion_Return").coolDown() * 1000L) {
                    component = new ComponentBuilder("Still on cool down for: ").append(String.valueOf(((long)this.plugin.settings.passives.get("Potion_Return").coolDown() * 1000L - (System.currentTimeMillis() - Long.parseLong(db.getPassiveTime(event.getPlayer().getUniqueId().toString(), event.getPlayer().getName())))) / 1000L)).append(" seconds.").create();
                    event.getPlayer().spigot().sendMessage(component);
                } else {
                    this.runPotMeta(event, consumed, pot);
                    j = 0;
                    for (String s : this.plugin.settings.passiveNames) {
                        str[j] = s.equalsIgnoreCase("Potion_Return") ? String.valueOf(System.currentTimeMillis()) : db.getPassiveTime(event.getPlayer().getUniqueId().toString(), s);
                        ++j;
                    }
                }
            }
            if (event.getPlayer().hasPermission("RaindropQuests.passive.Potion_Extend") && db.getPassiveStatus(event.getPlayer(), "Potion_Extend") == 1) {
                if (System.currentTimeMillis() - Long.parseLong(db.getPassiveTime(event.getPlayer().getUniqueId().toString(), this.plugin.settings.passives.get("Potion_Extend").name())) <= (long)this.plugin.settings.passives.get("Potion_Extend").coolDown() * 1000L) {
                    component = new ComponentBuilder("Still on cool down for: ").append(String.valueOf(((long)this.plugin.settings.passives.get("Potion_Extend").coolDown() * 1000L - (System.currentTimeMillis() - Long.parseLong(db.getPassiveTime(event.getPlayer().getUniqueId().toString(), event.getPlayer().getName())))) / 1000L)).append(" seconds.").create();
                    event.getPlayer().spigot().sendMessage(component);
                } else {
                    assert (pot != null);
                    this.runPotExtend(event, pot);
                    j = 0;
                    for (String s : this.plugin.settings.passiveNames) {
                        str[j] = s.equalsIgnoreCase("Potion_Extend") ? String.valueOf(System.currentTimeMillis()) : db.getPassiveTime(event.getPlayer().getUniqueId().toString(), s);
                        ++j;
                    }
                }
            }
            if (event.getPlayer().hasPermission("RaindropQuests.passive.Potion_Strength") && db.getPassiveStatus(event.getPlayer(), "Potion_Strength") == 1) {
                if (System.currentTimeMillis() - Long.parseLong(db.getPassiveTime(event.getPlayer().getUniqueId().toString(), this.plugin.settings.passives.get("Potion_Strength").name())) <= (long)this.plugin.settings.passives.get("Potion_Strength").coolDown() * 1000L) {
                    component = new ComponentBuilder("Still on cool down for: ").append(String.valueOf(((long)this.plugin.settings.passives.get("Potion_Strength").coolDown() * 1000L - (System.currentTimeMillis() - Long.parseLong(db.getPassiveTime(event.getPlayer().getUniqueId().toString(), event.getPlayer().getName())))) / 1000L)).append(" seconds.").create();
                    event.getPlayer().spigot().sendMessage(component);
                } else {
                    assert (pot != null);
                    event.getPlayer().addPotionEffect(Objects.requireNonNull(pot.getBasePotionData().getType().getEffectType()).createEffect(Potions.getPotionDuration(pot.getBasePotionData().getType().getEffectType(), pot.getBasePotionData().isExtended(), pot.getBasePotionData().isUpgraded()), (int)this.plugin.settings.getPassive("Potion_Strength").amount()));
                    component = new ComponentBuilder("Strength multiplied by ").append(String.valueOf(this.plugin.settings.getPassive("Potion_Strength").amount())).create();
                    event.getPlayer().spigot().sendMessage(component);
                    j = 0;
                    for (String s : this.plugin.settings.passiveNames) {
                        str[j] = s.equalsIgnoreCase("Potion_Strength") ? String.valueOf(System.currentTimeMillis()) : db.getPassiveTime(event.getPlayer().getUniqueId().toString(), s);
                        ++j;
                    }
                }
            }
            db.setPassivesTable(event.getPlayer(), str);
        }
    }

    private void runPotMeta(PlayerItemConsumeEvent event, ItemStack consumed, PotionMeta pot) {
        boolean found = false;
        for (String tempPot : this.plugin.settings.getPassive("Potion_Return").itemNames()) {
            if (tempPot == null || !pot.getBasePotionData().getType().equals((Object)PotionType.valueOf((String)tempPot.toUpperCase()))) continue;
            found = true;
        }
        Random random = new Random();
        double r = random.nextDouble();
        if (r < this.plugin.settings.getPassive("Potion_Return").chance() && found) {
            event.getPlayer().getInventory().addItem(new ItemStack[]{consumed});
            BaseComponent[] component = new ComponentBuilder("You saved a potion!").create();
            event.getPlayer().spigot().sendMessage(component);
        }
    }

    private void runPotExtend(PlayerItemConsumeEvent event, PotionMeta pot) {
        event.getPlayer().addPotionEffect(Objects.requireNonNull(pot.getBasePotionData().getType().getEffectType()).createEffect((int)((double)Potions.getPotionDuration(pot.getBasePotionData().getType().getEffectType(), pot.getBasePotionData().isExtended(), pot.getBasePotionData().isUpgraded()) * this.plugin.settings.getPassive("Potion_Extend").amount() * 20.0), 1));
        BaseComponent[] component = new ComponentBuilder("Potion duration increased to ").append(String.valueOf((double)Potions.getPotionDuration(pot.getBasePotionData().getType().getEffectType(), pot.getBasePotionData().isExtended(), pot.getBasePotionData().isUpgraded()) * this.plugin.settings.getPassive("Potion_Extend").amount())).append(" seconds").create();
        event.getPlayer().spigot().sendMessage(component);
    }

    public static int getPotionDuration(PotionEffectType effect, Boolean isExtended, Boolean upgraded) {
        int level = upgraded != false ? 2 : 1;
        if (effect == PotionEffectType.REGENERATION) {
            if (level == 2) {
                return 23;
            }
            if (isExtended.booleanValue()) {
                return 90;
            }
            return 45;
        }
        if (effect == PotionEffectType.SPEED) {
            if (level == 2) {
                return 90;
            }
            if (isExtended.booleanValue()) {
                return 480;
            }
            return 180;
        }
        if (effect == PotionEffectType.FIRE_RESISTANCE) {
            if (isExtended.booleanValue()) {
                return 480;
            }
            return 180;
        }
        if (effect == PotionEffectType.NIGHT_VISION) {
            if (isExtended.booleanValue()) {
                return 480;
            }
            return 180;
        }
        if (effect == PotionEffectType.INCREASE_DAMAGE) {
            if (level == 2) {
                return 90;
            }
            if (isExtended.booleanValue()) {
                return 480;
            }
            return 180;
        }
        if (effect == PotionEffectType.JUMP) {
            if (level == 2) {
                return 90;
            }
            if (isExtended.booleanValue()) {
                return 480;
            }
            return 180;
        }
        if (effect == PotionEffectType.WATER_BREATHING) {
            if (isExtended.booleanValue()) {
                return 480;
            }
            return 180;
        }
        if (effect == PotionEffectType.INVISIBILITY) {
            if (isExtended.booleanValue()) {
                return 480;
            }
            return 180;
        }
        if (effect == PotionEffectType.POISON) {
            if (level == 2) {
                return 22;
            }
            if (isExtended.booleanValue()) {
                return 90;
            }
            return 45;
        }
        if (effect == PotionEffectType.WEAKNESS) {
            if (isExtended.booleanValue()) {
                return 240;
            }
            return 90;
        }
        if (effect == PotionEffectType.SLOW) {
            if (isExtended.booleanValue()) {
                return 240;
            }
            return 90;
        }
        return 0;
    }
}

