/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Listeners;

import com.gmail.nossr50.events.skills.alchemy.McMMOPlayerBrewEvent;
import com.itsrainingplex.Crafting.PotionID;
import com.itsrainingplex.Crafting.SplashPotionID;
import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.RaindropQuests;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Brewer
implements Listener {
    private final RaindropQuests plugin;

    public Brewer(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void mcMMOBrew(@NotNull McMMOPlayerBrewEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            BrewerInventory inventory = event.getBrewingStand().getInventory();
            for (ItemStack i : inventory.getContents()) {
                String id;
                PotionMeta meta;
                if (i == null) continue;
                if (i.getType().equals((Object)Material.POTION)) {
                    meta = (PotionMeta)i.getItemMeta();
                    if (meta != null) {
                        id = this.plugin.settings.potionHandler.getPotionID("Potion", String.valueOf(meta.getBasePotionData().getType()).toLowerCase(), meta.getBasePotionData().isUpgraded(), meta.getBasePotionData().isExtended());
                        this.updatePotionsDatabases(event.getPlayer(), PotionID.getNameByValue(id));
                        continue;
                    }
                    if (!this.plugin.settings.pm.getDebug()) continue;
                    this.plugin.getLogger().info("Potion not found");
                    continue;
                }
                if (!i.getType().equals((Object)Material.SPLASH_POTION)) continue;
                meta = (PotionMeta)i.getItemMeta();
                if (meta != null) {
                    id = this.plugin.settings.potionHandler.getPotionID("Splash", String.valueOf(meta.getBasePotionData().getType()).toLowerCase(), meta.getBasePotionData().isUpgraded(), meta.getBasePotionData().isExtended());
                    this.updatePotionsDatabases(event.getPlayer(), SplashPotionID.getNameByValue(id));
                    continue;
                }
                if (!this.plugin.settings.pm.getDebug()) continue;
                this.plugin.getLogger().info("Potion not found");
            }
        }, 10L);
    }

    public void updatePotionsDatabases(Player player, String potionID) {
        DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
        db.setPotionCount(player.getUniqueId().toString(), potionID, db.getPotionCount(player.getUniqueId().toString(), potionID) + 1);
    }
}

