/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Handlers.Passives;

import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.Passives.Passive;
import com.itsrainingplex.RaindropQuests;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class PassiveHandler {
    private final RaindropQuests plugin;
    public Player player;

    public PassiveHandler(@NotNull RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public void handlePassive(@NotNull InventoryClickEvent e, Passive passive) {
        DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
        this.player = (Player)e.getWhoClicked();
        for (String str : this.plugin.settings.passiveNames) {
            BaseComponent[] component;
            if (!e.getWhoClicked().hasPermission("RaindropQuests.passive." + str)) continue;
            if (db.getPassiveStatus(this.player, str) == 0) {
                if (passive.index() != this.plugin.settings.getPassive(str).index()) continue;
                if (this.checkBalance(this.plugin.settings.passives.get(str), db)) {
                    if (this.checkQuestRequirements(this.player, this.plugin.settings.passives.get(str), db)) {
                        this.removeFunds(this.plugin.settings.passives.get(str), db);
                        db.setPassive(this.player, str, 1);
                        this.plugin.settings.send.sendMessage(this.player, this.plugin.settings.passivesMessageMap.get(str).getMessages().get("Purchased"), this.plugin.settings.passivesMessageMap.get(str).getDiscord(), this.plugin.settings.passivesMessageMap.get(str).getLogger(), this.plugin.settings.passivesMessageMap.get(str).getBroadcast(), this.plugin.settings.passivesMessageMap.get(str).getPlayer(), this.plugin.settings.discords.get("Passives"));
                        continue;
                    }
                    component = new ComponentBuilder("You do not meet the quest requirements").create();
                    this.player.spigot().sendMessage(component);
                    continue;
                }
                this.plugin.misc.sendBalanceMessage(this.player);
                continue;
            }
            if (db.getPassiveStatus(this.player, str) == 0 || passive.index() != this.plugin.settings.getPassive(str).index()) continue;
            component = new ComponentBuilder("You already have ").append(this.plugin.misc.translateText(this.plugin.settings.passives.get(str).title())).create();
            this.player.spigot().sendMessage(component);
        }
    }

    public void removeFunds(Passive passive, DBInterface db) {
        if (this.plugin.settings.vault && !this.plugin.settings.customMoney) {
            this.plugin.settings.economy.withdrawPlayer((OfflinePlayer)this.player, (double)passive.vault());
        } else if (this.plugin.settings.vault && this.plugin.settings.customMoney) {
            this.plugin.settings.economy.withdrawPlayer((OfflinePlayer)this.player, (double)passive.vault());
            db.setCurrency(this.player, db.getCurrency(this.player.getUniqueId().toString()) - passive.currency());
        } else if (!this.plugin.settings.vault && this.plugin.settings.customMoney) {
            db.setCurrency(this.player, db.getCurrency(this.player.getUniqueId().toString()) - passive.currency());
        }
    }

    public boolean checkBalance(Passive passive, DBInterface db) {
        if (this.plugin.settings.vault && !this.plugin.settings.customMoney) {
            return this.plugin.settings.economy.getBalance((OfflinePlayer)this.player) >= (double)passive.vault();
        }
        if (this.plugin.settings.vault && this.plugin.settings.customMoney) {
            return this.plugin.settings.economy.getBalance((OfflinePlayer)this.player) >= (double)passive.vault() && db.getCurrency(this.player.getUniqueId().toString()) >= passive.currency();
        }
        if (!this.plugin.settings.vault && this.plugin.settings.customMoney) {
            return db.getCurrency(this.player.getUniqueId().toString()) >= passive.currency();
        }
        return false;
    }

    public boolean checkQuestRequirements(Player player, @NotNull Passive passive, DBInterface db) {
        for (String s : passive.requirements().keySet()) {
            if (Integer.parseInt(db.getQuestTally(player.getUniqueId().toString(), s)) >= passive.requirements().get(s)) continue;
            return false;
        }
        return true;
    }
}

