/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.RaindropQuests;

import com.itsrainingplex.Block.Block;
import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.RaindropQuests;
import java.util.ArrayList;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LoadBlocks
extends SubCommand {
    private final RaindropQuests plugin;
    private final ArrayList<UUID> confirmation = new ArrayList();

    public LoadBlocks(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "LoadBlocks";
    }

    @Override
    public String getDescription() {
        return "Load blocks from the database";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " LoadBlocks";
    }

    @Override
    public void perform(@NotNull Player player, String[] args) {
        if (player.hasPermission("RaindropQuests.command.LoadBlocks")) {
            if (this.confirmation.contains(player.getUniqueId())) {
                BaseComponent[] component = new ComponentBuilder("Retrieving information from database...").create();
                player.spigot().sendMessage(component);
                this.plugin.misc.loadBlocks();
                LoadBlocks.messageBlockUpdate(this.plugin.settings.blocks, player);
                component = new ComponentBuilder("Data loaded.").create();
                player.spigot().sendMessage(component);
                this.confirmation.remove(player.getUniqueId());
            } else {
                this.confirmation.add(player.getUniqueId());
                BaseComponent[] component = new ComponentBuilder("&4WARNING THIS RESETS LOADED DATA WITH").append(" DATABASE DATA. TO SAVE DATA TO THE DATABASE USE /rq SaveData").create();
                player.spigot().sendMessage(component);
                component = new ComponentBuilder("&9Please &4confirm &9with /rq LoadBlocks").create();
                player.spigot().sendMessage(component);
            }
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            this.perform((Player)sender, args);
        } else {
            BaseComponent[] component = new ComponentBuilder("Only players can issue this command").create();
            sender.spigot().sendMessage(component);
        }
    }

    public static void messageBlockUpdate(@NotNull ArrayList<Block> data, Player player) {
        BaseComponent[] component = data.size() < 5 ? new ComponentBuilder("Loading approximately ").append(String.valueOf(data.size())).append(" blocks ").append(" into 1 row").create() : new ComponentBuilder("Loading approximately ").append(String.valueOf(data.size())).append(" blocks ").append(" into ").append(String.valueOf(data.size() / 5)).append(" rows").create();
        player.spigot().sendMessage(component);
    }
}

