/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.Potions;

import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.Crafting.PotionID;
import com.itsrainingplex.Crafting.SplashPotionID;
import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.RaindropQuests;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PotionCount
extends SubCommand {
    private final RaindropQuests plugin;

    public PotionCount(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "PotionCount";
    }

    @Override
    public String getDescription() {
        return "Get players potion count";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " PotionCount <PlayerName> <PotionID>";
    }

    @Override
    public void perform(Player player, String[] args) {
        if (Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).getUniqueId().equals(player.getUniqueId())) {
            if (player.hasPermission("RaindropQuests.command.PotionCount")) {
                this.checkCommands((CommandSender)player, args);
            }
        } else if (player.hasPermission("RaindropQuests.command.PotionCountOthers")) {
            this.checkCommands((CommandSender)player, args);
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        this.checkCommands(sender, args);
    }

    private void checkCommands(CommandSender sender, String @NotNull [] args) {
        if (args.length != 3) {
            BaseComponent[] component = new ComponentBuilder("Invalid arguments: ").append(this.getSyntax()).create();
            sender.spigot().sendMessage(component);
            return;
        }
        if (Bukkit.getPlayer((String)args[1]) == null) {
            BaseComponent[] component = new ComponentBuilder("Player not found").create();
            sender.spigot().sendMessage(component);
            return;
        }
        boolean found = false;
        String friendly = "Null";
        for (PotionID potionID : PotionID.values()) {
            if (!args[2].equalsIgnoreCase(potionID.name())) continue;
            found = true;
            friendly = potionID.getFriendlyName();
            break;
        }
        for (Enum enum_ : SplashPotionID.values()) {
            if (!args[2].equalsIgnoreCase(enum_.name())) continue;
            found = true;
            friendly = ((SplashPotionID)enum_).getFriendlyName();
            break;
        }
        if (!found) {
            BaseComponent[] component = new ComponentBuilder("Type not found").create();
            sender.spigot().sendMessage(component);
            return;
        }
        DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
        int count = db.getPotionCount(Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).getUniqueId().toString(), args[2]);
        BaseComponent[] component = new ComponentBuilder("[").append(args[1]).append("]").append(" Potion Count: ").append(String.valueOf(count)).color(ChatColor.BLUE).append(" ").color(ChatColor.WHITE).append(friendly).create();
        sender.spigot().sendMessage(component);
    }
}

