/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.Kills;

import com.itsrainingplex.Commands.Kills.KillTop;
import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.RaindropQuests;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MythicTop
extends SubCommand {
    private final RaindropQuests plugin;

    public MythicTop(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "MythicTop";
    }

    @Override
    public String getDescription() {
        return "Get top stats for player or mob";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " MythicTop {player_name | mob_name}";
    }

    @Override
    public void perform(@NotNull Player player, String[] args) {
        if (player.hasPermission("RaindropQuests.command.MythicTop")) {
            this.runCommand((CommandSender)player, args);
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        this.runCommand(sender, args);
    }

    public void runCommand(CommandSender sender, String @NotNull [] args) {
        if (args.length <= 1) {
            BaseComponent[] component = new ComponentBuilder("Invalid arguments: ").append(" | ").append(this.getSyntax()).create();
            sender.spigot().sendMessage(component);
        } else if (args.length == 2) {
            Player p = Bukkit.getPlayer((String)args[1]);
            DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
            if (p == null) {
                List<String> result = this.plugin.settings.mythicMobTypes.stream().map(String::toLowerCase).toList();
                if (result.contains(args[1].toLowerCase())) {
                    TreeMap<Integer, String> map = new TreeMap<Integer, String>(Collections.reverseOrder());
                    ArrayList<String> list = db.getAllPlayers();
                    for (String s : list) {
                        map.put(db.getKillCount(s, args[1].toLowerCase()), Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)UUID.fromString(s))).getName());
                    }
                    BaseComponent[] component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
                    sender.spigot().sendMessage(component);
                    this.prepareHeaderMob(sender, map, args);
                } else {
                    BaseComponent[] component = new ComponentBuilder("Mob or player not found: ").append(args[1]).create();
                    sender.spigot().sendMessage(component);
                }
            } else {
                TreeMap<Integer, String> map = new TreeMap<Integer, String>(Collections.reverseOrder());
                for (String str : this.plugin.settings.mythicMobTypes) {
                    map.put(db.getKillCount(p.getUniqueId().toString(), str), str);
                }
                BaseComponent[] component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
                sender.spigot().sendMessage(component);
                component = new ComponentBuilder("TOP MYTHIC STATS - ").color(ChatColor.RED).append(args[1]).color(ChatColor.BLUE).create();
                sender.spigot().sendMessage(component);
                KillTop.prepareListPlayer(sender, map);
            }
        }
    }

    private void prepareHeaderMob(CommandSender sender, TreeMap<Integer, String> map, String @NotNull [] args) {
        String str = args[1].substring(0, 1).toUpperCase() + args[1].substring(1).toLowerCase().replace('_', ' ');
        str = str.substring(0, str.indexOf(32) + 1) + str.substring(str.indexOf(32) + 1, str.indexOf(32) + 2).toUpperCase() + str.substring(str.indexOf(32) + 2);
        BaseComponent[] component = new ComponentBuilder("TOP STATS - ").color(ChatColor.RED).append(str).color(ChatColor.BLUE).create();
        KillTop.prepareHeader(sender, map, component);
    }
}

