/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.Kills;

import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.Interfaces.DBInterface;
import com.itsrainingplex.RaindropQuests;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MythicCount
extends SubCommand {
    private final RaindropQuests plugin;

    public MythicCount(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "MythicCount";
    }

    @Override
    public String getDescription() {
        return "Get kill count of a mythic mob";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " MythicCount <PlayerName> <MobName>";
    }

    @Override
    public void perform(@NotNull Player player, String @NotNull [] args) {
        if (Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).getUniqueId().equals(player.getUniqueId())) {
            if (player.hasPermission("RaindropQuests.command.MythicCount")) {
                this.checkCommands((CommandSender)player, args);
            }
        } else if (player.hasPermission("RaindropQuests.command.MythicCountOthers")) {
            this.checkCommands((CommandSender)player, args);
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        this.checkCommands(sender, args);
    }

    private void checkCommands(CommandSender sender, String @NotNull [] args) {
        if (args.length != 3) {
            BaseComponent[] component = new ComponentBuilder("Invalid arguments: ").append(this.getSyntax()).create();
            sender.spigot().sendMessage(component);
            return;
        }
        if (Bukkit.getPlayer((String)args[1]) == null) {
            BaseComponent[] component = new ComponentBuilder("Player not found").create();
            sender.spigot().sendMessage(component);
            return;
        }
        boolean found = false;
        for (String s : this.plugin.settings.mythicMobTypes) {
            if (s.equalsIgnoreCase("player") || !args[2].equalsIgnoreCase(s)) continue;
            found = true;
            break;
        }
        if (!found) {
            BaseComponent[] component = new ComponentBuilder("Type not found").create();
            sender.spigot().sendMessage(component);
            return;
        }
        DBInterface db = this.plugin.misc.getDatabase(this.plugin.settings.dbType);
        int count = db.getKillCount(Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).getUniqueId().toString(), args[2]);
        String str = args[2];
        if (MythicBukkit.inst().getMobManager().getMythicMob(args[2]).isPresent()) {
            str = String.valueOf(((MythicMob)MythicBukkit.inst().getMobManager().getMythicMob(args[2]).get()).getDisplayName());
        }
        BaseComponent[] component = new ComponentBuilder("[").append(args[1]).append("] ").append(" Mythic Kill Count: ").append(String.valueOf(count)).append(" ").append(str).create();
        sender.spigot().sendMessage(component);
    }
}

