/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.single;

import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.util.InventoryUtils;
import de.studiocode.invui.util.Pair;
import de.studiocode.invui.window.impl.BaseWindow;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class SingleWindow
extends BaseWindow {
    private final GUI gui;
    private final int size;
    protected Inventory inventory;

    public SingleWindow(UUID viewerUUID, ComponentWrapper title, GUI gui, Inventory inventory, boolean initItems, boolean closeable, boolean removeOnClose) {
        super(viewerUUID, title, gui.getSize(), closeable, removeOnClose);
        this.gui = gui;
        this.size = gui.getSize();
        this.inventory = inventory;
        gui.addParent(this);
        if (initItems) {
            this.initItems();
        }
    }

    protected void initItems() {
        for (int i = 0; i < this.size; ++i) {
            SlotElement element = this.gui.getSlotElement(i);
            this.redrawItem(i, element, true);
        }
    }

    @Override
    protected void setInvItem(int slot, ItemStack itemStack) {
        this.inventory.setItem(slot, itemStack);
    }

    @Override
    protected void handleOpened() {
    }

    @Override
    protected void handleClosed() {
    }

    @Override
    public void handleSlotElementUpdate(GUI child, int slotIndex) {
        this.redrawItem(slotIndex, this.gui.getSlotElement(slotIndex), true);
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        this.gui.handleClick(event.getSlot(), (Player)event.getWhoClicked(), event.getClick(), event);
    }

    @Override
    public void handleItemShift(InventoryClickEvent event) {
        this.gui.handleItemShift(event);
    }

    @Override
    public void handleCursorCollect(InventoryClickEvent event) {
        if (InventoryUtils.containsSimilar(this.inventory, event.getCursor())) {
            event.setCancelled(true);
        }
    }

    @Override
    protected Pair<GUI, Integer> getGuiAt(int index) {
        return index < this.gui.getSize() ? new Pair<GUI, Integer>(this.gui, index) : null;
    }

    @Override
    protected SlotElement getSlotElement(int index) {
        return this.gui.getSlotElement(index);
    }

    @Override
    public void handleViewerDeath(PlayerDeathEvent event) {
    }

    @Override
    public Inventory[] getInventories() {
        return new Inventory[]{this.inventory};
    }

    @Override
    public GUI[] getGuis() {
        return new GUI[]{this.gui};
    }

    public GUI getGui() {
        return this.gui;
    }
}

