/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.merged.split;

import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.util.Pair;
import de.studiocode.invui.util.SlotUtils;
import de.studiocode.invui.window.impl.merged.MergedWindow;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public abstract class SplitWindow
extends MergedWindow {
    private final GUI upperGui;
    private final GUI lowerGui;

    public SplitWindow(Player player, ComponentWrapper title, GUI upperGui, GUI lowerGui, Inventory upperInventory, boolean initItems, boolean closeable, boolean removeOnClose) {
        super(player, title, upperGui.getSize() + lowerGui.getSize(), upperInventory, closeable, removeOnClose);
        this.upperGui = upperGui;
        this.lowerGui = lowerGui;
        upperGui.addParent(this);
        lowerGui.addParent(this);
        if (initItems) {
            this.initUpperItems();
        }
    }

    @Override
    public void handleSlotElementUpdate(GUI child, int slotIndex) {
        this.redrawItem(child == this.upperGui ? slotIndex : this.upperGui.getSize() + slotIndex, child.getSlotElement(slotIndex), true);
    }

    @Override
    public SlotElement getSlotElement(int index) {
        if (index >= this.upperGui.getSize()) {
            return this.lowerGui.getSlotElement(index - this.upperGui.getSize());
        }
        return this.upperGui.getSlotElement(index);
    }

    @Override
    protected Pair<GUI, Integer> getWhereClicked(InventoryClickEvent event) {
        Inventory clicked = event.getClickedInventory();
        if (clicked == this.getUpperInventory()) {
            return new Pair<GUI, Integer>(this.upperGui, event.getSlot());
        }
        int index = SlotUtils.translatePlayerInvToGui(event.getSlot());
        return new Pair<GUI, Integer>(this.lowerGui, index);
    }

    @Override
    protected Pair<GUI, Integer> getGuiAt(int index) {
        if (index < this.upperGui.getSize()) {
            return new Pair<GUI, Integer>(this.upperGui, index);
        }
        if (index < this.upperGui.getSize() + this.lowerGui.getSize()) {
            return new Pair<GUI, Integer>(this.lowerGui, index - this.upperGui.getSize());
        }
        return null;
    }

    @Override
    public GUI[] getGuis() {
        return new GUI[]{this.upperGui, this.lowerGui};
    }
}

