/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.merged.split;

import de.studiocode.inventoryaccess.abstraction.inventory.CartographyInventory;
import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.map.MapIcon;
import de.studiocode.inventoryaccess.map.MapPatch;
import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.impl.SimpleGUI;
import de.studiocode.invui.util.MathUtils;
import de.studiocode.invui.window.impl.merged.split.SplitWindow;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.jetbrains.annotations.Nullable;

public final class CartographySplitWindow
extends SplitWindow {
    private final CartographyInventory cartographyInventory;
    private int mapId;

    public CartographySplitWindow(Player player, ComponentWrapper title, GUI upperGui, GUI lowerGui, boolean closeable) {
        super(player, title, CartographySplitWindow.createWrappingGUI(upperGui), lowerGui, null, false, closeable, true);
        this.cartographyInventory = InventoryAccess.createCartographyInventory(player, title);
        this.upperInventory = this.cartographyInventory.getBukkitInventory();
        this.initUpperItems();
        this.resetMap();
        this.register();
    }

    public CartographySplitWindow(Player player, ComponentWrapper title, GUI upperGui, GUI lowerGui) {
        this(player, title, upperGui, lowerGui, true);
    }

    public CartographySplitWindow(Player player, BaseComponent[] title, GUI upperGui, GUI lowerGui) {
        this(player, (ComponentWrapper)new BaseComponentWrapper(title), upperGui, lowerGui, true);
    }

    public CartographySplitWindow(Player player, BaseComponent[] title, GUI upperGui, GUI lowerGui, boolean closeable) {
        this(player, (ComponentWrapper)new BaseComponentWrapper(title), upperGui, lowerGui, closeable);
    }

    public CartographySplitWindow(Player player, String title, GUI upperGui, GUI lowerGui) {
        this(player, TextComponent.fromLegacyText((String)title), upperGui, lowerGui, true);
    }

    public CartographySplitWindow(Player player, String title, GUI upperGui, GUI lowerGui, boolean closeable) {
        this(player, TextComponent.fromLegacyText((String)title), upperGui, lowerGui, closeable);
    }

    private static GUI createWrappingGUI(GUI upperGui) {
        if (upperGui.getWidth() != 2 || upperGui.getHeight() != 1) {
            throw new IllegalArgumentException("GUI has to be 2x1");
        }
        SimpleGUI wrapperGUI = new SimpleGUI(3, 1);
        wrapperGUI.fillRectangle(1, 0, upperGui, true);
        return wrapperGUI;
    }

    public void updateMap(@Nullable MapPatch patch, @Nullable List<MapIcon> icons) {
        InventoryAccess.getPlayerUtils().sendMapUpdate(this.getViewer(), this.mapId, (byte)0, false, patch, icons);
    }

    public void updateMap(MapPatch patch) {
        this.updateMap(patch, null);
    }

    public void updateMap(List<MapIcon> icons) {
        this.updateMap(null, icons);
    }

    public void resetMap() {
        this.mapId = -MathUtils.RANDOM.nextInt(Integer.MAX_VALUE);
        ItemStack map = new ItemStack(Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)map.getItemMeta();
        mapMeta.setMapId(this.mapId);
        map.setItemMeta((ItemMeta)mapMeta);
        this.cartographyInventory.setItem(0, map);
    }

    @Override
    public void show() {
        if (this.isClosed()) {
            throw new IllegalStateException("The Window has already been closed.");
        }
        Player viewer = this.getViewer();
        if (viewer == null) {
            throw new IllegalStateException("The player is not online.");
        }
        this.cartographyInventory.open();
    }
}

