/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.merged.split;

import de.studiocode.inventoryaccess.abstraction.inventory.AnvilInventory;
import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.window.impl.merged.split.SplitWindow;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class AnvilSplitWindow
extends SplitWindow {
    private final AnvilInventory anvilInventory;

    public AnvilSplitWindow(Player player, ComponentWrapper title, GUI upperGui, GUI lowerGui, boolean closeable, Consumer<String> renameHandler) {
        super(player, title, upperGui, lowerGui, null, false, closeable, true);
        this.anvilInventory = InventoryAccess.createAnvilInventory(player, title, renameHandler);
        this.upperInventory = this.anvilInventory.getBukkitInventory();
        this.initUpperItems();
        this.register();
    }

    public AnvilSplitWindow(Player player, ComponentWrapper title, GUI upperGui, GUI lowerGui, Consumer<String> renameHandler) {
        this(player, title, upperGui, lowerGui, true, renameHandler);
    }

    public AnvilSplitWindow(Player player, BaseComponent[] title, GUI upperGui, GUI lowerGui, boolean closeable, Consumer<String> renameHandler) {
        this(player, (ComponentWrapper)new BaseComponentWrapper(title), upperGui, lowerGui, closeable, renameHandler);
    }

    public AnvilSplitWindow(Player player, BaseComponent[] title, GUI upperGui, GUI lowerGui, Consumer<String> renameHandler) {
        this(player, title, upperGui, lowerGui, true, renameHandler);
    }

    public AnvilSplitWindow(Player player, String title, GUI upperGui, GUI lowerGui, boolean closeable, Consumer<String> renameHandler) {
        this(player, TextComponent.fromLegacyText((String)title), upperGui, lowerGui, closeable, renameHandler);
    }

    public AnvilSplitWindow(Player player, String title, GUI upperGui, GUI lowerGui, Consumer<String> renameHandler) {
        this(player, title, upperGui, lowerGui, true, renameHandler);
    }

    @Override
    protected void setUpperInvItem(int slot, ItemStack itemStack) {
        this.anvilInventory.setItem(slot, itemStack);
    }

    @Override
    public void show() {
        if (this.isClosed()) {
            throw new IllegalStateException("The Window has already been closed.");
        }
        Player viewer = this.getViewer();
        if (viewer == null) {
            throw new IllegalStateException("The player is not online.");
        }
        this.anvilInventory.open();
    }

    public String getRenameText() {
        return this.anvilInventory.getRenameText();
    }
}

