/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window.impl.merged;

import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.util.Pair;
import de.studiocode.invui.util.SlotUtils;
import de.studiocode.invui.window.impl.BaseWindow;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public abstract class MergedWindow
extends BaseWindow {
    private final Inventory playerInventory;
    private final ItemStack[] playerItems = new ItemStack[36];
    protected Inventory upperInventory;
    private boolean isCurrentlyOpened;

    public MergedWindow(Player player, ComponentWrapper title, int size, Inventory upperInventory, boolean closeable, boolean removeOnClose) {
        super(player.getUniqueId(), title, size, closeable, removeOnClose);
        this.upperInventory = upperInventory;
        this.playerInventory = player.getInventory();
    }

    protected void initUpperItems() {
        for (int i = 0; i < this.upperInventory.getSize(); ++i) {
            SlotElement element = this.getSlotElement(i);
            this.redrawItem(i, element, true);
        }
    }

    private void initPlayerItems() {
        for (int i = this.upperInventory.getSize(); i < this.upperInventory.getSize() + 36; ++i) {
            SlotElement element = this.getSlotElement(i);
            this.redrawItem(i, element, true);
        }
    }

    private void clearPlayerInventory() {
        PlayerInventory inventory = this.getViewer().getInventory();
        for (int i = 0; i < 36; ++i) {
            this.playerItems[i] = inventory.getItem(i);
            inventory.setItem(i, null);
        }
    }

    private void restorePlayerInventory() {
        PlayerInventory inventory = this.getViewer().getInventory();
        for (int i = 0; i < 36; ++i) {
            inventory.setItem(i, this.playerItems[i]);
        }
    }

    @Override
    protected void redrawItem(int index, SlotElement element, boolean setItem) {
        super.redrawItem(index, element, setItem);
        if (this.getViewer() != null) {
            this.getViewer().updateInventory();
        }
    }

    @Override
    protected void setInvItem(int slot, ItemStack itemStack) {
        if (slot >= this.upperInventory.getSize()) {
            if (this.isCurrentlyOpened) {
                int invSlot = SlotUtils.translateGuiToPlayerInv(slot - this.upperInventory.getSize());
                this.setPlayerInvItem(invSlot, itemStack);
            }
        } else {
            this.setUpperInvItem(slot, itemStack);
        }
    }

    protected void setUpperInvItem(int slot, ItemStack itemStack) {
        this.upperInventory.setItem(slot, itemStack);
    }

    protected void setPlayerInvItem(int slot, ItemStack itemStack) {
        this.playerInventory.setItem(slot, itemStack);
    }

    @Override
    public void handleViewerDeath(PlayerDeathEvent event) {
        if (this.isCurrentlyOpened) {
            List drops = event.getDrops();
            if (!event.getKeepInventory()) {
                drops.clear();
                Arrays.stream(this.playerItems).filter(Objects::nonNull).forEach(drops::add);
            }
        }
    }

    @Override
    protected void handleOpened() {
        InventoryAccess.getPlayerUtils().stopAdvancementListening(this.getViewer());
        this.isCurrentlyOpened = true;
        this.clearPlayerInventory();
        this.initPlayerItems();
    }

    @Override
    protected void handleClosed() {
        this.isCurrentlyOpened = false;
        this.restorePlayerInventory();
        InventoryAccess.getPlayerUtils().startAdvancementListening(this.getViewer());
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        Pair<GUI, Integer> clicked = this.getWhereClicked(event);
        clicked.getFirst().handleClick(clicked.getSecond(), (Player)event.getWhoClicked(), event.getClick(), event);
    }

    @Override
    public void handleItemShift(InventoryClickEvent event) {
    }

    @Override
    public void handleCursorCollect(InventoryClickEvent event) {
    }

    @Override
    public Inventory[] getInventories() {
        Inventory[] inventoryArray;
        if (this.isCurrentlyOpened) {
            Inventory[] inventoryArray2 = new Inventory[2];
            inventoryArray2[0] = this.upperInventory;
            inventoryArray = inventoryArray2;
            inventoryArray2[1] = this.playerInventory;
        } else {
            Inventory[] inventoryArray3 = new Inventory[1];
            inventoryArray = inventoryArray3;
            inventoryArray3[0] = this.upperInventory;
        }
        return inventoryArray;
    }

    public Inventory getUpperInventory() {
        return this.upperInventory;
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    @Override
    protected abstract SlotElement getSlotElement(int var1);

    protected abstract Pair<GUI, Integer> getWhereClicked(InventoryClickEvent var1);
}

