/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.window;

import de.studiocode.invui.InvUI;
import de.studiocode.invui.window.Window;
import de.studiocode.invui.window.impl.merged.MergedWindow;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Nullable;

public class WindowManager
implements Listener {
    private static WindowManager instance;
    private final Map<Inventory, Window> windows = new HashMap<Inventory, Window>();
    private final Map<Player, Window> openWindows = new HashMap<Player, Window>();

    private WindowManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, InvUI.getInstance().getPlugin());
        InvUI.getInstance().addDisableHandler(() -> this.getWindows().forEach(window -> window.close(true)));
    }

    public static WindowManager getInstance() {
        return instance == null ? (instance = new WindowManager()) : instance;
    }

    public void addWindow(Window window) {
        this.windows.put(window.getInventories()[0], window);
    }

    public void removeWindow(Window window) {
        this.windows.remove(window.getInventories()[0]);
    }

    @Nullable
    public Window getWindow(Inventory inventory) {
        return this.windows.get(inventory);
    }

    @Nullable
    public Window getOpenWindow(Player player) {
        return this.openWindows.get(player);
    }

    public Set<Window> getWindows() {
        return new HashSet<Window>(this.windows.values());
    }

    public Set<Window> getOpenWindows() {
        return new HashSet<Window>(this.openWindows.values());
    }

    @EventHandler
    private void handleInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Window window = this.getOpenWindow(player);
        if (window != null) {
            Inventory clicked = event.getClickedInventory();
            if (Arrays.asList(window.getInventories()).contains(clicked)) {
                window.handleClick(event);
            } else {
                switch (event.getAction()) {
                    case MOVE_TO_OTHER_INVENTORY: {
                        window.handleItemShift(event);
                        break;
                    }
                    case COLLECT_TO_CURSOR: {
                        window.handleCursorCollect(event);
                    }
                }
            }
        }
    }

    @EventHandler
    private void handleInventoryDrag(InventoryDragEvent event) {
        Window window = this.getOpenWindow((Player)event.getWhoClicked());
        if (window != null) {
            window.handleDrag(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void handleInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Window window = this.getWindow(event.getInventory());
        if (window != null) {
            window.handleClose(player);
        }
        this.openWindows.remove(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void handleInventoryOpen(InventoryOpenEvent event) {
        Window window = this.getWindow(event.getInventory());
        if (window != null) {
            window.handleOpen(event);
            this.openWindows.put((Player)event.getPlayer(), window);
        }
    }

    @EventHandler
    private void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Window window = this.getOpenWindow(player);
        if (window != null) {
            window.handleClose(player);
            this.openWindows.remove(player);
        }
    }

    @EventHandler
    private void handlePlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Window window = this.getOpenWindow(player);
        if (window != null) {
            window.handleViewerDeath(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void handleItemPickup(EntityPickupItemEvent event) {
        Window window;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (window = this.getOpenWindow((Player)entity)) instanceof MergedWindow) {
            event.setCancelled(true);
        }
    }
}

