/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.virtualinventory;

import de.studiocode.inventoryaccess.version.InventoryAccess;
import de.studiocode.invui.InvUI;
import de.studiocode.invui.util.DataUtils;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VirtualInventoryManager {
    private static final File SAVE_DIR = new File("plugins/InvUI/VirtualInventory/" + InvUI.getInstance().getPlugin().getName() + "/");
    private static VirtualInventoryManager instance;
    private final Map<UUID, VirtualInventory> inventories = new HashMap<UUID, VirtualInventory>();

    private VirtualInventoryManager() {
        SAVE_DIR.mkdirs();
        InvUI.getInstance().addDisableHandler(this::serializeAll);
        this.deserializeAll();
    }

    public static VirtualInventoryManager getInstance() {
        return instance == null ? (instance = new VirtualInventoryManager()) : instance;
    }

    public VirtualInventory createNew(@NotNull UUID uuid, int size) {
        if (this.inventories.containsKey(uuid)) {
            throw new IllegalArgumentException("A VirtualInventory with that UUID already exists");
        }
        VirtualInventory virtualInventory = new VirtualInventory(uuid, size);
        this.inventories.put(uuid, virtualInventory);
        return virtualInventory;
    }

    public VirtualInventory createNew(@NotNull UUID uuid, int size, ItemStack[] items, int[] stackSizes) {
        if (this.inventories.containsKey(uuid)) {
            throw new IllegalArgumentException("A Virtual Inventory with that UUID already exists");
        }
        VirtualInventory virtualInventory = new VirtualInventory(uuid, size, items, stackSizes);
        this.inventories.put(uuid, virtualInventory);
        return virtualInventory;
    }

    public VirtualInventory getByUuid(@NotNull UUID uuid) {
        return this.inventories.get(uuid);
    }

    public VirtualInventory getOrCreate(UUID uuid, int size) {
        VirtualInventory virtualInventory = this.getByUuid(uuid);
        return virtualInventory == null ? this.createNew(uuid, size) : virtualInventory;
    }

    public VirtualInventory getOrCreate(UUID uuid, int size, ItemStack[] items, int[] stackSizes) {
        VirtualInventory virtualInventory = this.getByUuid(uuid);
        return virtualInventory == null ? this.createNew(uuid, size, items, stackSizes) : virtualInventory;
    }

    public List<VirtualInventory> getAllInventories() {
        return new ArrayList<VirtualInventory>(this.inventories.values());
    }

    public void remove(VirtualInventory virtualInventory) {
        this.inventories.remove(virtualInventory.getUuid(), virtualInventory);
        this.getSaveFile(virtualInventory).delete();
    }

    private void deserializeAll() {
        if (SAVE_DIR.exists()) {
            Arrays.stream(SAVE_DIR.listFiles()).forEach(file -> {
                if (file.getName().endsWith(".vi2")) {
                    try {
                        FileInputStream in = new FileInputStream((File)file);
                        VirtualInventory virtualInventory = this.deserializeInventory(in);
                        this.inventories.put(virtualInventory.getUuid(), virtualInventory);
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void serializeAll() {
        this.inventories.values().forEach(virtualInventory -> {
            try {
                File file = this.getSaveFile((VirtualInventory)virtualInventory);
                FileOutputStream out = new FileOutputStream(file);
                this.serializeInventory((VirtualInventory)virtualInventory, out);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private File getSaveFile(VirtualInventory virtualInventory) {
        return new File(SAVE_DIR, virtualInventory.getUuid() + ".vi2");
    }

    public byte[] serializeInventory(VirtualInventory vi) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializeInventory(vi, out);
        return out.toByteArray();
    }

    public void serializeInventory(VirtualInventory vi, OutputStream out) {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            UUID uuid = vi.getUuid();
            dos.writeLong(uuid.getMostSignificantBits());
            dos.writeLong(uuid.getLeastSignificantBits());
            dos.writeByte(3);
            DataUtils.writeByteArray(dos, DataUtils.toByteArray(vi.getStackSizes()));
            byte[][] items = (byte[][])Arrays.stream(vi.getItems()).map(itemStack -> {
                if (itemStack != null) {
                    return InventoryAccess.getItemUtils().serializeItemStack((ItemStack)itemStack, true);
                }
                return new byte[0];
            }).toArray(x$0 -> new byte[x$0][]);
            DataUtils.write2DByteArray(dos, items);
            dos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public VirtualInventory deserializeInventory(byte[] bytes) {
        return this.deserializeInventory(new ByteArrayInputStream(bytes));
    }

    public VirtualInventory deserializeInventory(InputStream in) {
        try {
            DataInputStream din = new DataInputStream(in);
            UUID uuid = new UUID(din.readLong(), din.readLong());
            din.readByte();
            int[] stackSizes = DataUtils.toIntArray(DataUtils.readByteArray(din));
            ItemStack[] items = (ItemStack[])Arrays.stream(DataUtils.read2DByteArray(din)).map(data -> {
                if (((byte[])data).length != 0) {
                    return InventoryAccess.getItemUtils().deserializeItemStack((byte[])data, true);
                }
                return null;
            }).toArray(ItemStack[]::new);
            return new VirtualInventory(uuid, stackSizes.length, items, stackSizes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

