/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.util;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.virtualinventory.StackSizeProvider;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    public static StackSizeProvider stackSizeProvider = ItemStack::getMaxStackSize;

    public static int addItemCorrectly(@NotNull Inventory inventory, @NotNull ItemStack itemStack) {
        return InventoryUtils.addItemCorrectly(inventory, itemStack, new boolean[inventory.getSize()]);
    }

    public static int addItemCorrectly(@NotNull Inventory inventory, @NotNull ItemStack itemStack, boolean @NotNull [] blockedSlots) {
        int emptySlot;
        ItemStack partialStack;
        int amountLeft;
        int addableAmount;
        int maxStackSize = Math.min(inventory.getMaxStackSize(), stackSizeProvider.getMaxStackSize(itemStack));
        for (amountLeft = itemStack.getAmount(); amountLeft > 0 && (partialStack = InventoryUtils.getFirstPartialStack(inventory, itemStack, blockedSlots)) != null; amountLeft -= addableAmount) {
            int partialAmount = partialStack.getAmount();
            addableAmount = Math.max(0, Math.min(amountLeft, maxStackSize - partialAmount));
            partialStack.setAmount(partialAmount + addableAmount);
        }
        while (amountLeft > 0 && (emptySlot = InventoryUtils.getFirstEmptySlot(inventory, blockedSlots)) != -1) {
            int addableAmount2 = Math.min(amountLeft, maxStackSize);
            ItemStack newStack = itemStack.clone();
            newStack.setAmount(addableAmount2);
            inventory.setItem(emptySlot, newStack);
            amountLeft -= addableAmount2;
        }
        return amountLeft;
    }

    @Nullable
    public static ItemStack getFirstPartialStack(@NotNull Inventory inventory, @NotNull ItemStack type) {
        return InventoryUtils.getFirstPartialStack(inventory, type, new boolean[inventory.getSize()]);
    }

    @Nullable
    public static ItemStack getFirstPartialStack(@NotNull Inventory inventory, @NotNull ItemStack type, boolean @NotNull [] blockedSlots) {
        int maxStackSize = stackSizeProvider.getMaxStackSize(type);
        ItemStack[] storageContents = inventory.getStorageContents();
        for (int i = 0; i < storageContents.length; ++i) {
            int amount;
            ItemStack item;
            if (blockedSlots[i] || InventoryUtils.isInvalidSlot(inventory, i) || !type.isSimilar(item = storageContents[i]) || (amount = item.getAmount()) >= maxStackSize) continue;
            return item;
        }
        return null;
    }

    public static int getFirstEmptySlot(@NotNull Inventory inventory) {
        return InventoryUtils.getFirstEmptySlot(inventory, new boolean[inventory.getSize()]);
    }

    public static int getFirstEmptySlot(@NotNull Inventory inventory, boolean @NotNull [] blockedSlots) {
        ItemStack[] storageContents = inventory.getStorageContents();
        for (int i = 0; i < storageContents.length; ++i) {
            ItemStack item;
            if (blockedSlots[i] || InventoryUtils.isInvalidSlot(inventory, i) || (item = storageContents[i]) != null && !item.getType().isAir()) continue;
            return i;
        }
        return -1;
    }

    private static boolean isInvalidSlot(@NotNull Inventory inventory, int slot) {
        if (inventory instanceof CraftingInventory) {
            return slot == 0;
        }
        return false;
    }

    public static Inventory createMatchingInventory(@NotNull GUI gui, @NotNull String title) {
        InventoryType type;
        if (gui.getWidth() == 9) {
            type = null;
        } else if (gui.getWidth() == 3 && gui.getHeight() == 3) {
            type = InventoryType.DROPPER;
        } else if (gui.getWidth() == 5 && gui.getHeight() == 1) {
            type = InventoryType.HOPPER;
        } else {
            throw new UnsupportedOperationException("Invalid bounds of GUI");
        }
        if (type == null) {
            return Bukkit.createInventory(null, (int)gui.getSize(), (String)title);
        }
        return Bukkit.createInventory(null, type, (String)title);
    }

    public static boolean containsSimilar(@NotNull Inventory inventory, @Nullable ItemStack itemStack) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack currentStack = inventory.getItem(i);
            if (currentStack != null && currentStack.getType().isAir()) {
                currentStack = null;
            }
            if ((currentStack != null || itemStack != null) && (currentStack == null || !currentStack.isSimilar(itemStack))) continue;
            return true;
        }
        return false;
    }

    public static void dropItemLikePlayer(@NotNull Player player, @NotNull ItemStack itemStack) {
        Location location = player.getLocation();
        location.add(0.0, 1.5, 0.0);
        Item item = location.getWorld().dropItem(location, itemStack);
        item.setPickupDelay(40);
        item.setVelocity(location.getDirection().multiply(0.35));
    }
}

