/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.item.impl;

import de.studiocode.invui.InvUI;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.impl.BaseItem;
import de.studiocode.invui.window.Window;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class AutoCycleItem
extends BaseItem {
    private final ItemProvider[] itemProviders;
    private final int period;
    private BukkitTask task;
    private int state;

    public AutoCycleItem(int period, ItemProvider ... itemProviders) {
        this.itemProviders = itemProviders;
        this.period = period;
    }

    public void start() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Bukkit.getScheduler().runTaskTimer(InvUI.getInstance().getPlugin(), this::cycle, 0L, (long)this.period);
    }

    public void cancel() {
        this.task.cancel();
        this.task = null;
    }

    private void cycle() {
        ++this.state;
        if (this.state == this.itemProviders.length) {
            this.state = 0;
        }
        this.notifyWindows();
    }

    @Override
    public ItemProvider getItemProvider() {
        return this.itemProviders[this.state];
    }

    @Override
    public void addWindow(Window window) {
        super.addWindow(window);
        if (this.task == null) {
            this.start();
        }
    }

    @Override
    public void removeWindow(Window window) {
        super.removeWindow(window);
        if (this.getWindows().isEmpty() && this.task != null) {
            this.cancel();
        }
    }

    @Override
    public void handleClick(@NotNull ClickType clickType, @NotNull Player player, @NotNull InventoryClickEvent event) {
    }
}

