/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.item.builder;

import de.studiocode.invui.item.builder.BaseItemBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;

public class PotionBuilder
extends BaseItemBuilder<PotionBuilder> {
    private List<PotionEffect> effects = new ArrayList<PotionEffect>();
    private org.bukkit.Color color;
    private PotionData basePotionData;

    public PotionBuilder(PotionType type) {
        super(type.getMaterial());
    }

    public PotionBuilder(ItemStack base) {
        super(base);
    }

    public PotionBuilder setColor(org.bukkit.Color color) {
        this.color = color;
        return this;
    }

    public PotionBuilder setColor(Color color) {
        this.color = org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
        return this;
    }

    public PotionBuilder setBasePotionData(PotionData basePotionData) {
        this.basePotionData = basePotionData;
        return this;
    }

    public PotionBuilder addEffect(PotionEffect effect) {
        this.effects.add(effect);
        return this;
    }

    @Override
    public ItemStack get() {
        ItemStack item = super.get();
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        meta.clearCustomEffects();
        if (this.color != null) {
            meta.setColor(this.color);
        }
        if (this.basePotionData != null) {
            meta.setBasePotionData(this.basePotionData);
        }
        this.effects.forEach(effect -> meta.addCustomEffect(effect, true));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Override
    public PotionBuilder clone() {
        PotionBuilder builder = (PotionBuilder)super.clone();
        builder.effects = new ArrayList<PotionEffect>(this.effects);
        return builder;
    }

    @Override
    protected PotionBuilder getThis() {
        return this;
    }

    public static enum PotionType {
        NORMAL(Material.POTION),
        SPLASH(Material.SPLASH_POTION),
        LINGERING(Material.LINGERING_POTION);

        private final Material material;

        private PotionType(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }
    }
}

