/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.structure;

import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.structure.Ingredient;
import de.studiocode.invui.gui.structure.IngredientList;
import de.studiocode.invui.gui.structure.Marker;
import de.studiocode.invui.gui.structure.VISlotElementSupplier;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.ItemWrapper;
import de.studiocode.invui.item.impl.SimpleItem;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import java.util.HashMap;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Structure
implements Cloneable {
    private static final HashMap<Character, Ingredient> globalIngredientMap = new HashMap();
    private final String structureData;
    private final int width;
    private final int height;
    private HashMap<Character, Ingredient> ingredientMap = new HashMap();
    private IngredientList ingredientList;

    public Structure(String ... structureData) {
        this(Structure.sanitize(structureData[0]).length(), structureData.length, String.join((CharSequence)"", structureData));
    }

    public Structure(int width, int height, String structureData) {
        this.width = width;
        this.height = height;
        this.structureData = Structure.sanitize(structureData);
        if (width * height != this.structureData.length()) {
            throw new IllegalArgumentException("Length of structure data does not match width * height");
        }
    }

    private static String sanitize(String s) {
        return s.replace(" ", "").replace("\n", "");
    }

    public static void addGlobalIngredient(char key, @NotNull ItemStack itemStack) {
        Structure.addGlobalIngredient(key, new ItemWrapper(itemStack));
    }

    public static void addGlobalIngredient(char key, @NotNull ItemProvider itemProvider) {
        Structure.addGlobalIngredient(key, new SimpleItem(itemProvider));
    }

    public static void addGlobalIngredient(char key, @NotNull Item item) {
        Structure.addGlobalIngredient(key, new SlotElement.ItemSlotElement(item));
    }

    public static void addGlobalIngredient(char key, @NotNull Supplier<? extends Item> itemSupplier) {
        Structure.addGlobalIngredientElementSupplier(key, () -> new SlotElement.ItemSlotElement((Item)itemSupplier.get()));
    }

    public static void addGlobalIngredient(char key, @NotNull SlotElement element) {
        globalIngredientMap.put(Character.valueOf(key), new Ingredient(element));
    }

    public static void addGlobalIngredient(char key, @NotNull Marker marker) {
        globalIngredientMap.put(Character.valueOf(key), new Ingredient(marker));
    }

    public static void addGlobalIngredientElementSupplier(char key, @NotNull Supplier<? extends SlotElement> elementSupplier) {
        globalIngredientMap.put(Character.valueOf(key), new Ingredient(elementSupplier));
    }

    public Structure addIngredient(char key, @NotNull ItemStack itemStack) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredient(key, new ItemWrapper(itemStack));
    }

    public Structure addIngredient(char key, @NotNull ItemProvider itemProvider) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredient(key, new SimpleItem(itemProvider));
    }

    public Structure addIngredient(char key, @NotNull Item item) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredient(key, new SlotElement.ItemSlotElement(item));
    }

    public Structure addIngredient(char key, @NotNull VirtualInventory inventory) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredientElementSupplier(key, new VISlotElementSupplier(inventory));
    }

    public Structure addIngredient(char key, @NotNull VirtualInventory inventory, @Nullable ItemProvider background) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredientElementSupplier(key, new VISlotElementSupplier(inventory, background));
    }

    public Structure addIngredient(char key, @NotNull SlotElement element) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(element));
        return this;
    }

    public Structure addIngredient(char key, @NotNull Marker marker) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(marker));
        return this;
    }

    public Structure addIngredient(char key, @NotNull Supplier<? extends Item> itemSupplier) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(() -> new SlotElement.ItemSlotElement((Item)itemSupplier.get())));
        return this;
    }

    public Structure addIngredientElementSupplier(char key, @NotNull Supplier<? extends SlotElement> elementSupplier) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(elementSupplier));
        return this;
    }

    public IngredientList getIngredientList() {
        if (this.ingredientList != null) {
            return this.ingredientList;
        }
        HashMap<Character, Ingredient> ingredients = new HashMap<Character, Ingredient>(globalIngredientMap);
        ingredients.putAll(this.ingredientMap);
        this.ingredientList = new IngredientList(this.width, this.height, this.structureData, ingredients);
        return this.ingredientList;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Structure clone() {
        try {
            Structure clone = (Structure)super.clone();
            clone.ingredientMap = new HashMap<Character, Ingredient>(this.ingredientMap);
            clone.ingredientList = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

